/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class SnowParticle
extends SingleQuadParticle {
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    protected SnowParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, TextureAtlasSprite sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
        this.lifetime = 20;
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        this.pos.set(this.x, this.y, this.z);
        this.oRoll = this.roll;
        this.roll = this.oRoll + 0.1f;
        if (this.onGround || this.level.getFluidState((BlockPos)this.pos).is((Fluid)Fluids.WATER)) {
            this.remove();
        }
    }

    public record FreezingProvider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            SnowParticle particle = new SnowParticle(level, x, y, z, 0.0, 0.0, 0.0, this.sprites.get(random));
            particle.gravity = 0.05f;
            particle.xd = 0.0;
            particle.yd = -0.05f;
            particle.zd = 0.0;
            return particle;
        }
    }

    public record SnowballTrailProvider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        private static final float GRAVITY = 0.1f;

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            SnowParticle particle = new SnowParticle(level, x, y, z, 0.0, 0.0, 0.0, this.sprites.get(random));
            particle.gravity = 0.1f;
            particle.xd = 0.0;
            particle.yd = -0.1f;
            particle.zd = 0.0;
            return particle;
        }
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            SnowParticle particle = new SnowParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites.get(random));
            particle.gravity = 1.0f;
            return particle;
        }
    }
}

