/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.particle.option.SplashDropletParticleOptions;
import einstein.subtle_effects.util.DripParticleAccessor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class SplashDropletParticle
extends DripParticle.FallAndLandParticle
implements DripParticleAccessor {
    private final boolean glowing;

    protected SplashDropletParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float scale, TextureAtlasSprite sprite, boolean glowing, Fluid fluid, SimpleParticleType landParticle, boolean isSilent) {
        super(level, x, y, z, fluid, (ParticleOptions)landParticle, sprite);
        this.glowing = glowing;
        this.setParticleSpeed(xSpeed, ySpeed, zSpeed);
        this.scale(scale * 1.5f);
        this.gravity = 0.06f;
        if (isSilent) {
            this.subtleEffects$setSilent();
        }
    }

    public int getLightColor(float partialTick) {
        if (this.glowing) {
            return 240;
        }
        return super.getLightColor(partialTick);
    }

    public void tick() {
        super.tick();
        if (this.y == this.yo) {
            this.remove();
        }
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public record LavaProvider(SpriteSet sprites) implements ParticleProvider<SplashDropletParticleOptions>
    {
        public Particle createParticle(SplashDropletParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return new SplashDropletParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, options.scale(), this.sprites.get(random), true, (Fluid)Fluids.LAVA, ParticleTypes.LANDING_LAVA, options.isSilent());
        }
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SplashDropletParticleOptions>
    {
        public Particle createParticle(SplashDropletParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            SplashDropletParticle particle = new SplashDropletParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, options.scale(), this.sprites.get(random), false, (Fluid)Fluids.WATER, ParticleTypes.SPLASH, options.isSilent());
            int waterColor = ((Biome)level.getBiome(BlockPos.containing((double)x, (double)y, (double)z)).value()).getWaterColor();
            float colorIntensity = options.colorIntensity();
            float whiteIntensity = 1.0f - colorIntensity;
            float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(waterColor & 0xFF) / 255.0f;
            particle.setColor(whiteIntensity + colorIntensity * red, whiteIntensity + colorIntensity * green, whiteIntensity + colorIntensity * blue);
            return particle;
        }
    }
}

