/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle.emitter;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.particle.option.SplashDropletParticleOptions;
import einstein.subtle_effects.particle.option.SplashEmitterParticleOptions;
import einstein.subtle_effects.particle.option.SplashParticleOptions;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class SplashEmitter
extends NoRenderParticle {
    @Nullable
    private final Entity entity;
    private final float velocity;
    private final float absVelocity;
    private final boolean isLava;
    private final TagKey<Fluid> fluidTag;
    private final float widthModifier;
    private final float heightModifier;
    private final float xScale;
    private final float yScale;
    private final ParticleType<SplashParticleOptions> splashParticle;
    private final ParticleType<FloatParticleOptions> splashRippleParticle;
    private final ParticleType<SplashDropletParticleOptions> dropletParticle;
    private final BlockPos.MutableBlockPos pos;
    private boolean firstSplash = true;
    private boolean secondSplash = true;

    protected SplashEmitter(ClientLevel level, double x, double y, double z, TagKey<Fluid> fluidTag, ParticleType<SplashParticleOptions> splashParticle, ParticleType<FloatParticleOptions> splashRippleParticle, ParticleType<SplashDropletParticleOptions> dropletParticle, boolean isLava, SplashEmitterParticleOptions options) {
        super(level, x, y, z);
        this.fluidTag = fluidTag;
        this.splashRippleParticle = splashRippleParticle;
        this.isLava = isLava;
        this.splashParticle = splashParticle;
        this.dropletParticle = dropletParticle;
        this.lifetime = 8;
        this.pos = BlockPos.containing((double)x, (double)y, (double)z).mutable();
        this.velocity = options.velocity();
        this.absVelocity = Mth.abs((float)this.velocity);
        this.widthModifier = options.widthModifier();
        this.heightModifier = options.heightModifier();
        this.xScale = this.widthModifier + 0.5f;
        this.yScale = this.absVelocity * this.heightModifier * this.widthModifier * 2.0f;
        if (options.entityId() > -1) {
            this.entity = level.getEntity(options.entityId());
            return;
        }
        this.entity = null;
    }

    public static SplashEmitterParticleOptions createForEntity(Entity entity, ParticleType<SplashEmitterParticleOptions> splashParticle, double yVelocity) {
        float entityWidth = entity.getBbWidth();
        float entityHeight = entity.getBbHeight();
        Entity passenger = entity.getFirstPassenger();
        if (passenger != null) {
            entityWidth = Math.max(entityWidth, passenger.getBbWidth());
            entityHeight += passenger.getBbHeight() / 2.0f;
        }
        return new SplashEmitterParticleOptions(splashParticle, entityWidth, entityHeight, (float)yVelocity, entity.getId());
    }

    public void tick() {
        boolean isInFluid;
        if (this.removed) {
            return;
        }
        super.tick();
        this.pos.set(this.x, this.y, this.z);
        boolean bl = isInFluid = this.level.getFluidState((BlockPos)this.pos).is(this.fluidTag) || Util.getCauldronFluid(this.level.getBlockState((BlockPos)this.pos)).is(this.fluidTag);
        if (!isInFluid || this.onGround) {
            this.remove();
            return;
        }
        if (this.firstSplash) {
            this.spawnSplashParticles(this.xScale, this.yScale, this.yScale * 0.5f / this.widthModifier * 0.3f, this.xScale);
            this.firstSplash = false;
            if (ModConfigs.ENTITIES.splashes.splashBubbles && this.entity != null && this.level.getFluidState(this.pos.below()).is(FluidTags.WATER)) {
                int i = 0;
                while ((float)i < 8.0f * (this.widthModifier * 5.0f)) {
                    int xSign = MathUtil.nextSign(this.random);
                    int zSign = MathUtil.nextSign(this.random);
                    this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, this.x + MathUtil.nextDouble(this.random, 0.1) * (double)xSign, this.random.nextInt(3) == 0 ? Mth.nextDouble((RandomSource)this.random, (double)(this.entity.getY() + (double)this.heightModifier), (double)this.y) : this.entity.getRandomY(), this.z + MathUtil.nextDouble(this.random, 0.1) * (double)zSign, MathUtil.nextNonAbsDouble(this.random, this.xScale), (double)(-this.absVelocity * 2.0f) * Mth.nextDouble((RandomSource)this.random, (double)0.5, (double)2.0), MathUtil.nextNonAbsDouble(this.random, this.xScale));
                    ++i;
                }
            }
            if (!ModConfigs.ENTITIES.splashes.secondarySplash || this.velocity > -((Float)ModConfigs.ENTITIES.splashes.secondarySplashVelocityThreshold.get()).floatValue()) {
                this.remove();
            }
            return;
        }
        if (this.age >= this.lifetime && this.secondSplash) {
            this.spawnSplashParticles(this.xScale / 2.0f, this.yScale * 1.5f, this.yScale * 0.85f / this.widthModifier * 0.3f, this.xScale * 0.8f);
            this.secondSplash = false;
        }
    }

    private void spawnSplashParticles(float xScale, float yScale, float dropletYSpeed, float dropletXSpeed) {
        this.level.addAlwaysVisibleParticle((ParticleOptions)new SplashParticleOptions(this.splashParticle, xScale, yScale), true, this.x, this.y, this.z, 0.0, 0.0, 0.0);
        if (this.hasRipple()) {
            this.level.addAlwaysVisibleParticle((ParticleOptions)new FloatParticleOptions(this.splashRippleParticle, xScale), true, this.x, this.y, this.z, 0.0, 0.0, 0.0);
        }
        if (!ModConfigs.ENTITIES.splashes.splashDroplets) {
            return;
        }
        SplashDropletParticleOptions dropletOptions = new SplashDropletParticleOptions(this.dropletParticle, Math.min(this.xScale, 2.0f), this.isLava ? 1.0f : ((Float)ModConfigs.ENTITIES.splashes.splashOverlayTint.get()).floatValue());
        int i = 0;
        while ((float)i < 4.0f * this.widthModifier) {
            this.level.addParticle((ParticleOptions)dropletOptions, this.x + MathUtil.nextNonAbsDouble(this.random, xScale), this.y + MathUtil.nextDouble(this.random, 0.6) * (double)yScale, this.z + MathUtil.nextNonAbsDouble(this.random, xScale), 0.0, (double)dropletYSpeed, 0.0);
            ++i;
        }
        i = 0;
        while ((float)i < 8.0f * this.widthModifier) {
            int xSign = MathUtil.nextSign(this.random);
            int zSign = MathUtil.nextSign(this.random);
            this.level.addParticle((ParticleOptions)dropletOptions, this.x + MathUtil.nextDouble(this.random, xScale) * (double)xSign, this.y + MathUtil.nextDouble(this.random, 0.6) * (double)yScale, this.z + MathUtil.nextDouble(this.random, xScale) * (double)zSign, Mth.nextDouble((RandomSource)this.random, (double)0.01, (double)0.1) * (double)dropletXSpeed * (double)xSign, (double)dropletYSpeed, Mth.nextDouble((RandomSource)this.random, (double)0.01, (double)0.1) * (double)dropletXSpeed * (double)zSign);
            ++i;
        }
    }

    private boolean hasRipple() {
        if (ModConfigs.ENTITIES.splashes.splashRipples) {
            if (!ModConfigs.ENTITIES.splashes.lavaSplashRipples && this.isLava) {
                return false;
            }
            return this.firstSplash || this.secondSplash && ModConfigs.ENTITIES.splashes.secondarySplashRipples;
        }
        return false;
    }

    public record LavaProvider() implements ParticleProvider<SplashEmitterParticleOptions>
    {
        public Particle createParticle(SplashEmitterParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return new SplashEmitter(level, x, y, z, (TagKey<Fluid>)FluidTags.LAVA, ModParticles.LAVA_SPLASH.get(), ModParticles.LAVA_SPLASH_RIPPLE.get(), ModParticles.LAVA_SPLASH_DROPLET.get(), true, options);
        }
    }

    public record Provider() implements ParticleProvider<SplashEmitterParticleOptions>
    {
        public Particle createParticle(SplashEmitterParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return new SplashEmitter(level, x, y, z, (TagKey<Fluid>)FluidTags.WATER, ModParticles.WATER_SPLASH.get(), ModParticles.WATER_SPLASH_RIPPLE.get(), ModParticles.WATER_SPLASH_DROPLET.get(), false, options);
        }
    }
}

