/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking.tickers.entity;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.mixin.client.block.AbstractCauldronBlockAccessor;
import einstein.subtle_effects.mixin.common.entity.EntityAccessor;
import einstein.subtle_effects.ticking.tickers.entity.EntityTicker;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public class EntityCauldronTicker
extends EntityTicker<Entity> {
    private boolean wasInWaterCauldron;
    private boolean wasInLavaCauldron;

    public EntityCauldronTicker(Entity entity) {
        super(entity);
    }

    @Override
    public void entityTick() {
        BlockPos pos = this.entity.blockPosition();
        BlockState state = this.entity.getInBlockState();
        double height = Util.getCauldronFillHeight(state);
        if ((state.is(Blocks.POWDER_SNOW_CAULDRON) || state.is(Blocks.WATER_CAULDRON)) && height > 0.0 && this.entity.isOnFire() && EntityCauldronTicker.isEntityInsideContent(state, pos, this.entity)) {
            ((EntityAccessor)this.entity).playExtinguishedSound();
        }
        if (height > 0.0 && (double)pos.getY() + height >= this.entity.getY()) {
            if (state.is(Blocks.WATER_CAULDRON) && !this.wasInWaterCauldron) {
                this.wasInWaterCauldron = true;
                ((EntityAccessor)this.entity).doWaterSplashingEffects();
            } else if (state.is(Blocks.LAVA_CAULDRON) && !this.wasInLavaCauldron && ModConfigs.ENTITIES.splashes.lavaSplashes) {
                this.wasInLavaCauldron = true;
                ParticleSpawnUtil.spawnSplashEffects(this.entity, this.level, ModParticles.LAVA_SPLASH_EMITTER.get(), (TagKey<Fluid>)FluidTags.LAVA);
            }
            return;
        }
        this.wasInWaterCauldron = false;
        this.wasInLavaCauldron = false;
    }

    private static boolean isEntityInsideContent(BlockState state, BlockPos pos, Entity entity) {
        Block block = state.getBlock();
        if (block instanceof AbstractCauldronBlockAccessor) {
            AbstractCauldronBlockAccessor cauldronBlock = (AbstractCauldronBlockAccessor)block;
            return entity.getY() < (double)pos.getY() + cauldronBlock.getFillHeight(state) && entity.getBoundingBox().maxY > (double)pos.getY() + 0.25;
        }
        return false;
    }
}

