/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.util;

import einstein.subtle_effects.configs.ModBlockConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.mixin.client.item.BucketItemAccessor;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityFellPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityLandInFluidPayload;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.particle.emitter.SplashEmitter;
import einstein.subtle_effects.particle.option.ColorAndIntegerParticleOptions;
import einstein.subtle_effects.particle.option.DirectionParticleOptions;
import einstein.subtle_effects.particle.option.SheepFluffParticleOptions;
import einstein.subtle_effects.particle.option.SplashEmitterParticleOptions;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.util.Box;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.StonecutterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ParticleSpawnUtil {
    public static void spawnSparks(Level level, RandomSource random, BlockPos pos, SparkType sparkType, Box box, Vec3 maxSpeeds, int count, List<Integer> colors) {
        if (random.nextBoolean()) {
            Vec3 start = box.min();
            Vec3 end = box.max();
            for (int i = 0; i < count; ++i) {
                level.addParticle((ParticleOptions)SparkParticle.create(sparkType, random, colors), (double)pos.getX() + Mth.nextDouble((RandomSource)random, (double)start.x, (double)end.x), (double)pos.getY() + Mth.nextDouble((RandomSource)random, (double)start.y, (double)end.y), (double)pos.getZ() + Mth.nextDouble((RandomSource)random, (double)start.z, (double)end.z), MathUtil.nextNonAbsDouble(random, maxSpeeds.x()), MathUtil.nextNonAbsDouble(random, maxSpeeds.y()), MathUtil.nextNonAbsDouble(random, maxSpeeds.z()));
            }
        }
    }

    public static void spawnParticlesAroundBlock(ParticleOptions particle, Level level, BlockPos pos, RandomSource random, int perSideChance) {
        ParticleSpawnUtil.spawnParticlesAroundBlock(particle, level, pos, random, 0.0625f, perSideChance > 0 ? direction -> random.nextInt(perSideChance) != 0 : null);
    }

    public static void spawnParticlesAroundBlock(ParticleOptions particle, Level level, BlockPos pos, RandomSource random, float offset, @Nullable Predicate<Direction> predicate) {
        for (Direction direction : Direction.values()) {
            if (predicate != null && predicate.test(direction)) {
                return;
            }
            BlockPos relativePos = pos.relative(direction);
            if (level.getBlockState(relativePos).isSolidRender()) continue;
            ParticleSpawnUtil.spawnParticlesOnSide(particle, offset, direction, level, pos, random, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnParticlesOnSide(ParticleOptions particle, float offset, Direction direction, Level level, BlockPos pos, RandomSource random, double xSpeed, double ySpeed, double zSpeed) {
        double offsetFromCenter = 0.5 + (double)offset;
        Direction.Axis axis = direction.getAxis();
        double xOffset = axis == Direction.Axis.X ? 0.5 + offsetFromCenter * (double)direction.getStepX() : (double)random.nextFloat();
        double yOffset = axis == Direction.Axis.Y ? 0.5 + offsetFromCenter * (double)direction.getStepY() : (double)random.nextFloat();
        double zOffset = axis == Direction.Axis.Z ? 0.5 + offsetFromCenter * (double)direction.getStepZ() : (double)random.nextFloat();
        level.addParticle(particle, (double)pos.getX() + xOffset, (double)pos.getY() + yOffset, (double)pos.getZ() + zOffset, xSpeed, ySpeed, zSpeed);
    }

    public static void spawnFallDustClouds(Entity entity, float distance, int fallDamage, ClientBoundEntityFellPayload.TypeConfig config) {
        Level level = entity.level();
        if (level.isClientSide() && entity.equals((Object)Minecraft.getInstance().player)) {
            ParticleSpawnUtil.spawnEntityFellParticles((LivingEntity)entity, entity.getY(), distance, fallDamage, ModConfigs.ENTITIES.dustClouds.playerFell);
        } else if (level instanceof ServerLevel) {
            ServerPlayer player;
            ServerLevel serverLevel = (ServerLevel)level;
            Services.NETWORK.sendToClientsTracking(entity instanceof ServerPlayer ? (player = (ServerPlayer)entity) : null, serverLevel, entity.blockPosition(), new ClientBoundEntityFellPayload(entity.getId(), entity.getY(), distance, fallDamage, config));
        }
    }

    public static void spawnCreatureMovementDustClouds(LivingEntity entity, Level level, RandomSource random, int YSpeedModifier) {
        if (ModConfigs.ENTITIES.dustClouds.mobRunning) {
            ParticleSpawnUtil.spawnCreatureMovementDustCloudsNoConfig(entity, level, random, YSpeedModifier);
        }
    }

    public static void spawnCreatureMovementDustCloudsNoConfig(LivingEntity entity, Level level, RandomSource random, int YSpeedModifier) {
        if (ModConfigs.ENTITIES.dustClouds.preventWhenRaining && level.isRainingAt(entity.blockPosition())) {
            return;
        }
        if (entity.isInvisible()) {
            return;
        }
        level.addParticle((ParticleOptions)ModParticles.LARGE_DUST_CLOUD.get(), entity.position().x + (double)entity.getBbWidth() * random.nextDouble() - 1.0, entity.getY() + Math.max(Math.min((double)random.nextFloat(), 0.5), 0.2), entity.position().z + (double)entity.getBbWidth() * random.nextDouble() - 1.0, 0.0, random.nextDouble() * (double)YSpeedModifier, 0.0);
    }

    public static void spawnCmdBlockParticles(Level level, Vec3 pos, RandomSource random, BiPredicate<Direction, Vec3> directionValidator) {
        for (Direction direction : Direction.values()) {
            Vec3 endPos = pos.relative(direction, 1.0);
            Vec3 relativePos = endPos.relative(direction, -0.5);
            if (!(random.nextDouble() < (Double)ModConfigs.BLOCKS.commandBlockParticlesDensity.get()) || !directionValidator.test(direction, endPos)) continue;
            Vec3 speed = pos.vectorTo(relativePos).offsetRandom(random, 1.0f);
            level.addParticle((ParticleOptions)new DirectionParticleOptions(ModParticles.COMMAND_BLOCK.get(), direction), endPos.x(), endPos.y(), endPos.z(), speed.x(), speed.y(), speed.z());
        }
    }

    public static void spawnHeatedWaterParticles(Level level, BlockPos pos, RandomSource random, boolean isFalling, double height, boolean steamConfig, boolean boilingConfig) {
        int brightness = level.getBrightness(LightLayer.BLOCK, pos);
        height -= 0.1;
        switch (ModConfigs.BLOCKS.steam.spawnLogic) {
            case NEAR_LAVA: {
                for (int x = -1; x < 2; ++x) {
                    for (int y = -1; y < 2; ++y) {
                        for (int z = -1; z < 2; ++z) {
                            if (!level.getFluidState(pos.offset(x, y, z)).is(FluidTags.LAVA)) continue;
                            ParticleSpawnUtil.spawnHeatedWaterParticles(level, pos, random, isFalling, height, steamConfig, boilingConfig, brightness);
                        }
                    }
                }
                break;
            }
            case BRIGHTNESS: {
                if (brightness <= (Integer)ModConfigs.BLOCKS.steam.steamingThreshold.get() && !level.getBlockState(pos.below()).is(Blocks.MAGMA_BLOCK)) break;
                ParticleSpawnUtil.spawnHeatedWaterParticles(level, pos, random, isFalling, height, steamConfig, boilingConfig, brightness);
            }
        }
    }

    private static void spawnHeatedWaterParticles(Level level, BlockPos pos, RandomSource random, boolean isFalling, double height, boolean steamConfig, boolean boilingConfig, int brightness) {
        if (steamConfig && !isFalling && !Util.isSolidOrNotEmpty(level, pos.above())) {
            level.addParticle((ParticleOptions)ModParticles.STEAM.get(), (double)pos.getX() + random.nextDouble(), (double)pos.getY() + 0.875 + MathUtil.nextDouble(random, 0.5), (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
        if (boilingConfig && brightness >= (Integer)ModConfigs.BLOCKS.steam.boilingThreshold.get()) {
            level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, (double)pos.getX() + random.nextDouble(), Mth.clamp((double)random.nextDouble(), (double)pos.getY(), (double)((double)pos.getY() + height)), (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    public static void spawnEntityFellParticles(LivingEntity entity, double y, float distance, int fallDamage, boolean config) {
        if (!config || entity.getType().is(EntityTypeTags.FALL_DAMAGE_IMMUNE)) {
            return;
        }
        if (entity.isInvisible()) {
            return;
        }
        if (!(fallDamage > 0 || entity instanceof AbstractHorse && (double)distance > (entity instanceof Camel ? 0.5 : 1.0))) {
            return;
        }
        if (entity.isInWater() || entity.isInLava() || entity.isInPowderSnow) {
            return;
        }
        Level level = entity.level();
        RandomSource random = entity.getRandom();
        if (ModConfigs.ENTITIES.dustClouds.preventWhenRaining && level.isRainingAt(entity.blockPosition())) {
            return;
        }
        if (!level.getFluidState(entity.getOnPos().atY(Mth.floor((double)y))).isEmpty()) {
            return;
        }
        if (fallDamage < 4) {
            for (int i = 0; i < 5; ++i) {
                level.addParticle((ParticleOptions)ModParticles.SMALL_DUST_CLOUD.get(), entity.getRandomX(1.0), y + Math.max(Math.min((double)random.nextFloat(), 0.5), 0.2), entity.getRandomZ(1.0), 0.3 * (double)MathUtil.nextSign(random), random.nextDouble(), 0.3 * (double)MathUtil.nextSign(random));
            }
            return;
        }
        for (int i = 0; i < 10; ++i) {
            level.addParticle((ParticleOptions)ModParticles.LARGE_DUST_CLOUD.get(), entity.getRandomX(1.0), y + Math.max(Math.min((double)random.nextFloat(), 0.5), 0.2), entity.getRandomZ(1.0), 0.5 * (double)MathUtil.nextSign(random), random.nextDouble() * 3.0, 0.5 * (double)MathUtil.nextSign(random));
        }
    }

    public static void spawnEntityFaceParticle(ParticleOptions options, LivingEntity entity, Level level, RandomSource random, Vec3 offset, float partialTick) {
        ParticleSpawnUtil.spawnEntityFaceParticle(options, entity, level, random, new Vec3(((double)random.nextFloat() - 0.5) * 0.3, (double)(-random.nextFloat()) * 0.6 - 0.3, 0.6).add(offset), new Vec3(((double)random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1 + 0.05, 0.0), partialTick);
    }

    public static void spawnEntityFaceParticle(ParticleOptions options, LivingEntity entity, Level level, RandomSource random, Vec3 offset, Vec3 speed, float partialTick) {
        speed = speed.xRot(-entity.getViewXRot(partialTick) * ((float)Math.PI / 180));
        speed = speed.yRot(-entity.getViewYRot(partialTick) * ((float)Math.PI / 180));
        ParticleSpawnUtil.spawnEntityFaceParticle(options, entity, level, offset, speed, partialTick);
    }

    public static void spawnEntityFaceParticle(ParticleOptions options, LivingEntity entity, Level level, Vec3 offset, Vec3 speed, float partialTick) {
        ParticleSpawnUtil.spawnEntityHeadParticle(options, entity, level, offset.add(0.0, 0.0, 0.6), speed, partialTick);
    }

    public static void spawnEntityHeadParticle(ParticleOptions options, LivingEntity entity, Level level, Vec3 pos, Vec3 speed, float partialTick) {
        pos = pos.xRot(-entity.getViewXRot(partialTick) * ((float)Math.PI / 180));
        pos = pos.yRot(-entity.getViewYRot(partialTick) * ((float)Math.PI / 180));
        pos = pos.add(entity.getX(), entity.getEyeY(), entity.getZ());
        level.addParticle(options, pos.x(), pos.y(), pos.z(), speed.x(), speed.y(), speed.z());
    }

    public static void spawnEnderEyePlacementParticles(BlockPos pos, RandomSource random, Level level, int color) {
        if (ModConfigs.BLOCKS.enderEyePlacedRings) {
            level.addParticle((ParticleOptions)ColorParticleOption.create(ModParticles.ENDER_EYE_PLACED_RING.get(), (int)color), (double)pos.getX() + 0.5, (double)pos.getY() + 0.8125 + (double)0.2501f, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        }
        if (ModConfigs.BLOCKS.enderEyePlacedParticlesDisplayType != ModBlockConfigs.EnderEyePlacedParticlesDisplayType.VANILLA) {
            ParticleSpawnUtil.spawnEndPortalParticles(level, pos, random, (ParticleOptions)ColorParticleOption.create(ModParticles.SHORT_SPARK.get(), (int)color), 16);
        }
    }

    public static void spawnEndPortalParticles(Level level, BlockPos pos, RandomSource random, ParticleOptions particle, int count) {
        for (int i = 0; i < count; ++i) {
            if (!(random.nextDouble() < (double)((Float)ModConfigs.BLOCKS.endPortalFrameParticlesDensity.get()).floatValue())) continue;
            level.addParticle(particle, (double)pos.getX() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.25), (double)pos.getY() + 0.9375, (double)pos.getZ() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.25), 0.0, 0.0, 0.0);
        }
    }

    public static void spawnParticlesAroundShape(ParticleOptions particle, Level level, BlockPos pos, BlockState state, int count, Supplier<Vec3> particleSpeed, float offset) {
        BlockPos oppositePos;
        BlockState oppositeState;
        ChestType type;
        if (state.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) {
            DoubleBlockHalf half = (DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF);
            BlockPos oppositePos2 = pos.relative(half.getDirectionToOther());
            BlockState oppositeState2 = level.getBlockState(oppositePos2);
            if (oppositeState2.is(state.getBlock()) && oppositeState2.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && half.getOtherHalf().equals((Object)oppositeState2.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF))) {
                ParticleSpawnUtil.spawnParticlesAroundShape(particle, level, oppositePos2, state, direction -> half == DoubleBlockHalf.LOWER && direction == Direction.UP || half == DoubleBlockHalf.UPPER && direction == Direction.DOWN, count, particleSpeed, offset);
            }
        } else if (state.hasProperty((Property)BlockStateProperties.CHEST_TYPE) && state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) && (type = (ChestType)state.getValue((Property)BlockStateProperties.CHEST_TYPE)) != ChestType.SINGLE && (oppositeState = level.getBlockState(oppositePos = ChestBlock.getConnectedBlockPos((BlockPos)pos, (BlockState)state))).is(state.getBlock()) && oppositeState.hasProperty((Property)BlockStateProperties.CHEST_TYPE) && oppositeState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) && type.getOpposite().equals((Object)oppositeState.getValue((Property)BlockStateProperties.CHEST_TYPE)) && oppositeState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            ParticleSpawnUtil.spawnParticlesAroundShape(particle, level, oppositePos, state, direction -> direction == ChestBlock.getConnectedDirection((BlockState)state), count, particleSpeed, offset);
        }
        ParticleSpawnUtil.spawnParticlesAroundShape(particle, level, pos, state, null, count, particleSpeed, offset);
    }

    public static void spawnParticlesAroundShape(ParticleOptions particle, Level level, BlockPos pos, BlockState state, @Nullable Predicate<Direction> predicate, int count, Supplier<Vec3> particleSpeed, float offset) {
        RandomSource random = level.getRandom();
        state.getShape((BlockGetter)level, pos).forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            for (Direction direction : Direction.values()) {
                BlockPos relativePos;
                if (predicate != null && predicate.test(direction) || level.getBlockState(relativePos = pos.relative(direction)).isSolidRender()) continue;
                Direction.Axis axis = direction.getAxis();
                Direction.AxisDirection axisDirection = direction.getAxisDirection();
                boolean isPositive = axisDirection == Direction.AxisDirection.POSITIVE;
                for (int i = 0; i < count; ++i) {
                    double yOffset;
                    double xOffset;
                    double d = axis == Direction.Axis.X ? (isPositive ? maxX : minX) : (xOffset = Mth.nextDouble((RandomSource)random, (double)minX, (double)maxX));
                    double d2 = axis == Direction.Axis.Y ? (isPositive ? maxY : minY) : (yOffset = Mth.nextDouble((RandomSource)random, (double)minY, (double)maxY));
                    double zOffset = axis == Direction.Axis.Z ? (isPositive ? maxZ : minZ) : Mth.nextDouble((RandomSource)random, (double)minZ, (double)maxZ);
                    Vec3 speed = (Vec3)particleSpeed.get();
                    level.addParticle(particle, (double)pos.getX() + xOffset + (double)(offset * (float)axisDirection.getStep()), (double)pos.getY() + yOffset + (double)(offset * (float)axisDirection.getStep()), (double)pos.getZ() + zOffset + (double)(offset * (float)axisDirection.getStep()), speed.x(), speed.y(), speed.z());
                }
            }
        });
    }

    public static void spawnHammeringWorkstationParticles(BlockPos pos, RandomSource random, Level level) {
        float pointX = random.nextFloat();
        float pointZ = random.nextFloat();
        for (int i2 = 0; i2 < 20; ++i2) {
            int xSign = MathUtil.nextSign(random);
            int zSign = MathUtil.nextSign(random);
            level.addParticle((ParticleOptions)SparkParticle.create(SparkType.METAL, random), (double)((float)pos.getX() + pointX), (double)(pos.getY() + 1), (double)((float)pos.getZ() + pointZ), (double)(Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f) * (float)xSign), (double)Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f), (double)(Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f) * (float)zSign));
        }
    }

    public static void spawnCompostParticles(Level level, BlockPos pos, ParticleOptions particle, double xSpeed, double ySpeed, double zSpeed) {
        RandomSource random = level.getRandom();
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof ComposterBlock) {
            for (int i = 0; i < 10; ++i) {
                level.addParticle(particle, (double)pos.getX() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.3), (double)pos.getY() + 0.1875 + 0.125 * (double)((Integer)state.getValue((Property)ComposterBlock.LEVEL)).intValue(), (double)pos.getZ() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.3), xSpeed, ySpeed, zSpeed);
            }
        }
    }

    public static void spawnBucketParticles(Level level, BlockPos pos, ItemStack stack) {
        if (level.isClientSide()) {
            RandomSource random = level.getRandom();
            Item item = stack.getItem();
            if (item instanceof BucketItemAccessor) {
                BucketItemAccessor bucket = (BucketItemAccessor)item;
                Fluid content = bucket.getContent();
                boolean isWater = content.isSame((Fluid)Fluids.WATER);
                if (isWater && ModConfigs.ITEMS.waterBucketUseParticles || content.isSame((Fluid)Fluids.LAVA) && ModConfigs.ITEMS.lavaBucketUseParticles) {
                    if (isWater && level.dimensionType().ultraWarm()) {
                        return;
                    }
                    if (level.getFluidState(pos.above()).getAmount() >= 5) {
                        return;
                    }
                    float fluidHeight = level.getFluidState(pos).getHeight((BlockGetter)level, pos);
                    ParticleSpawnUtil.spawnBucketParticles(level, random, pos, Util.getParticleForFluid(content), fluidHeight == 0.0f ? 1.0 : (double)fluidHeight);
                }
            } else if (stack.is(Items.POWDER_SNOW_BUCKET) && ModConfigs.ITEMS.powderSnowBucketUseParticles) {
                ParticleSpawnUtil.spawnBucketParticles(level, random, pos, (ParticleOptions)ModParticles.SNOW.get(), random.nextDouble());
            }
        }
    }

    public static void spawnBucketParticles(Level level, RandomSource random, BlockPos pos, ParticleOptions particle, double height) {
        if (particle != null) {
            for (int i = 0; i < 16; ++i) {
                int xSign = MathUtil.nextSign(random);
                int zSign = MathUtil.nextSign(random);
                level.addParticle(particle, (double)pos.getX() + 0.5 + MathUtil.nextDouble(random, 0.5) * (double)xSign, (double)pos.getY() + height, (double)pos.getZ() + 0.5 + MathUtil.nextDouble(random, 0.5) * (double)zSign, MathUtil.nextDouble(random, 0.15f) * (double)xSign, MathUtil.nextDouble(random, 0.35f), MathUtil.nextDouble(random, 0.15f) * (double)zSign);
            }
        }
    }

    public static void spawnGrindstoneUsedParticles(Level level, BlockPos pos, BlockState state, RandomSource random) {
        if (ModConfigs.BLOCKS.grindstoneUseParticles && state.hasProperty((Property)GrindstoneBlock.FACING) && state.hasProperty((Property)GrindstoneBlock.FACE)) {
            Direction direction = (Direction)state.getValue((Property)GrindstoneBlock.FACING);
            AttachFace face = (AttachFace)state.getValue((Property)GrindstoneBlock.FACE);
            Direction side = face == AttachFace.CEILING ? Direction.DOWN : Direction.UP;
            for (int i = 0; i < 20; ++i) {
                ParticleSpawnUtil.spawnParticlesOnSide((ParticleOptions)SparkParticle.create(SparkType.METAL, random), 0.0f, side, level, pos, random, (double)Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f) * ((double)direction.getStepX() * 1.5), face == AttachFace.CEILING ? 0.0 : (double)Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f), (double)Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f) * ((double)direction.getStepZ() * 1.5));
            }
        }
    }

    public static void spawnStonecutterParticles(Level level, ItemStack stack, BlockPos pos, BlockState state) {
        if (!ModConfigs.BLOCKS.stonecutterUseParticles) {
            return;
        }
        RandomSource random = level.getRandom();
        if (state.hasProperty((Property)StonecutterBlock.FACING)) {
            Direction direction = ((Direction)state.getValue((Property)StonecutterBlock.FACING)).getClockWise();
            for (int i = 0; i < 16; ++i) {
                ParticleSpawnUtil.spawnParticlesOnSide((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), -0.125f, Direction.UP, level, pos, random, (double)Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f) * ((double)direction.getStepX() * 1.5), Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f), (double)Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f) * ((double)direction.getStepZ() * 1.5));
            }
        }
    }

    public static void spawnLavaSplash(Entity entity, boolean isInLava, boolean firstTick, boolean wasTouchingLava) {
        Level level = entity.level();
        if (isInLava && ModConfigs.ENTITIES.splashes.lavaSplashes && !wasTouchingLava && !firstTick) {
            double yVelocity = entity.getDeltaMovement().y();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                Services.NETWORK.sendToClientsTracking(player, (ServerLevel)level, entity.blockPosition(), new ClientBoundEntityLandInFluidPayload(entity.getId(), entity.getY() + entity.getFluidHeight(FluidTags.LAVA), yVelocity, true));
                return;
            }
            ParticleSpawnUtil.spawnSplashEffects(entity, level, ModParticles.LAVA_SPLASH_EMITTER.get(), (TagKey<Fluid>)FluidTags.LAVA);
        }
    }

    public static boolean spawnSplashEffects(Entity entity, Level level, ParticleType<SplashEmitterParticleOptions> splashParticle, TagKey<Fluid> fluidTag) {
        return ParticleSpawnUtil.spawnSplashEffects(entity, level, splashParticle, entity.getY() + entity.getFluidHeight(fluidTag), entity.getDeltaMovement().y());
    }

    public static boolean spawnSplashEffects(Entity entity, Level level, ParticleType<SplashEmitterParticleOptions> splashParticle, double y, double yVelocity) {
        double offset;
        if (!ModConfigs.ENTITIES.splashes.splashEffects) {
            return false;
        }
        if (ModConfigs.ENTITIES.splashes.entityBlocklist.contains((Object)entity.getType())) {
            return false;
        }
        if (yVelocity <= (double)(-((Float)ModConfigs.ENTITIES.splashes.splashVelocityThreshold.get()).floatValue()) && (offset = y + 0.01) <= y + (double)entity.getBbHeight()) {
            level.addAlwaysVisibleParticle((ParticleOptions)SplashEmitter.createForEntity(entity, splashParticle, yVelocity), true, entity.getX(), offset, entity.getZ(), 0.0, 0.0, 0.0);
            return true;
        }
        return false;
    }

    public static void spawnUnderwaterBlockBreakBubbles(Level level, BlockPos pos, BlockState state, boolean success) {
        if (success && ModConfigs.BLOCKS.underwaterBlockBreakBubbles) {
            boolean nearWater = false;
            for (Direction direction : Direction.values()) {
                BlockPos relativePos = pos.relative(direction);
                FluidState relativeFluidState = level.getFluidState(relativePos);
                BlockState relativeState = level.getBlockState(pos);
                if (direction == Direction.UP && level.getBlockState(relativePos).isAir()) break;
                if (!relativeFluidState.is(FluidTags.WATER) || relativeFluidState.getAmount() < 7 || Block.isFaceFull((VoxelShape)relativeState.getCollisionShape((BlockGetter)level, pos), (Direction)direction.getOpposite())) continue;
                nearWater = true;
                break;
            }
            if (nearWater) {
                TickerManager.schedule(7, () -> {
                    FluidState newFluidState = level.getFluidState(pos);
                    if (newFluidState.is(FluidTags.WATER) && newFluidState.getAmount() >= 7) {
                        ParticleSpawnUtil.spawnParticlesAroundShape((ParticleOptions)ParticleTypes.BUBBLE, level, pos, state, direction -> {
                            BlockPos relativePos = pos.relative(direction);
                            return Block.isFaceFull((VoxelShape)level.getBlockState(relativePos).getCollisionShape((BlockGetter)level, relativePos), (Direction)direction.getOpposite());
                        }, 3, () -> new Vec3(0.0, 0.0, 0.0), 0.0f);
                    }
                });
            }
        }
    }

    public static void spawnPotionRings(LivingEntity entity) {
        Player player;
        Minecraft minecraft = Minecraft.getInstance();
        if (entity instanceof Player && (player = (Player)entity).equals((Object)minecraft.player) && !ModConfigs.ENTITIES.humanoids.potionRingsDisplayType.test(minecraft)) {
            return;
        }
        ItemStack useItem = entity.getUseItem();
        if (useItem.has(DataComponents.POTION_CONTENTS)) {
            Level level = entity.level();
            PotionContents contents = (PotionContents)useItem.get(DataComponents.POTION_CONTENTS);
            if (contents.hasEffects()) {
                int color = contents.getColor();
                level.addParticle((ParticleOptions)new ColorAndIntegerParticleOptions(ModParticles.POTION_EMITTER.get(), color, entity.getId()), entity.getX(), entity.getY(), entity.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spawnSheepFluff(Sheep sheep, int count) {
        RandomSource random = sheep.getRandom();
        SheepFluffParticleOptions particle = new SheepFluffParticleOptions(sheep.getColor(), sheep.getId(), sheep.hasCustomName() && sheep.getName().getString().equals("jeb_"));
        for (int i = 0; i < count; ++i) {
            sheep.level().addParticle((ParticleOptions)particle, sheep.getRandomX(0.5), sheep.getY(0.5), sheep.getRandomZ(0.5), MathUtil.nextNonAbsDouble(random), random.nextDouble(), MathUtil.nextNonAbsDouble(random));
        }
    }
}

