/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.compat.EndRemasteredCompat;
import einstein.subtle_effects.data.MobSkullShaderData;
import einstein.subtle_effects.data.MobSkullShaderReloadListener;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModRenderStateAttachmentKeys;
import einstein.subtle_effects.mixin.client.GameRendererAccessor;
import einstein.subtle_effects.mixin.client.block.AbstractCauldronBlockAccessor;
import einstein.subtle_effects.mixin.client.entity.AbstractHorseAccessor;
import einstein.subtle_effects.particle.option.SplashDropletParticleOptions;
import einstein.subtle_effects.util.RenderStateAttachmentAccessor;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedColor;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static final int BREATH_DELAY = 60;
    public static final int SNORE_DELAY = 10;
    public static final int MAX_Z_COUNT = 3;
    public static final int PARTICLE_LIGHT_COLOR = 240;
    public static final DustParticleOptions GLOWSTONE_DUST_PARTICLES = new DustParticleOptions(16759902, 1.0f);
    public static final ResourceLocation COLORLESS_RAIN_TEXTURE = SubtleEffects.loc("textures/environment/colorless_rain.png");
    public static final Gson GSON = new GsonBuilder().create();
    public static final ResourceLocation VANILLA_EYE = ResourceLocation.withDefaultNamespace((String)"ender_eye");
    private static final String UUID = "d71e4b41-9315-499f-a934-ca925421fb38";

    public static void playClientSound(Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level != null && level.isClientSide()) {
            level.playSound((Entity)minecraft.player, entity, sound, source, volume, pitch);
        }
    }

    public static void playClientSound(BlockPos pos, SoundEvent sound, SoundSource source, float volume, float pitch) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level != null && level.isClientSide()) {
            level.playSound((Entity)minecraft.player, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), sound, source, volume, pitch);
        }
    }

    public static boolean isSolidOrNotEmpty(Level level, BlockPos pos) {
        return level.getBlockState(pos).isSolidRender() || !level.getFluidState(pos).isEmpty();
    }

    public static void applyHelmetShader(ItemStack stack, CameraType cameraType) {
        if (!cameraType.isFirstPerson()) {
            return;
        }
        GameRenderer gameRenderer = Minecraft.getInstance().gameRenderer;
        for (MobSkullShaderData shaderData : MobSkullShaderReloadListener.MOB_SKULL_SHADERS.values()) {
            if (!shaderData.stackHolder().matches(stack)) continue;
            Util.loadShaderEffect(shaderData.shaderId(), gameRenderer);
            return;
        }
        gameRenderer.clearPostEffect();
    }

    private static void loadShaderEffect(ResourceLocation shaderId, GameRenderer gameRenderer) {
        ResourceLocation effect = gameRenderer.currentPostEffect();
        if (effect == null || !effect.equals((Object)shaderId)) {
            ((GameRendererAccessor)gameRenderer).setShaderEffect(shaderId);
        }
    }

    public static void setColorFromHex(SingleQuadParticle particle, int hexColor) {
        particle.setColor((float)(hexColor >> 16) / 255.0f, (float)(hexColor >> 8) / 255.0f, (float)hexColor / 255.0f);
    }

    public static boolean isChunkLoaded(Level level, double blockX, double blockZ) {
        return level.getChunkSource().hasChunk(SectionPos.blockToSectionCoord((double)blockX), SectionPos.blockToSectionCoord((double)blockZ));
    }

    public static double getCauldronFillHeight(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof AbstractCauldronBlock) {
            AbstractCauldronBlock block2 = (AbstractCauldronBlock)block;
            return ((AbstractCauldronBlockAccessor)block2).getFillHeight(state);
        }
        return 0.0;
    }

    public static Fluid getCauldronFluid(BlockState state) {
        if (state.is(Blocks.LAVA_CAULDRON)) {
            return Fluids.LAVA;
        }
        if (state.is(Blocks.WATER_CAULDRON)) {
            return Fluids.WATER;
        }
        return Fluids.EMPTY;
    }

    @Nullable
    public static ParticleOptions getParticleForFluid(Fluid fluid) {
        if (fluid.isSame((Fluid)Fluids.WATER)) {
            return new SplashDropletParticleOptions(ModParticles.WATER_SPLASH_DROPLET.get(), 1.0f);
        }
        if (fluid.isSame((Fluid)Fluids.LAVA)) {
            return new SplashDropletParticleOptions(ModParticles.LAVA_SPLASH_DROPLET.get(), 1.0f);
        }
        return null;
    }

    public static ValidatedColor.ColorHolder getEyeColorHolder(Level level, BlockPos pos) {
        ValidatedColor.ColorHolder color;
        if (CompatHelper.IS_END_REMASTERED_LOADED.get().booleanValue() && (color = EndRemasteredCompat.getEyeColor(level, pos)) != null) {
            return color;
        }
        ValidatedColor.ColorHolder vanillaColor = (ValidatedColor.ColorHolder)ModConfigs.BLOCKS.eyeColors.get((Object)VANILLA_EYE);
        if (vanillaColor != null) {
            return vanillaColor;
        }
        return Util.toColorHolder(0x7ABAAB);
    }

    public static ValidatedColor.ColorHolder toColorHolder(int color) {
        return new ValidatedColor.ColorHolder(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255, false);
    }

    public static float randomizeColor(RandomSource random, float color, float multiplier) {
        return (random.nextFloat() * 0.2f + 0.8f) * color * multiplier;
    }

    public static void setRandomizedColor(SingleQuadParticle particle, RandomSource random, float r, float g, float b) {
        float multiplier = random.nextFloat() * 0.4f + 0.6f;
        particle.setColor(Util.randomizeColor(random, r, multiplier), Util.randomizeColor(random, g, multiplier), Util.randomizeColor(random, b, multiplier));
    }

    @Nullable
    public static ParticleOptions getCauldronParticle(BlockState state) {
        Fluid fluid = Util.getCauldronFluid(state);
        if (!fluid.isSame(Fluids.EMPTY)) {
            return Util.getParticleForFluid(fluid);
        }
        if (state.is(Blocks.POWDER_SNOW_CAULDRON)) {
            return (ParticleOptions)ModParticles.SNOW.get();
        }
        return null;
    }

    public static float getPartialTicks() {
        return Util.getPartialTicks(false);
    }

    public static float getPartialTicks(boolean runsNormally) {
        return Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(runsNormally);
    }

    public static SoundEvent getEntityEatSound(LivingEntity entity, ItemStack stack) {
        AbstractHorse horse;
        SoundEvent horseEatSound;
        if (entity instanceof AbstractHorse && (horseEatSound = ((AbstractHorseAccessor)(horse = (AbstractHorse)entity)).getEatSound()) != null && !horseEatSound.equals(SoundEvents.GENERIC_EAT.value())) {
            return horseEatSound;
        }
        SoundEvent eatSound = null;
        if (entity instanceof Consumable.OverrideConsumeSound) {
            Consumable.OverrideConsumeSound soundOverride = (Consumable.OverrideConsumeSound)entity;
            eatSound = soundOverride.getConsumeSound(stack);
        }
        SoundEvent stackEatSound = null;
        if (stack.has(DataComponents.CONSUMABLE)) {
            stackEatSound = (SoundEvent)((Consumable)stack.get(DataComponents.CONSUMABLE)).sound().value();
        }
        if (eatSound != null && !((SoundEvent)SoundEvents.GENERIC_EAT.value()).equals((Object)eatSound) && !eatSound.equals((Object)stackEatSound)) {
            return eatSound;
        }
        if (entity instanceof Strider) {
            return SoundEvents.STRIDER_EAT;
        }
        if (entity instanceof Parrot) {
            return SoundEvents.PARROT_EAT;
        }
        return stackEatSound != null ? stackEatSound : (SoundEvent)SoundEvents.GENERIC_EAT.value();
    }

    public static boolean isMincraftEinstein(String uuid) {
        return UUID.equals(uuid);
    }

    public static Vec3 getAdjustedNameTagPosition(EntityRenderState renderState, Vec3 nameTagAttachment) {
        if (nameTagAttachment == null) {
            return null;
        }
        if (!ModConfigs.ENTITIES.sleeping.adjustNameTagWhenSleeping) {
            return nameTagAttachment;
        }
        if (renderState instanceof LivingEntityRenderState) {
            Direction facing;
            LivingEntityRenderState livingRenderState = (LivingEntityRenderState)renderState;
            Boolean isSleeping = ((RenderStateAttachmentAccessor)renderState).subtleEffects$get(ModRenderStateAttachmentKeys.IS_SLEEPING);
            if (isSleeping != null && isSleeping.booleanValue() && (facing = livingRenderState.bedOrientation) != null) {
                double x = nameTagAttachment.x();
                double y = nameTagAttachment.y() + 0.5;
                double z = nameTagAttachment.z() - 0.5;
                return switch (facing) {
                    case Direction.NORTH -> new Vec3(x, z, -y);
                    case Direction.SOUTH -> new Vec3(x, z, y);
                    case Direction.EAST -> new Vec3(y, z, x);
                    case Direction.WEST -> new Vec3(-y, z, x);
                    default -> nameTagAttachment;
                };
            }
        }
        return nameTagAttachment;
    }

    public static float radians(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static String getOrdinal(long number) {
        return number + (number == 1L ? "st" : (number == 2L ? "nd" : (number == 3L ? "rd" : "th")));
    }

    public static boolean isRainingAt(Level level, BlockPos pos) {
        if (level.isRaining() && level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX(), pos.getZ()) <= pos.getY()) {
            return ((Biome)level.getBiome(pos).value()).getPrecipitationAt(pos, level.getSeaLevel()) == Biome.Precipitation.RAIN;
        }
        return false;
    }
}

