/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import einstein.subtle_effects.biome_particles.BiomeParticleManager;
import einstein.subtle_effects.init.ModBlockTickers;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModDamageListeners;
import einstein.subtle_effects.init.ModEntityTickers;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModPayloads;
import einstein.subtle_effects.tickers.FlameGeyserTicker;
import einstein.subtle_effects.tickers.TickerManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SubtleEffectsClient {
    private static boolean HAS_CLEARED = false;
    private static boolean DISPLAY_PARTICLE_COUNT = false;
    private static Level LEVEL;

    public static void clientSetup() {
        ModConfigs.init();
        ModPayloads.initClientHandlers();
        ModEntityTickers.init();
        ModBlockTickers.init();
        BiomeParticleManager.init();
        ModDamageListeners.init();
        ModParticles.init();
    }

    public static void clientTick(Minecraft minecraft, Level level) {
        LocalPlayer player = minecraft.player;
        if (level == null || player == null || LEVEL != level) {
            LEVEL = level;
            if (!HAS_CLEARED) {
                TickerManager.clear(level);
                BiomeParticleManager.clear();
                FlameGeyserTicker.ACTIVE_GEYSERS.clear();
                FlameGeyserTicker.INACTIVE_GEYSERS.clear();
                HAS_CLEARED = true;
            }
            return;
        }
        if (minecraft.isPaused() || level.tickRateManager().isFrozen()) {
            return;
        }
        if (DISPLAY_PARTICLE_COUNT) {
            player.displayClientMessage((Component)Component.translatable((String)"ui.subtle_effects.hud.particle_count", (Object[])new Object[]{minecraft.particleEngine.countParticles()}), true);
        }
        BiomeParticleManager.tickBiomeParticles(level, (Player)player);
        TickerManager.tick();
        HAS_CLEARED = false;
    }

    public static <T extends SharedSuggestionProvider> void registerClientCommands(CommandDispatcher<T> dispatcher, CommandBuildContext buildContext) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        LiteralArgumentBuilder particlesClear = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"clear").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$0(minecraft, (Player)player, arg_0));
        RequiredArgumentBuilder particlesCountEnabled = (RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$1((Player)player, arg_0));
        LiteralArgumentBuilder particlesCount = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"count").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$2((Player)player, arg_0))).then((ArgumentBuilder)particlesCountEnabled);
        LiteralArgumentBuilder particles = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"particles").then((ArgumentBuilder)particlesClear)).then((ArgumentBuilder)particlesCount);
        LiteralArgumentBuilder tickersClear = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"clear").executes(arg_0 -> SubtleEffectsClient.lambda$registerClientCommands$3((Player)player, arg_0));
        LiteralArgumentBuilder tickers = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"tickers").then((ArgumentBuilder)tickersClear);
        LiteralArgumentBuilder subtleEffects = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"subtle_effects").then((ArgumentBuilder)particles)).then((ArgumentBuilder)tickers);
        LiteralCommandNode subtleEffectsNode = dispatcher.register(subtleEffects);
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"se").redirect((CommandNode)subtleEffectsNode));
    }

    private static int toggleParticleCount(Player player, boolean enabled) {
        DISPLAY_PARTICLE_COUNT = enabled;
        String enabledString = enabled ? "enable" : "disable";
        SubtleEffectsClient.sendSystemMsg(player, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.count." + enabledString + ".success"));
        return 1;
    }

    private static MutableComponent getMsgTranslation(String string) {
        return Component.translatable((String)("commands.subtle_effects." + string));
    }

    private static void sendSystemMsg(Player player, Component component) {
        if (player != null) {
            player.sendSystemMessage(component);
        }
    }

    private static /* synthetic */ int lambda$registerClientCommands$3(Player player, CommandContext context) throws CommandSyntaxException {
        TickerManager.clear(player.level());
        SubtleEffectsClient.sendSystemMsg(player, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.tickers.clear.success"));
        return 1;
    }

    private static /* synthetic */ int lambda$registerClientCommands$2(Player player, CommandContext context) throws CommandSyntaxException {
        return SubtleEffectsClient.toggleParticleCount(player, true);
    }

    private static /* synthetic */ int lambda$registerClientCommands$1(Player player, CommandContext context) throws CommandSyntaxException {
        return SubtleEffectsClient.toggleParticleCount(player, BoolArgumentType.getBool((CommandContext)context, (String)"enabled"));
    }

    private static /* synthetic */ int lambda$registerClientCommands$0(Minecraft minecraft, Player player, CommandContext context) throws CommandSyntaxException {
        minecraft.particleEngine.clearParticles();
        SubtleEffectsClient.sendSystemMsg(player, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.clear.success"));
        return 1;
    }
}

