/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects;

import einstein.subtle_effects.SubtleEffectsClient;
import einstein.subtle_effects.client.model.entity.EinsteinSolarSystemModel;
import einstein.subtle_effects.client.renderer.entity.EinsteinSolarSystemLayer;
import einstein.subtle_effects.data.BCWPPackManager;
import einstein.subtle_effects.data.MobSkullShaderReloadListener;
import einstein.subtle_effects.data.SparkProviderReloadListener;
import einstein.subtle_effects.platform.NeoForgeRegistryHelper;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="subtle_effects", dist={Dist.CLIENT})
public class SubtleEffectsNeoForgeClient {
    public SubtleEffectsNeoForgeClient(IEventBus modEventBus) {
        SubtleEffectsClient.clientSetup();
        modEventBus.addListener(event -> NeoForgeRegistryHelper.PARTICLE_PROVIDERS.forEach((particle, provider) -> SubtleEffectsNeoForgeClient.registerParticle(event, particle, provider)));
        modEventBus.addListener(event -> event.addPackFinders(BCWPPackManager.PACK_LOCATION.get(), PackType.CLIENT_RESOURCES, BCWPPackManager.PACK_NAME, PackSource.BUILT_IN, false, Pack.Position.TOP));
        modEventBus.addListener(event -> {
            event.registerReloadListener((PreparableReloadListener)new SparkProviderReloadListener());
            event.registerReloadListener((PreparableReloadListener)new MobSkullShaderReloadListener());
            event.registerReloadListener((PreparableReloadListener)new BCWPPackManager());
        });
        modEventBus.addListener(event -> event.registerLayerDefinition(EinsteinSolarSystemModel.MODEL_LAYER, EinsteinSolarSystemModel::createLayer));
        modEventBus.addListener(event -> {
            for (PlayerSkin.Model model : event.getSkins()) {
                EntityRenderer renderer = event.getSkin(model);
                if (!(renderer instanceof PlayerRenderer)) continue;
                PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
                playerRenderer.addLayer((RenderLayer)new EinsteinSolarSystemLayer((RenderLayerParent<?, ?>)playerRenderer, event.getContext()));
            }
        });
        NeoForge.EVENT_BUS.addListener(event -> {
            Minecraft minecraft = Minecraft.getInstance();
            SubtleEffectsClient.clientTick(minecraft, (Level)minecraft.level);
        });
        NeoForge.EVENT_BUS.addListener(event -> SubtleEffectsClient.registerClientCommands(event.getDispatcher(), event.getBuildContext()));
    }

    private static <T extends ParticleType<V>, V extends ParticleOptions> void registerParticle(RegisterParticleProvidersEvent event, Supplier<? extends ParticleType<?>> particle, Function<SpriteSet, ? extends ParticleProvider<?>> provider) {
        Supplier<ParticleType<?>> t = particle;
        Function<SpriteSet, ? extends ParticleProvider<?>> v = provider;
        event.registerSpriteSet(t.get(), sprites -> (ParticleProvider)v.apply(sprites));
    }
}

