/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.biome_particles;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedList;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class BiomeParticleSettings {
    private final ValidatedList<ResourceLocation> biomesConfig;
    private final ValidatedInt density;
    private final int maxSpawnHeight;
    private final Supplier<? extends ParticleOptions> particle;
    private final BiPredicate<Level, BlockPos> spawnConditions;
    private final boolean ignoreHeight;
    private final List<Biome> biomes = new ArrayList<Biome>();

    public BiomeParticleSettings(ValidatedList<ResourceLocation> biomesConfig, ValidatedInt density, int maxSpawnHeight, Supplier<? extends ParticleOptions> particle, BiPredicate<Level, BlockPos> spawnConditions, boolean ignoreHeight) {
        this.biomesConfig = biomesConfig;
        this.density = density;
        this.maxSpawnHeight = maxSpawnHeight;
        this.particle = particle;
        this.spawnConditions = spawnConditions;
        this.ignoreHeight = ignoreHeight;
    }

    public void update(Level level) {
        this.biomes.addAll(this.biomesConfig.stream().map(location -> (Biome)level.registryAccess().registryOrThrow(Registries.BIOME).get(location)).filter(Objects::nonNull).toList());
    }

    public List<Biome> getBiomes() {
        return this.biomes;
    }

    public void clear() {
        this.biomes.clear();
    }

    public int getDensity() {
        return (Integer)this.density.get();
    }

    public int getMaxSpawnHeight() {
        return this.maxSpawnHeight;
    }

    public Supplier<? extends ParticleOptions> getParticle() {
        return this.particle;
    }

    public boolean checkSpawnConditions(Level level, BlockPos pos) {
        return this.spawnConditions.test(level, pos);
    }

    public boolean ignoreHeight() {
        return this.ignoreHeight;
    }
}

