/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.entity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModDamageListeners;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.option.ColorAndIntegerParticleOptions;
import einstein.subtle_effects.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class ClientLivingEntityMixin<T extends Entity>
extends Entity {
    @Shadow
    public int hurtTime;
    @Shadow
    public int deathTime;
    @Unique
    private final LivingEntity subtleEffects$me = (LivingEntity)this;

    public ClientLivingEntityMixin(EntityType<T> type, Level level) {
        super(type, level);
    }

    @WrapOperation(method={"breakItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;spawnItemParticles(Lnet/minecraft/world/item/ItemStack;I)V")})
    private void increaseBreakItemParticles(LivingEntity entity, ItemStack stack, int particleCount, Operation<Void> original) {
        if (ModConfigs.ITEMS.increasedItemBreakParticles) {
            original.call(new Object[]{entity, stack, 16});
            return;
        }
        original.call(new Object[]{entity, stack, particleCount});
    }

    @Inject(method={"tickDeath"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;deathTime:I", ordinal=0)})
    private void deathTick(CallbackInfo ci) {
        if (!this.level().isClientSide) {
            return;
        }
        if (ModConfigs.ENTITIES.wardenDeathSoulParticles && this.getType().equals(EntityType.WARDEN) && this.deathTime == 1 && !this.isRemoved()) {
            for (int i = 0; i < this.random.nextIntBetweenInclusive(3, 5); ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SCULK_SOUL, this.position().x() + (double)(this.getBbWidth() / 2.0f) + MathUtil.nextNonAbsDouble(this.random), this.position().y() + (double)(this.getBbHeight() / 2.0f) + MathUtil.nextNonAbsDouble(this.random), this.position().z() + (double)(this.getBbWidth() / 2.0f) + MathUtil.nextNonAbsDouble(this.random), 0.0, (double)Mth.nextFloat((RandomSource)this.getRandom(), (float)0.01f, (float)0.1f), 0.0);
            }
        }
    }

    @Inject(method={"completeUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;triggerItemUseEffects(Lnet/minecraft/world/item/ItemStack;I)V")})
    private void spawnPotionParticles(CallbackInfo ci) {
        if (this.level().isClientSide) {
            Player player;
            Minecraft minecraft = Minecraft.getInstance();
            LivingEntity livingEntity = this.subtleEffects$me;
            if (livingEntity instanceof Player && (player = (Player)livingEntity).equals((Object)minecraft.player) && !ModConfigs.ENTITIES.humanoids.potionRingsDisplayType.test(minecraft)) {
                return;
            }
            if (this.subtleEffects$me.isInvisible()) {
                return;
            }
            ItemStack useItem = this.subtleEffects$me.getUseItem();
            if (useItem.has(DataComponents.POTION_CONTENTS)) {
                Level level = this.subtleEffects$me.level();
                PotionContents contents = (PotionContents)useItem.get(DataComponents.POTION_CONTENTS);
                if (contents.hasEffects()) {
                    int color = contents.getColor();
                    level.addParticle((ParticleOptions)new ColorAndIntegerParticleOptions(ModParticles.POTION_EMITTER.get(), color, this.subtleEffects$me.getId()), this.subtleEffects$me.getX(), this.subtleEffects$me.getY(), this.subtleEffects$me.getZ(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        EntityType type;
        if (this.level().isClientSide && !this.isInvulnerableTo(source) && amount > 0.0f && source.getEntity() instanceof LivingEntity && this.isAlive() && this.hurtTime == 0 && ModDamageListeners.REGISTERED.containsKey(type = this.getType())) {
            ModDamageListeners.REGISTERED.get(type).apply(this, this.level(), this.random);
        }
    }
}

