/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.entity;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.option.IntegerParticleOptions;
import einstein.subtle_effects.util.MathUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Sheep.class})
public abstract class SheepMixin
extends Animal {
    @Shadow
    public abstract boolean readyForShearing();

    @Shadow
    public abstract DyeColor getColor();

    protected SheepMixin(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")})
    private void mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (this.level().isClientSide() && ModConfigs.ENTITIES.sheepShearFluff && player.getItemInHand(hand).is(Items.SHEARS) && this.readyForShearing()) {
            IntegerParticleOptions particle = new IntegerParticleOptions(ModParticles.SHEEP_FLUFF.get(), Sheep.getColor((DyeColor)this.getColor()));
            for (int i = 0; i < 7; ++i) {
                this.level().addParticle((ParticleOptions)particle, this.getRandomX(0.5), this.getY(0.5), this.getRandomZ(0.5), MathUtil.nextNonAbsDouble(this.random), this.random.nextDouble(), MathUtil.nextNonAbsDouble(this.random));
            }
        }
    }
}

