/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.common;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityFellPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntitySpawnSprintingDustCloudsPayload;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class CommonLivingEntityMixin
extends Entity {
    @Unique
    private boolean subtleEffects$validEntity;
    @Unique
    private float subtleEffects$minSpeed;
    @Unique
    private boolean subtleEffects$canStart = true;
    @Unique
    private Vec3 subtleEffects$lastCheckedPos;
    @Unique
    private final LivingEntity subtleEffects$me = (LivingEntity)this;

    public CommonLivingEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(EntityType<?> type, Level level, CallbackInfo ci) {
        if (this.subtleEffects$me instanceof Ravager) {
            this.subtleEffects$validEntity = true;
            this.subtleEffects$minSpeed = 0.34f;
        }
        if (this.subtleEffects$me instanceof Goat) {
            this.subtleEffects$validEntity = true;
            this.subtleEffects$minSpeed = 0.4f;
        }
        if (this.subtleEffects$me instanceof Hoglin || this.subtleEffects$me instanceof Zoglin) {
            this.subtleEffects$validEntity = true;
            this.subtleEffects$minSpeed = 0.28f;
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        if (!this.level().isClientSide) {
            if (this.subtleEffects$me.isInvisible()) {
                return;
            }
            if ((this.subtleEffects$canStart || this.position().distanceToSqr(this.subtleEffects$lastCheckedPos) > 0.5) && this.subtleEffects$validEntity) {
                if (this.onGround() && this.subtleEffects$me.getSpeed() > this.subtleEffects$minSpeed) {
                    Services.NETWORK.sendToClientsTracking((ServerLevel)this.level(), this.subtleEffects$me.blockPosition(), new ClientBoundEntitySpawnSprintingDustCloudsPayload(this.getId()));
                    this.subtleEffects$lastCheckedPos = this.position();
                    this.subtleEffects$canStart = false;
                    return;
                }
                this.subtleEffects$lastCheckedPos = Vec3.ZERO;
                this.subtleEffects$canStart = true;
            }
        }
    }

    @ModifyExpressionValue(method={"causeFallDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;calculateFallDamage(FF)I")})
    private int calculateFallDamage(int damage, float distance, float damageMultiplier) {
        if (!this.subtleEffects$me.isInvisible()) {
            ParticleSpawnUtil.spawnFallDustClouds(this.subtleEffects$me, damageMultiplier, damage, this.subtleEffects$me instanceof Player ? ClientBoundEntityFellPayload.TypeConfig.PLAYER : ClientBoundEntityFellPayload.TypeConfig.ENTITY);
        }
        return damage;
    }

    @ModifyExpressionValue(method={"travel"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/Level;isClientSide:Z", ordinal=0)})
    private boolean cancelFlyIntoWallServerCheck(boolean original) {
        return false;
    }

    @WrapWithCondition(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;playSound(Lnet/minecraft/sounds/SoundEvent;FF)V")})
    private boolean cancelFlyIntoWallClientSound(LivingEntity entity, SoundEvent sound, float volume, float pitch) {
        return !this.level().isClientSide;
    }

    @WrapWithCondition(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    private boolean cancelFlyIntoWallClientHurt(LivingEntity entity, DamageSource source, float amount) {
        Player player;
        if (!(entity instanceof Player && (player = (Player)entity).isCreative() || entity.isInvisible())) {
            ParticleSpawnUtil.spawnFallDustClouds(entity, 10.0f, 10, ClientBoundEntityFellPayload.TypeConfig.ELYTRA);
        }
        return !this.level().isClientSide;
    }

    @WrapOperation(method={"tickEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V")})
    private void replaceSlimeEffect(Level level, ParticleOptions options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Operation<Void> original) {
        if (level.isClientSide) {
            if (ModConfigs.ENTITIES.replaceOozingEffectParticles && options.getType().equals(ParticleTypes.ITEM_SLIME)) {
                level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SLIME_BLOCK.defaultBlockState()), x, y, z, 0.0, 0.0, 0.0);
                return;
            }
            original.call(new Object[]{level, options, x, y, z, xSpeed, ySpeed, zSpeed});
        }
    }
}

