/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.data.BCWPPackManager;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.util.BubbleSetter;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BubbleParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;

public class DrowningBubbleParticle
extends BubbleParticle {
    public DrowningBubbleParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.alpha = ((Float)ModConfigs.ENTITIES.humanoids.drowningBubbleAlpha.get()).floatValue();
        this.lifetime *= 3;
        if (ModConfigs.ENTITIES.humanoids.forceDrowningBubblesToColumn) {
            this.xd = 0.0;
            this.yd = 0.0;
            this.zd = 0.0;
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DrowningBubbleParticle particle = new DrowningBubbleParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.pickSprite(this.sprites);
            if (BCWPPackManager.isPackLoaded()) {
                ((BubbleSetter)((Object)particle)).subtleEffects$setupBubble(this.sprites, false);
            }
            return particle;
        }
    }
}

