/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers.entity_tickers;

import einstein.subtle_effects.tickers.Ticker;
import einstein.subtle_effects.tickers.entity_tickers.EntityTickerManager;
import einstein.subtle_effects.util.EntityTickersGetter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public abstract class EntityTicker<T extends Entity>
extends Ticker {
    protected final T entity;
    protected final Level level;
    protected final RandomSource random = RandomSource.create();
    private int id;
    private final boolean checkVisibility;

    public EntityTicker(T entity, boolean checkVisibility) {
        this.entity = entity;
        this.level = entity.level();
        this.checkVisibility = checkVisibility;
    }

    public EntityTicker(T entity) {
        this(entity, false);
    }

    @Override
    public final void tick() {
        if (!this.entity.isAlive() || !EntityTickerManager.isEntityInRange(this.entity, 144)) {
            this.remove();
            return;
        }
        if (this.checkVisibility && this.entity.isInvisible()) {
            return;
        }
        if (EntityTickerManager.isEntityInRange(this.entity, 128)) {
            this.entityTick();
        }
    }

    protected abstract void entityTick();

    @Override
    public void remove() {
        super.remove();
        ((EntityTickersGetter)this.entity).subtleEffects$getTickers().remove(this.id);
    }

    public final int getId() {
        return this.id;
    }

    public final void setId(int id) {
        this.id = id;
    }
}

