/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers.entity_tickers;

import einstein.subtle_effects.mixin.client.entity.EntityAccessor;
import einstein.subtle_effects.tickers.entity_tickers.EntityTicker;
import einstein.subtle_effects.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class EntityWaterCauldronTicker
extends EntityTicker<Entity> {
    private boolean wasInWaterCauldron;

    public EntityWaterCauldronTicker(Entity entity) {
        super(entity);
    }

    @Override
    public void entityTick() {
        BlockPos pos = this.entity.blockPosition();
        BlockState state = this.level.getBlockState(pos);
        double height = Util.getCauldronFillHeight(state);
        if (state.is(Blocks.WATER_CAULDRON) && height > 0.0 && (double)pos.getY() + height >= this.entity.getY()) {
            if (!this.wasInWaterCauldron) {
                this.wasInWaterCauldron = true;
                ((EntityAccessor)this.entity).doWaterSplashingEffects();
            }
            return;
        }
        this.wasInWaterCauldron = false;
    }
}

