/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModRenderStateAttachmentKeys;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.RenderStateAttachmentAccessor;
import einstein.subtle_effects.util.Util;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_9976;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_9976.class})
public abstract class WeatherEffectsRendererMixin {
    @Shadow
    protected abstract class_1959.class_1963 method_62317(class_1937 var1, class_2338 var2);

    @WrapOperation(method={"render*"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/WeatherEffectRenderer;RAIN_LOCATION:Lnet/minecraft/resources/ResourceLocation;")})
    private class_2960 replaceRainTexture(Operation<class_2960> original) {
        if (ModConfigs.ENVIRONMENT.biomeColorRain) {
            return Util.COLORLESS_RAIN_TEXTURE;
        }
        return (class_2960)original.call(new Object[0]);
    }

    @ModifyExpressionValue(method={"tickRainParticles"}, at={@At(value="FIELD", target="Lnet/minecraft/core/particles/ParticleTypes;SMOKE:Lnet/minecraft/core/particles/SimpleParticleType;")})
    private class_2400 replaceRainEvaporationParticle(class_2400 original) {
        if (ModConfigs.BLOCKS.steam.replaceRainEvaporationSteam) {
            return ModParticles.STEAM.get();
        }
        return original;
    }

    @ModifyExpressionValue(method={"tickRainParticles"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;is(Lnet/minecraft/world/level/block/Block;)Z")})
    private boolean modifyRainEvaporationBlocks(boolean original, @Local class_2680 state) {
        return original || ModConfigs.BLOCKS.steam.lavaCauldronsEvaporateRain && state.method_27852(class_2246.field_27098);
    }

    @WrapOperation(method={"tickRainParticles"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V")})
    private void modifyCauldronRippleParticlePos(class_638 level, class_2394 options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Operation<Void> original, @Local class_2680 state, @Local class_3610 fluidState, @Local class_5819 random, @Local(ordinal=1) class_2338 pos) {
        if (ModConfigs.BLOCKS.rainWaterRipples) {
            boolean isCauldron = state.method_27852(class_2246.field_27097);
            if (fluidState.method_15767(class_3486.field_15517) || isCauldron) {
                if (random.method_43058() > (double)((Float)ModConfigs.BLOCKS.rainWaterRipplesDensity.get()).floatValue()) {
                    return;
                }
                options = new FloatParticleOptions(ModParticles.WATER_RIPPLE.get(), 1.0f);
                if (isCauldron) {
                    x = (double)pos.method_10263() + 0.1875 + MathUtil.nextDouble(random, 0.625);
                    y = (double)pos.method_10264() + Util.getCauldronFillHeight(state) + 0.01;
                    z = (double)pos.method_10260() + 0.1875 + MathUtil.nextDouble(random, 0.625);
                }
            }
        }
        original.call(new Object[]{level, options, x, y, z, xSpeed, ySpeed, zSpeed});
    }

    @WrapOperation(method={"extractRenderState"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WeatherEffectRenderer;createRainColumnInstance(Lnet/minecraft/util/RandomSource;IIIIIIF)Lnet/minecraft/client/renderer/WeatherEffectRenderer$ColumnInstance;")})
    private class_9976.class_9977 applyColorToColumn(class_9976 renderer, class_5819 random, int ticks, int x, int bottomY, int topY, int z, int lightCoords, float partialTick, Operation<class_9976.class_9977> original, class_1937 level, @Local class_2338.class_2339 pos) {
        class_9976.class_9977 column = (class_9976.class_9977)original.call(new Object[]{renderer, random, ticks, x, bottomY, topY, z, lightCoords, Float.valueOf(partialTick)});
        if (ModConfigs.ENVIRONMENT.biomeColorRain) {
            class_2338 immutablePos = pos.method_10062();
            ((RenderStateAttachmentAccessor)column).subtleEffects$set(ModRenderStateAttachmentKeys.COLOR, class_243.method_24457((int)((class_1959)level.method_23753(immutablePos).comp_349()).method_8687()).method_46409());
        }
        return column;
    }

    @WrapOperation(method={"renderInstances"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexConsumer;setColor(I)Lcom/mojang/blaze3d/vertex/VertexConsumer;")})
    private class_4588 replaceWeatherColor(class_4588 consumer, int color, Operation<class_4588> original, @Local class_9976.class_9977 column, @Local(ordinal=4) float alpha) {
        Vector3f waterColor = ((RenderStateAttachmentAccessor)column).subtleEffects$get(ModRenderStateAttachmentKeys.COLOR);
        if (waterColor != null) {
            return consumer.method_22915(waterColor.x(), waterColor.y(), waterColor.z(), alpha);
        }
        return (class_4588)original.call(new Object[]{consumer, color});
    }
}

