/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.client.model.particle.SplashParticleModel;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModSpriteSets;
import einstein.subtle_effects.particle.ModelParticle;
import einstein.subtle_effects.particle.group.ModelParticleGroup;
import einstein.subtle_effects.particle.option.SplashParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_3611;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class SplashParticle
extends ModelParticle<SplashParticleModel> {
    private final boolean glowing;
    private final class_6862<class_3611> fluidTag;
    private final class_4002 sprites;
    @Nullable
    private final class_4002 overlaySprites;
    private final boolean hasOverlay;
    private final class_2338.class_2339 pos;
    private float xScale;
    private final float yScale;
    private class_2960 texture;
    private class_2960 overlayTexture;
    private float overlayRCol = 1.0f;
    private float overlayGCol = 1.0f;
    private float overlayBCol = 1.0f;
    private final SplashParticleModel model = this.bakeModel(SplashParticleModel::new, SplashParticleModel.MODEL_LAYER);

    protected SplashParticle(class_638 level, double x, double y, double z, boolean glowing, class_6862<class_3611> fluidTag, class_4002 sprites, @Nullable class_4002 overlaySprites, SplashParticleOptions options) {
        super(level, x, y, z);
        this.glowing = glowing;
        this.fluidTag = fluidTag;
        this.sprites = sprites;
        this.overlaySprites = overlaySprites;
        this.pos = class_2338.method_49637((double)x, (double)y, (double)z).method_25503();
        this.hasOverlay = overlaySprites != null && ((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue() > 0.0f;
        this.field_3847 = 15;
        this.xScale = options.xScale();
        this.yScale = options.yScale();
        this.method_3080(this.xScale, this.yScale);
        this.setSpriteFromAge();
    }

    protected int method_3068(float partialTick) {
        if (this.glowing) {
            return 240;
        }
        return super.method_3068(partialTick);
    }

    public void method_3070() {
        this.pos.method_10102(this.field_3874, this.field_3854, this.field_3871);
        if (!this.field_3851.method_8316((class_2338)this.pos).method_15767(this.fluidTag) && !Util.getCauldronFluid(this.field_3851.method_8320((class_2338)this.pos)).method_15791(this.fluidTag)) {
            this.method_3085();
            return;
        }
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
            return;
        }
        this.xScale += 0.01333f;
        this.setSpriteFromAge();
    }

    @Override
    public ModelParticleGroup.ModelParticleRenderState extractState(class_4587 poseStack, class_4184 camera, float partialTicks) {
        int lightColor = this.method_3068(partialTicks);
        int color = class_9848.method_61318((float)this.alpha, (float)this.rCol, (float)this.gCol, (float)this.bCol);
        poseStack.method_46416(0.0f, -(6.0f * (this.yScale / 4.0f)), 0.0f);
        poseStack.method_22905(this.xScale, this.yScale, this.xScale);
        ModelParticleGroup.OverlayModelState overlayState = null;
        if (this.hasOverlay) {
            overlayState = new ModelParticleGroup.OverlayModelState(class_9848.method_61318((float)((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue(), (float)this.overlayRCol, (float)this.overlayGCol, (float)this.overlayBCol), this.model.method_23500(this.overlayTexture));
        }
        return new ModelParticleGroup.ModelParticleRenderState(this.getModel(), poseStack, this.model.method_23500(this.texture), lightColor, color, overlayState);
    }

    @Override
    public SplashParticleModel getModel() {
        return this.model;
    }

    private void setSpriteFromAge() {
        this.texture = this.getSpriteId(this.sprites.method_18138(this.field_3866, this.field_3847));
        if (this.hasOverlay) {
            this.overlayTexture = this.getSpriteId(this.overlaySprites.method_18138(this.field_3866, this.field_3847));
        }
    }

    public record LavaProvider(class_4002 sprites) implements class_707<SplashParticleOptions>
    {
        public class_703 createParticle(SplashParticleOptions options, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_5819 random) {
            return new SplashParticle(level, x, y, z, true, (class_6862<class_3611>)class_3486.field_15518, this.sprites, null, options);
        }
    }

    public record Provider(class_4002 sprites) implements class_707<SplashParticleOptions>
    {
        public class_703 createParticle(SplashParticleOptions options, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_5819 random) {
            SplashParticle particle = new SplashParticle(level, x, y, z, false, (class_6862<class_3611>)class_3486.field_15517, this.sprites, (class_4002)ModSpriteSets.WATER_SPLASH_OVERLAY, options);
            int waterColor = ((class_1959)level.method_23753(class_2338.method_49637((double)x, (double)y, (double)z)).comp_349()).method_8687();
            float colorIntensity = ((Float)ModConfigs.ENTITIES.splashes.splashOverlayTint.get()).floatValue();
            float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(waterColor & 0xFF) / 255.0f;
            if (colorIntensity > 0.0f) {
                float whiteIntensity = 1.0f - colorIntensity;
                particle.overlayRCol = whiteIntensity + colorIntensity * red;
                particle.overlayGCol = whiteIntensity + colorIntensity * green;
                particle.overlayBCol = whiteIntensity + colorIntensity * blue;
            }
            particle.setColor(red, green, blue);
            return particle;
        }
    }
}

