/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3486;
import net.minecraft.class_3611;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_703;
import net.minecraft.class_707;

public class SplashRippleParticle
extends FlatPlaneParticle {
    private final class_2338.class_2339 pos;
    private final class_4002 sprites;
    private final class_6862<class_3611> fluidTag;
    private final boolean glowing;
    private boolean shouldAnimate = false;

    protected SplashRippleParticle(class_638 level, double x, double y, double z, class_4002 sprites, float xScale, class_6862<class_3611> fluidTag, boolean glowing, class_5819 random) {
        super(level, x, y, z, sprites.method_74304());
        this.sprites = sprites;
        this.fluidTag = fluidTag;
        this.glowing = glowing;
        this.pos = class_2338.method_49637((double)x, (double)y, (double)z).method_25503();
        this.rotation = this.rotation.rotateX(1.5707964f);
        this.field_3847 = 15;
        xScale /= 2.0f;
        xScale -= xScale * 0.0625f * 4.0f;
        this.field_17867 = xScale;
        this.method_3080(xScale, 0.1f);
        this.method_74306(sprites);
    }

    public void method_3070() {
        this.pos.method_10102(this.field_3874, this.field_3854, this.field_3871);
        if (!this.field_3851.method_8316((class_2338)this.pos).method_15767(this.fluidTag) && !Util.getCauldronFluid(this.field_3851.method_8320((class_2338)this.pos)).method_15791(this.fluidTag)) {
            this.method_3085();
            return;
        }
        if (this.field_3866++ >= this.field_3847) {
            if (this.shouldAnimate) {
                this.method_3085();
                return;
            }
            this.shouldAnimate = true;
            this.field_3847 = 20;
            this.field_3866 = 0;
        }
        this.field_17867 += 0.005f;
        if (this.shouldAnimate) {
            this.method_74306(this.sprites);
        }
    }

    protected int method_3068(float partialTick) {
        if (this.glowing) {
            return 240;
        }
        return super.method_3068(partialTick);
    }

    protected class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62641;
    }

    public record LavaProvider(class_4002 sprites) implements class_707<FloatParticleOptions>
    {
        public class_703 createParticle(FloatParticleOptions options, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_5819 random) {
            SplashRippleParticle particle = new SplashRippleParticle(level, x, y, z, this.sprites, options.f(), (class_6862<class_3611>)class_3486.field_15518, true, random);
            if (((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue() == 0.0f) {
                particle.method_74308(0.0f);
            }
            return particle;
        }
    }

    public record Provider(class_4002 sprites) implements class_707<FloatParticleOptions>
    {
        public class_703 createParticle(FloatParticleOptions options, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_5819 random) {
            SplashRippleParticle particle = new SplashRippleParticle(level, x, y, z, this.sprites, options.f(), (class_6862<class_3611>)class_3486.field_15517, false, random);
            int waterColor = ((class_1959)level.method_23753(class_2338.method_49637((double)x, (double)y, (double)z)).comp_349()).method_8687();
            float colorIntensity = ((Float)ModConfigs.ENTITIES.splashes.splashOverlayTint.get()).floatValue();
            if (colorIntensity > 0.0f) {
                float whiteIntensity = 1.0f - colorIntensity;
                particle.method_74305(whiteIntensity + colorIntensity * ((float)(waterColor >> 16 & 0xFF) / 255.0f), whiteIntensity + colorIntensity * ((float)(waterColor >> 8 & 0xFF) / 255.0f), whiteIntensity + colorIntensity * ((float)(waterColor & 0xFF) / 255.0f));
            }
            particle.method_74308(((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue());
            return particle;
        }
    }
}

