/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking.tickers.entity;

import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.ticking.tickers.entity.EntityTicker;
import einstein.subtle_effects.ticking.tickers.entity.SimpleTicker;
import einstein.subtle_effects.util.EntityProvider;
import einstein.subtle_effects.util.EntityTickerAccessor;
import einstein.subtle_effects.util.Util;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class EntityTickerManager {
    public static final List<TickerProvider<?>> REGISTERED = new ArrayList();
    private static final IntList ENTITIES = new IntArrayList();
    public static final int INNER_RANGE = 128;
    public static final int OUTER_RANGE = 144;
    private static int REGISTRATION_ID = 0;

    public static <T extends class_1297> void register(Predicate<class_1297> predicate, Function<T, EntityTicker<T>> function) {
        REGISTERED.add(new TickerProvider<T>(REGISTRATION_ID++, predicate, function));
    }

    public static <T extends class_1297> void registerSimple(class_1299<T> type, boolean checkVisibility, Supplier<Boolean> isEnabled, EntityProvider<T> provider) {
        EntityTickerManager.registerSimple(entity -> entity.method_5864().equals(type) && (Boolean)isEnabled.get() != false, checkVisibility, provider);
    }

    public static <T extends class_1297> void registerSimple(Predicate<class_1297> predicate, boolean checkVisibility, EntityProvider<T> provider) {
        EntityTickerManager.register(predicate, entity -> new SimpleTicker<class_1297>((class_1297)entity, provider, checkVisibility));
    }

    public static <T extends class_1297> void createTickersForEntity(T entity) {
        if (EntityTickerManager.isEntityInRange(entity, 128)) {
            Int2ObjectMap<EntityTicker<?>> tickers = ((EntityTickerAccessor)entity).subtleEffects$getTickers();
            REGISTERED.forEach(provider -> {
                int id = provider.id();
                if (!tickers.containsKey(id) && provider.predicate().test(entity)) {
                    EntityTicker ticker = provider.function().apply(entity);
                    ticker.setId(id);
                    tickers.put(id, ticker);
                    TickerManager.add(ticker);
                    ENTITIES.add(entity.method_5628());
                }
            });
        }
    }

    public static <T extends class_1297> boolean isEntityInRange(T entity, int range) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            if (player.method_5779(entity)) {
                return true;
            }
            class_243 position = entity.method_73189();
            return Util.isChunkLoaded(entity.method_73183(), position.method_10216(), position.method_10215()) && player.method_73189().method_24802((class_2374)position, (double)range);
        }
        return false;
    }

    public static void clear(@Nullable class_1937 level) {
        if (level != null) {
            ENTITIES.forEach(id -> {
                class_1297 entity = level.method_8469(id);
                if (entity != null) {
                    ((EntityTickerAccessor)entity).subtleEffects$getTickers().clear();
                }
            });
        }
        ENTITIES.clear();
    }

    public record TickerProvider<T extends class_1297>(int id, Predicate<class_1297> predicate, Function<T, EntityTicker<T>> function) {
    }
}

