/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.client.renderer;

import einstein.subtle_effects.SubtleEffectsClient;
import einstein.subtle_effects.init.ModRenderStateAttachmentKeys;
import einstein.subtle_effects.mixin.client.particle.ParticleEngineAccessor;
import einstein.subtle_effects.util.ParticleAccessor;
import einstein.subtle_effects.util.RenderStateAttachmentAccessor;
import einstein.subtle_effects.util.SingleQuadParticleAccessor;
import einstein.subtle_effects.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_11658;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4604;
import net.minecraft.class_9848;
import net.minecraft.class_9974;
import org.joml.Vector3f;

public class ParticleBoundingBoxesRenderer {
    private static final Map<class_3940.class_11941, Vector3f> LAYER_TO_COLOR = (Map)class_156.method_654(new HashMap(), map -> {
        map.put(class_3940.class_11941.field_62639, ParticleBoundingBoxesRenderer.stringToColor("TERRAIN"));
        map.put(class_3940.class_11941.field_62640, ParticleBoundingBoxesRenderer.stringToColor("OPAQUE"));
        map.put(class_3940.class_11941.field_62641, ParticleBoundingBoxesRenderer.stringToColor("TRANSLUCENT"));
    });

    private static Vector3f stringToColor(String color) {
        return class_243.method_24457((int)class_9848.method_61330((int)255, (int)color.hashCode())).method_46409();
    }

    public static void extractParticleBoundingBoxes(class_11658 levelRenderState, class_4184 camera, class_4604 frustum) {
        if (SubtleEffectsClient.DISPLAY_PARTICLE_BOUNDING_BOXES) {
            class_243 cameraPos = camera.method_19326();
            class_310 minecraft = class_310.method_1551();
            ArrayList renderStates = new ArrayList();
            float partialTicks = Util.getPartialTicks();
            class_4604 particleFrustum = frustum.method_74403(-3.0f);
            ((ParticleEngineAccessor)minecraft.field_1713).getParticles().forEach((renderType, particleGroup) -> {
                if (particleGroup == null || particleGroup.method_74284()) {
                    return;
                }
                Vector3f renderTypeColor = ParticleBoundingBoxesRenderer.stringToColor(renderType.comp_3340());
                particleGroup.method_74290().forEach(particle -> {
                    class_238 aabb = particle.method_3064();
                    if (particleFrustum.method_23093(aabb)) {
                        SingleQuadParticleAccessor quadAccessor;
                        Vector3f layerColor;
                        ParticleAccessor accessor = (ParticleAccessor)particle;
                        double x = class_3532.method_16436((double)partialTicks, (double)accessor.getOldX(), (double)accessor.getX()) - cameraPos.method_10216();
                        double y = class_3532.method_16436((double)partialTicks, (double)accessor.getOldY(), (double)accessor.getY()) - cameraPos.method_10214();
                        double z = class_3532.method_16436((double)partialTicks, (double)accessor.getOldZ(), (double)accessor.getZ()) - cameraPos.method_10215();
                        Vector3f color = renderTypeColor;
                        if (particle instanceof SingleQuadParticleAccessor && (layerColor = LAYER_TO_COLOR.get((quadAccessor = (SingleQuadParticleAccessor)particle).subtleEffects$getLayer())) != null) {
                            color = layerColor;
                        }
                        aabb = aabb.method_989(-accessor.getX(), -accessor.getY(), -accessor.getZ());
                        class_238 renderTypeAABB = new class_238(aabb.field_1323, aabb.field_1325 - 0.02, aabb.field_1321, aabb.field_1320, aabb.field_1325 + 0.02, aabb.field_1324);
                        renderStates.add(new ParticleBoundingBoxRenderState(x, y, z, color, aabb, renderTypeAABB));
                    }
                });
            });
            if (!renderStates.isEmpty()) {
                ((RenderStateAttachmentAccessor)levelRenderState).subtleEffects$set(ModRenderStateAttachmentKeys.PARTICLE_BOUNDING_BOXES, renderStates);
            }
        }
    }

    public static void renderParticleBoundingBoxes(class_4587 poseStack, class_11658 levelRenderState) {
        List<ParticleBoundingBoxRenderState> renderStates;
        if (SubtleEffectsClient.DISPLAY_PARTICLE_BOUNDING_BOXES && (renderStates = ((RenderStateAttachmentAccessor)levelRenderState).subtleEffects$get(ModRenderStateAttachmentKeys.PARTICLE_BOUNDING_BOXES)) != null) {
            class_4588 consumer = class_310.method_1551().method_22940().method_23000().method_73477(class_1921.method_23594());
            renderStates.forEach(renderState -> {
                poseStack.method_22903();
                poseStack.method_22904(renderState.x(), renderState.y(), renderState.z());
                class_4587.class_4665 lastPose = poseStack.method_23760();
                class_9974.method_62295((class_4587.class_4665)lastPose, (class_4588)consumer, (class_238)renderState.aabb(), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Vector3f color = renderState.color();
                if (color != null) {
                    class_9974.method_62295((class_4587.class_4665)lastPose, (class_4588)consumer, (class_238)renderState.renderTypeAABB(), (float)renderState.color.x(), (float)renderState.color.y(), (float)renderState.color.z(), (float)1.0f);
                }
                poseStack.method_22909();
            });
        }
    }

    public record ParticleBoundingBoxRenderState(double x, double y, double z, Vector3f color, class_238 aabb, class_238 renderTypeAABB) {
    }
}

