/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.configs;

import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.SubtleEffectsClient;
import einstein.subtle_effects.compat.CompatHelper;
import java.util.ArrayList;
import java.util.List;
import me.fzzyhmstrs.fzzy_config.annotations.Translation;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigGroup;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedList;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedRegistryType;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

@Translation(prefix="config.subtle_effects.general")
public class ModGeneralConfigs
extends Config {
    private static final List<ParticleType<?>> DEFAULT_CULLING_BLOCKLIST = (List)Util.make(new ArrayList(), list -> {
        ParticleType mistType;
        if (CompatHelper.IS_PARTICLE_RAIN_LOADED.get().booleanValue() && (mistType = (ParticleType)BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"particlerain", (String)"mist"))) != null) {
            list.add(mistType);
        }
    });
    public ConfigGroup particleRenderingGroup = new ConfigGroup("particle_rendering");
    public boolean enableParticleCulling = true;
    public ValidatedInt particleRenderDistance = new ValidatedInt(5, 32, 1);
    public ValidatedList<ParticleType<?>> particleCullingBlocklist = ValidatedRegistryType.of((Object)ParticleTypes.FLAME, (Registry)BuiltInRegistries.PARTICLE_TYPE).toList(DEFAULT_CULLING_BLOCKLIST);
    public boolean cullParticlesInUnloadedChunks = true;
    public boolean allowUsingBlendedRenderType = true;
    @ConfigGroup.Pop
    public boolean spellParticlesUseBlendedRenderType = true;
    public ConfigGroup particlesGroup = new ConfigGroup("particles");
    public ConfigGroup dripParticlesGroup = new ConfigGroup("particles.drip_particles");
    public boolean glowingLavaDrops = true;
    public boolean fluidDropsEvaporate = true;
    public ValidatedFloat fluidDropsEvaporationVolume = new ValidatedFloat(0.25f, 1.0f, 0.0f);
    public boolean dropLandInFluidRipples = true;
    @ConfigGroup.Pop
    public ValidatedFloat dropLandSoundVolume = new ValidatedFloat(1.0f, 2.0f, 0.0f);
    public boolean lavaSparkSmoke = true;
    public ValidatedFloat sparksScale = new ValidatedFloat(1.0f, 2.0f, 1.0f);
    public boolean poppingHearts = true;
    public boolean poppingBubbles = true;
    public ValidatedFloat poppingBubblesVolume = new ValidatedFloat(0.2f, 1.0f, 0.0f);
    public ConfigGroup enchantmentParticlesGroup = new ConfigGroup("enchant_particles");
    public boolean glowingEnchantmentParticles = true;
    public boolean translucentEnchantmentParticles = true;
    @ConfigGroup.Pop
    public boolean disableRandomizedShading = true;
    public ValidatedFloat potionParticleAlpha = new ValidatedFloat(0.7f, 1.0f, 0.3f);
    public ValidatedFloat potionParticleAlphaNearPlayer = new ValidatedFloat(0.2f, 1.0f, 0.0f);
    public ConfigGroup leavesGroup = new ConfigGroup("leaves");
    public boolean leavesLandOnGround = true;
    public boolean leavesLandOnWater = true;
    public boolean leavesLandingOnWaterRipples = true;
    public boolean leavesLandingOnWaterKeepMomentum = true;
    public ValidatedInt fallenLeavesLifeTime = new ValidatedInt(40, 100, 20);
    @ConfigGroup.Pop.Container(value={@ConfigGroup.Pop, @ConfigGroup.Pop})
    public boolean rainIncreasesLeavesMovementSpeed = true;
    public ConfigGroup fireOverlayGroup = new ConfigGroup("fireOverlay");
    public ValidatedFloat fireOverlayHeight = new ValidatedFloat(-0.15f, 0.4f, -0.5f);
    public ValidatedFloat fireOverlayAlpha = new ValidatedFloat(0.9f, 1.0f, 0.0f);
    @ConfigGroup.Pop
    public ValidatedFloat fireOverlayAlphaWithFireResistance = new ValidatedFloat(0.4f, 1.0f, 0.0f);
    public boolean mobSkullShaders = true;
    public boolean nightVisionFading = true;
    public ValidatedInt nightVisionFadingTime = new ValidatedInt(100, 200, 10);
    public boolean enableEasterEggs = true;

    public ModGeneralConfigs() {
        super(SubtleEffects.loc("general"));
    }

    public void onUpdateClient() {
        Minecraft minecraft = Minecraft.getInstance();
        SubtleEffectsClient.clear((Level)minecraft.level);
        if (minecraft.level != null && minecraft.options.getCameraType().isFirstPerson()) {
            if (!this.mobSkullShaders) {
                minecraft.gameRenderer.shutdownEffect();
                return;
            }
            LocalPlayer player = minecraft.player;
            if (player != null) {
                einstein.subtle_effects.util.Util.applyHelmetShader(player.getInventory().getArmor(3), minecraft.options.getCameraType());
            }
        }
    }
}

