/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.init;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.mixin.client.particle.ParticleEngineAccessor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ModParticleRenderTypes {
    public static final ParticleRenderType BLENDED = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, @NotNull TextureManager textureManager) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "subtle_effects:blended";
        }
    };

    public static void init() {
        ArrayList<ParticleRenderType> renderTypes = new ArrayList<ParticleRenderType>(ParticleEngineAccessor.getRenderOrder());
        int i = renderTypes.indexOf(ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT);
        renderTypes.add(++i, BLENDED);
        ParticleEngineAccessor.setRenderOrder(List.copyOf(renderTypes));
    }

    public static ParticleRenderType getBlendedOrTransparent() {
        if (ModConfigs.GENERAL.allowUsingBlendedRenderType) {
            return BLENDED;
        }
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }
}

