/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticleRenderTypes;
import einstein.subtle_effects.particle.FlatPlaneParticle;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class EnderEyePlacedRingParticle
extends FlatPlaneParticle {
    public static final int DEFAULT_COLOR = 0x7ABAAB;
    public static final float SIZE = 0.2501f;
    private final Particle.LifetimeAlpha lifetimeAlpha = new Particle.LifetimeAlpha(1.0f, 0.0f, 0.0f, 1.0f);

    protected EnderEyePlacedRingParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.lifetime = (Integer)ModConfigs.BLOCKS.enderEyePlacedRingsDuration.get();
        this.quadSize = 0.2501f;
        this.setSize(0.2501f, 0.2501f);
        this.alpha = this.lifetimeAlpha.startAlpha();
    }

    @Override
    protected void renderQuad(VertexConsumer consumer, Camera camera, float partialTicks, Quaternionf rotation) {
        this.alpha = this.lifetimeAlpha.currentAlphaForAge(this.age, this.lifetime, partialTicks);
        Vec3 cameraPos = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPos.x());
        float y = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPos.y());
        float z = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPos.z());
        this.renderQuad(consumer, new Quaternionf(), partialTicks, x, y, z + 0.2501f);
        this.renderQuad(consumer, new Quaternionf().rotateY(1.5707964f), partialTicks, x - 0.2501f, y, z);
        this.renderQuad(consumer, new Quaternionf().rotateY((float)Math.PI), partialTicks, x, y, z - 0.2501f);
        this.renderQuad(consumer, new Quaternionf().rotateY(-1.5707964f), partialTicks, x + 0.2501f, y, z);
    }

    protected void renderQuad(VertexConsumer consumer, Quaternionf rotation, float partialTicks, float x, float y, float z) {
        this.renderQuad(consumer, rotation, partialTicks, x, y, z, false);
        this.renderQuad(consumer, rotation, partialTicks, x, y, z, true);
    }

    protected int getLightColor(float partialTick) {
        return 240;
    }

    public ParticleRenderType getRenderType() {
        return ModParticleRenderTypes.getBlendedOrTransparent();
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<ColorParticleOption>
    {
        public Particle createParticle(ColorParticleOption options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            EnderEyePlacedRingParticle particle = new EnderEyePlacedRingParticle(level, x, y, z);
            particle.pickSprite(this.sprites);
            particle.setColor(options.getRed(), options.getGreen(), options.getBlue());
            return particle;
        }
    }
}

