/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.platform.Services;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_4002;

public class ParticleAnimation {
    private final class_4002 sprites;
    private final int firstFrameDelay;
    private final int loopCount;
    private final int totalFrames;
    private final int totalTicks;
    private int tick;
    private int frame;

    public ParticleAnimation(class_4002 sprites, int loopCount) {
        this(sprites, 0, loopCount);
    }

    public ParticleAnimation(class_4002 sprites, int firstFrameDelay, int loopCount) {
        this.sprites = sprites;
        this.firstFrameDelay = firstFrameDelay;
        this.loopCount = loopCount;
        List<class_1058> textures = Services.PARTICLE_HELPER.getSpritesFromSet(sprites);
        this.totalFrames = textures != null ? textures.size() : 0;
        this.totalTicks = firstFrameDelay + this.totalFrames;
    }

    public void tick() {
        ++this.tick;
        if (this.firstFrameDelay > 0 && this.tick < this.firstFrameDelay) {
            this.frame = 0;
        } else if (this.tick <= this.totalTicks) {
            ++this.frame;
        } else {
            this.frame = 0;
            this.tick = 0;
        }
    }

    public int getAnimationLifetime() {
        return this.totalTicks * this.loopCount;
    }

    public class_1058 getSpriteForFrame() {
        return this.sprites.method_18138(this.frame, this.totalFrames);
    }

    public class_4002 getSprites() {
        return this.sprites;
    }
}

