/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking;

import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.compat.SereneSeasonsCompat;
import einstein.subtle_effects.configs.environment.FireflyConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModSounds;
import einstein.subtle_effects.util.MathUtil;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class FireflyManager {
    public static void tick(class_1937 level, class_2338 pos, class_2680 state, class_5819 random) {
        if (!ModConfigs.ENVIRONMENT.fireflies.firefliesEnabled) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null || minecraft.field_1724.field_6012 < 200) {
            return;
        }
        Optional dimensionKey = level.method_40134().method_40230();
        if (dimensionKey.isEmpty() || ModConfigs.ENVIRONMENT.fireflies.dimensionBlocklist.contains((Object)((class_5321)dimensionKey.get()).method_29177())) {
            return;
        }
        if (CompatHelper.IS_SERENE_SEANSONS_LOADED.get().booleanValue() && SereneSeasonsCompat.isColdSeason(level, ModConfigs.ENVIRONMENT.fireflies.ignoredSeasons)) {
            return;
        }
        class_6880 biome = level.method_23753(pos);
        Optional biomeKey = biome.method_40230();
        if (biomeKey.isEmpty()) {
            return;
        }
        class_2960 biomeId = ((class_5321)biomeKey.get()).method_29177();
        if (!ModConfigs.ENVIRONMENT.fireflies.biomesBlocklist.contains((Object)biomeId)) {
            float time;
            boolean isHabitatBiome = ModConfigs.ENVIRONMENT.fireflies.habitatBiomes.contains((Object)biomeId);
            boolean isSpawnable = ModConfigs.ENVIRONMENT.fireflies.spawnableBlocks.contains((Object)state.method_26204());
            if (!(isHabitatBiome || !ModConfigs.ENVIRONMENT.fireflies.onlyAllowInHabitatBiomes && isSpawnable)) {
                return;
            }
            boolean canSeeSky = level.method_8311(pos);
            int surfaceLevel = level.method_8598(class_2902.class_2903.field_13197, pos).method_10264();
            if (isHabitatBiome) {
                if (!canSeeSky && !isSpawnable) {
                    return;
                }
                if (canSeeSky && surfaceLevel + 10 < pos.method_10264()) {
                    return;
                }
            }
            if (!(!((class_1959)biome.comp_349()).method_39927(pos) && !ModConfigs.ENVIRONMENT.fireflies.biomesAllowlist.contains((Object)biomeId) || !((time = (float)level.method_8532() % 24000.0f) > 13000.0f && time < 23000.0f) && level.method_8314(class_1944.field_9284, pos) != 0 || level.method_8314(class_1944.field_9282, pos) > 5 || level.method_8419() && canSeeSky && surfaceLevel <= pos.method_10264() || state.method_26234((class_1922)level, pos) || !level.method_8316(pos).method_15769())) {
                if (FireflyManager.canSpawn(random, isHabitatBiome)) {
                    level.method_8406((class_2394)ModConfigs.ENVIRONMENT.fireflies.fireflyType.getParticle().get(), (double)pos.method_10263() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.4375), (double)pos.method_10264() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.4375), (double)pos.method_10260() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.4375), 0.0, 0.0, 0.0);
                }
                if (((Float)ModConfigs.ENVIRONMENT.fireflies.fireflySoundVolume.get()).floatValue() > 0.0f && FireflyManager.canPlaySound(random, isHabitatBiome)) {
                    level.method_8486((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), ModSounds.FIREFLY_BUZZ.get(), class_3419.field_15256, ((Float)ModConfigs.ENVIRONMENT.fireflies.fireflySoundVolume.get()).floatValue(), 1.0f, false);
                }
            }
        }
    }

    private static boolean canPlaySound(class_5819 random, boolean isHabitatBiome) {
        if (isHabitatBiome) {
            return random.method_43058() < 1.0E-5 * (double)((Integer)ModConfigs.ENVIRONMENT.fireflies.habitatBiomeDensity.get()).intValue();
        }
        return random.method_43058() < 3.0E-4 * (double)((Integer)ModConfigs.ENVIRONMENT.fireflies.defaultDensity.get()).intValue();
    }

    private static boolean canSpawn(class_5819 random, boolean isHabitatBiome) {
        if (isHabitatBiome) {
            return random.method_43058() < 5.0E-4 * (double)((Integer)ModConfigs.ENVIRONMENT.fireflies.habitatBiomeDensity.get()).intValue();
        }
        int spawnRate = ModConfigs.ENVIRONMENT.fireflies.fireflyType == FireflyConfigs.FireflyType.VANILLA ? 170 : 1;
        return random.method_43058() < 0.008 * (double)((Integer)ModConfigs.ENVIRONMENT.fireflies.defaultDensity.get()).intValue() * (double)spawnRate;
    }
}

