/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking;

import einstein.subtle_effects.data.SparkProviderData;
import einstein.subtle_effects.data.SparkProviderReloadListener;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.util.Box;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.SparkType;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4770;
import net.minecraft.class_5540;
import net.minecraft.class_5819;
import net.minecraft.class_6016;
import net.minecraft.class_6017;

public class SparkProviderManager {
    public static void tick(class_1937 level, class_5819 random, class_2248 block, class_2680 state, class_2338 pos) {
        List<SparkProviderReloadListener.SparkProvider> providers = SparkProviderReloadListener.PROVIDERS.get(block);
        if (providers != null && !providers.isEmpty()) {
            providers.forEach(provider -> {
                SparkProviderReloadListener.BlockStateHolder stateHolder = provider.stateHolder();
                if (!stateHolder.matches(state)) {
                    return;
                }
                SparkProviderData.Options options = provider.options();
                SparkProviderData.PresetType preset = options.preset();
                List<Integer> colors = options.colors().orElse(SparkParticle.DEFAULT_COLORS);
                switch (preset) {
                    case CAMPFIRE: {
                        if (!ModConfigs.BLOCKS.sparks.campfireSparks) break;
                        ParticleSpawnUtil.spawnSparks(level, random, pos, SparkType.LONG_LIFE, new Box(0.3, 0.4, 0.3, 0.6, 0.4, 0.6), new class_243(0.03, 0.05, 0.03), 10, colors);
                        break;
                    }
                    case TORCH: {
                        if (!ModConfigs.BLOCKS.sparks.torchSparks) break;
                        ParticleSpawnUtil.spawnSparks(level, random, pos, SparkType.SHORT_LIFE, new Box(0.3, 0.5, 0.3, 0.6, 0.5, 0.6), new class_243(0.01, 0.01, 0.01), 2, colors);
                        break;
                    }
                    case WALL_TORCH: {
                        if (!ModConfigs.BLOCKS.sparks.torchSparks || !state.method_28498((class_2769)class_2741.field_12481)) {
                            return;
                        }
                        class_2350 direction = ((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10153();
                        class_243 offset2 = new class_243(0.5 + 0.27 * (double)direction.method_10148(), 0.7, 0.5 + 0.27 * (double)direction.method_10165());
                        ParticleSpawnUtil.spawnSparks(level, random, pos, SparkType.SHORT_LIFE, new Box(offset2.method_1023(0.05, 0.0, 0.05), offset2.method_1031(0.05, 0.0, 0.05)), new class_243(0.01, 0.01, 0.01), 2, colors);
                        break;
                    }
                    case CANDLE: {
                        if (!ModConfigs.BLOCKS.sparks.candleSparks || !(block instanceof class_5540)) break;
                        class_5540 candleBlock = (class_5540)block;
                        candleBlock.method_31613(state).forEach(offset -> ParticleSpawnUtil.spawnSparks(level, random, pos, SparkType.SHORT_LIFE, new Box(offset.method_1023(0.05, 0.0, 0.05), offset.method_1031(0.05, 0.0, 0.05)), new class_243(0.01, 0.01, 0.01), 2, colors));
                        break;
                    }
                    case LANTERN: {
                        for (int i = 0; i < (Integer)ModConfigs.BLOCKS.sparks.lanternSparksDensity.get(); ++i) {
                            int xSign = MathUtil.nextSign(random);
                            int zSign = MathUtil.nextSign(random);
                            level.method_8406((class_2394)SparkParticle.create(SparkType.FLOATING, random, colors), (double)pos.method_10263() + 0.5 + MathUtil.nextDouble(random, 0.5) * (double)xSign, (double)pos.method_10264() + (double)random.method_43048(5) / 10.0, (double)pos.method_10260() + 0.5 + MathUtil.nextDouble(random, 0.5) * (double)zSign, MathUtil.nextDouble(random, 0.03) * (double)xSign, 0.0, MathUtil.nextDouble(random, 0.03) * (double)zSign);
                        }
                        break;
                    }
                    case FIRE: {
                        if (!ModConfigs.BLOCKS.sparks.fireSparks || !(block instanceof class_4770)) break;
                        class_4770 fireBlock = (class_4770)block;
                        class_2338 belowPos = pos.method_10074();
                        class_2680 belowState = level.method_8320(belowPos);
                        if (!fireBlock.method_10195(belowState) && !belowState.method_26206((class_1922)level, belowPos, class_2350.field_11036)) {
                            for (class_2350 direction : class_2350.class_2353.field_11062) {
                                if (!fireBlock.method_10195(level.method_8320(pos.method_10093(direction)))) continue;
                                class_2350.class_2351 axis = direction.method_10166();
                                boolean i = direction.method_10171() != class_2350.class_2352.field_11060;
                                SparkProviderManager.spawnFireSparks(level, random, pos, colors, axis == class_2350.class_2351.field_11048 ? (double)i : random.method_43058(), axis == class_2350.class_2351.field_11051 ? random.method_43058() : (double)i);
                            }
                            return;
                        }
                        SparkProviderManager.spawnFireSparks(level, random, pos, colors, random.method_43058(), random.method_43058());
                        break;
                    }
                    case FURNACE: {
                        if (!ModConfigs.BLOCKS.sparks.furnaceSparks || !state.method_28498((class_2769)class_2741.field_12481)) {
                            return;
                        }
                        class_2350 direction = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
                        class_2350.class_2351 axis = direction.method_10166();
                        for (int i = 0; i < 3; ++i) {
                            level.method_8406((class_2394)SparkParticle.create(SparkType.SHORT_LIFE, random, colors), (double)pos.method_10263() + 0.5 + 0.6 * (double)direction.method_10148() + random.method_43058() / (double)(axis == class_2350.class_2351.field_11048 ? 10 : 3) * (double)MathUtil.nextSign(random), (double)pos.method_10264() + random.method_43058() * 6.0 / 16.0, (double)pos.method_10260() + 0.5 + 0.6 * (double)direction.method_10165() + random.method_43058() / (double)(axis == class_2350.class_2351.field_11051 ? 10 : 3) * (double)MathUtil.nextSign(random), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01));
                        }
                        break;
                    }
                    case CUSTOM: {
                        Box box = options.box().orElse(new Box());
                        SparkType sparkType = options.sparkType().orElse(SparkType.SHORT_LIFE);
                        class_243 velocity = options.velocity().orElse(new class_243(0.03, 0.05, 0.03));
                        class_6017 count = options.count().orElse((class_6017)class_6016.method_34998((int)10));
                        float chance = options.chance().orElse(Float.valueOf(1.0f)).floatValue();
                        if (!(random.method_43057() <= chance)) break;
                        ParticleSpawnUtil.spawnSparks(level, random, pos, sparkType, box, velocity, count.method_35008(random), colors);
                    }
                }
            });
        }
    }

    private static void spawnFireSparks(class_1937 level, class_5819 random, class_2338 pos, List<Integer> colors, double xOffset, double zOffset) {
        for (int i = 0; i < 5; ++i) {
            level.method_8406((class_2394)SparkParticle.create(SparkType.LONG_LIFE, random, colors), (double)pos.method_10263() + xOffset + random.method_43058() / 10.0 * (double)MathUtil.nextSign(random), (double)pos.method_10264() + random.method_43058(), (double)pos.method_10260() + zOffset + random.method_43058() / 10.0 * (double)MathUtil.nextSign(random), MathUtil.nextNonAbsDouble(random, 0.03), MathUtil.nextNonAbsDouble(random, 0.05), MathUtil.nextNonAbsDouble(random, 0.03));
        }
    }
}

