/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.client.renderer.entity;

import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.client.model.entity.PartyHatModel;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModRenderStateKeys;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.util.EntityRenderStateAccessor;
import einstein.subtle_effects.util.Util;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10055;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

public class PartyHatLayer<T extends class_10055, V extends class_572<T>>
extends class_3887<T, V> {
    public static final List<class_2960> TEXTURES = (List)class_156.method_654(new ArrayList(), textures -> {
        PartyHatLayer.addTexture(textures, "big_fuzz_0");
        PartyHatLayer.addTexture(textures, "big_fuzz_1");
        PartyHatLayer.addTexture(textures, "big_fuzz_2");
        PartyHatLayer.addTexture(textures, "big_fuzz_3");
        PartyHatLayer.addTexture(textures, "big_fuzz_4");
        PartyHatLayer.addTexture(textures, "small_fuzz_0");
        PartyHatLayer.addTexture(textures, "small_fuzz_1");
        PartyHatLayer.addTexture(textures, "small_fuzz_2");
        PartyHatLayer.addTexture(textures, "small_fuzz_3");
        PartyHatLayer.addTexture(textures, "small_fuzz_4");
    });
    private final PartyHatModel<T> model;

    public PartyHatLayer(class_3883<T, V> renderer, class_5617.class_5618 context) {
        super(renderer);
        this.model = new PartyHatModel(context.method_32167(PartyHatModel.MODEL_LAYER));
    }

    public static void addTexture(List<class_2960> textures, String name) {
        textures.add(SubtleEffects.loc("textures/entity/party_hat/" + name + ".png"));
    }

    public void render(class_4587 poseStack, class_4597 bufferSource, int packedLight, T renderState, float yRot, float xRot) {
        EntityRenderStateAccessor accessor = (EntityRenderStateAccessor)renderState;
        if (PartyHatLayer.shouldRender(accessor)) {
            poseStack.method_22903();
            ((class_572)this.method_17165()).method_2838().method_22703(poseStack);
            String uuid = accessor.subtleEffects$get(ModRenderStateKeys.STRING_UUID);
            float id = (float)Math.sin(uuid.hashCode());
            poseStack.method_22904(0.0, -0.5, 0.0);
            poseStack.method_49278((Quaternionfc)class_7833.field_40718.rotationDegrees(id * 22.5f), 0.0f, 0.25f, 0.0f);
            class_4588 consumer = bufferSource.getBuffer(this.model.method_23500(PartyHatLayer.getHatTexture(id, uuid)));
            this.model.method_62100(poseStack, consumer, packedLight, class_4608.field_21444, -1);
            poseStack.method_22909();
        }
    }

    private static class_2960 getHatTexture(float id, String uuid) {
        if (Util.isMincraftEinstein(uuid)) {
            return TEXTURES.getFirst();
        }
        int index = (int)(class_3532.method_15379((float)id) * (float)TEXTURES.size());
        return TEXTURES.get(index >= TEXTURES.size() ? TEXTURES.size() - 1 : index);
    }

    public static boolean shouldRender(EntityRenderStateAccessor accessor) {
        return ModConfigs.GENERAL.enableEasterEggs && accessor.subtleEffects$get(ModRenderStateKeys.IS_INVISIBLE) == false;
    }

    public static boolean isModBirthday(boolean ignoreInDev) {
        if (!ignoreInDev && Services.PLATFORM.isDevelopmentEnvironment()) {
            return true;
        }
        LocalDate date = LocalDate.now();
        Month month = date.getMonth();
        int dayOfMonth = date.getDayOfMonth();
        return month == Month.OCTOBER && dayOfMonth >= 3 && dayOfMonth <= 5;
    }
}

