/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.util.Box;
import einstein.subtle_effects.util.SparkType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_5699;
import net.minecraft.class_6017;

public record SparkProviderData(List<BlockStateEntry> states, Optional<Options> options) {
    public static final Codec<SparkProviderData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(BlockStateEntry.CODEC, (int)1, (int)Integer.MAX_VALUE).fieldOf("states").forGetter(SparkProviderData::states), (App)Options.CODEC.optionalFieldOf("options").forGetter(SparkProviderData::options)).apply((Applicative)instance, SparkProviderData::new));

    public record BlockStateEntry(class_2960 id, boolean required, Map<String, String> properties) {
        public static final Codec<BlockStateEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("name").forGetter(BlockStateEntry::id), (App)Codec.BOOL.optionalFieldOf("required", (Object)true).forGetter(BlockStateEntry::required), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("properties", Map.of()).forGetter(BlockStateEntry::properties)).apply((Applicative)instance, BlockStateEntry::new));
    }

    public record Options(PresetType preset, Optional<SparkType> sparkType, Optional<Box> box, Optional<class_6017> count, Optional<Float> chance, Optional<class_243> velocity, Optional<List<Integer>> colors) {
        public static final Codec<Options> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PresetType.CODEC.fieldOf("preset").forGetter(Options::preset), (App)SparkType.CODEC.optionalFieldOf("spark").forGetter(Options::sparkType), (App)Box.CODEC.optionalFieldOf("box").forGetter(Options::box), (App)class_6017.field_29946.optionalFieldOf("count").forGetter(Options::count), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("chance").forGetter(Options::chance), (App)class_243.field_38277.optionalFieldOf("velocity").forGetter(Options::velocity), (App)Codec.withAlternative((Codec)Codec.list((Codec)class_5699.field_54067), (Codec)Codec.STRING, string -> {
            if (string.equals("soul")) {
                return SparkParticle.SOUL_COLORS;
            }
            if (string.equals("default")) {
                return SparkParticle.DEFAULT_COLORS;
            }
            SubtleEffects.LOGGER.error("Spark color must be an integer array or string of either 'soul' or 'default'");
            return null;
        }).optionalFieldOf("colors").forGetter(Options::colors)).apply((Applicative)instance, Options::new));
    }

    public static enum PresetType implements class_3542
    {
        CUSTOM("custom"),
        CAMPFIRE("campfire"),
        FIRE("fire"),
        TORCH("torch"),
        WALL_TORCH("wall_torch"),
        CANDLE("candle"),
        LANTERN("lantern"),
        FURNACE("furnace");

        public static final Codec<PresetType> CODEC;
        private final String name;

        private PresetType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(PresetType::values);
        }
    }
}

