/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.client.renderer.entity;

import einstein.subtle_effects.client.model.entity.EinsteinSolarSystemModel;
import einstein.subtle_effects.client.renderer.entity.EinsteinSolarSystemArmorLayer;
import einstein.subtle_effects.client.renderer.entity.PartyHatLayer;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModRenderStateAttachmentKeys;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.util.RenderStateAttachmentAccessor;
import einstein.subtle_effects.util.Util;
import net.minecraft.class_10034;
import net.minecraft.class_10055;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_7833;
import net.minecraft.class_8136;
import net.minecraft.class_922;
import net.minecraft.class_976;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EinsteinSolarSystemLayer<T extends class_10055, V extends class_572<T>>
extends class_3887<T, V>
implements class_3883<T, EinsteinSolarSystemModel<T>> {
    private static final Vector3f[] HEAD_ROTATIONS = new Vector3f[]{new Vector3f(27.6f, 61.0f, -9.7f), new Vector3f(2.5f, 8.6f, -13.8f), new Vector3f(-64.7f, 48.2f, -41.9f)};
    private final EinsteinSolarSystemModel<T> model;
    private final class_976<T, EinsteinSolarSystemModel<T>> headLayer;
    private final EinsteinSolarSystemArmorLayer<T, EinsteinSolarSystemModel<T>, class_572<T>> armorLayer;
    private final PartyHatLayer<T, EinsteinSolarSystemModel<T>> partyHatLayer;

    public EinsteinSolarSystemLayer(class_3883<T, V> renderer, class_5617.class_5618 context) {
        super(renderer);
        this.model = new EinsteinSolarSystemModel(context.method_32167(EinsteinSolarSystemModel.MODEL_LAYER));
        this.headLayer = new class_976((class_3883)this, context.method_32170());
        this.armorLayer = new EinsteinSolarSystemArmorLayer(this, new class_8136(context.method_32167(class_5602.field_27579)), new class_8136(context.method_32167(class_5602.field_27580)), context.method_64072());
        if (PartyHatLayer.isModBirthday(false)) {
            this.partyHatLayer = new PartyHatLayer(this, context);
            return;
        }
        this.partyHatLayer = null;
    }

    public void render(class_4587 poseStack, class_4597 bufferSource, int packedLight, T renderState, float yRot, float xRot) {
        RenderStateAttachmentAccessor accessor = (RenderStateAttachmentAccessor)renderState;
        if (EinsteinSolarSystemLayer.shouldRender(renderState)) {
            int headCount = HEAD_ROTATIONS.length;
            this.model.field_3394.field_3665 = ((class_10055)renderState).field_53543;
            for (int i = 0; i < headCount; ++i) {
                float i1 = i + 1;
                float spin = EinsteinSolarSystemLayer.getSpin(accessor, i) * ((float)headCount / i1);
                Vector3f rotation = HEAD_ROTATIONS[i];
                poseStack.method_22903();
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-180.0f - ((class_10055)renderState).field_53446));
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation(spin));
                poseStack.method_22904(0.7 * (double)i1, ((class_10055)renderState).field_53410 ? 0.0 : -0.25, 0.0);
                poseStack.method_22905(0.8f, 0.8f, 0.8f);
                poseStack.method_22903();
                poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(rotation.x()));
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(rotation.y()));
                poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(rotation.z()));
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation(spin));
                class_4588 consumer = bufferSource.getBuffer(class_1921.method_23576((class_2960)((class_10055)renderState).field_53520.comp_1626()));
                int packedOverlay = class_922.method_23622(renderState, (float)0.0f);
                this.model.method_2805(true);
                this.model.method_62100(poseStack, consumer, packedLight, packedOverlay, -1);
                poseStack.method_22904(0.0, 0.25, 0.0);
                this.headLayer.method_17159(poseStack, bufferSource, packedLight, renderState, yRot, xRot);
                this.armorLayer.method_17157(poseStack, bufferSource, packedLight, (class_10034)renderState, yRot, xRot);
                if (this.partyHatLayer != null) {
                    this.partyHatLayer.render(poseStack, bufferSource, packedLight, renderState, yRot, xRot);
                }
                poseStack.method_22909();
                poseStack.method_22909();
            }
        }
    }

    public EinsteinSolarSystemModel<T> getModel() {
        return this.model;
    }

    public static boolean shouldRender(class_10034 renderState) {
        String uuid = ((RenderStateAttachmentAccessor)renderState).subtleEffects$get(ModRenderStateAttachmentKeys.STRING_UUID);
        if (uuid == null) {
            return false;
        }
        return ModConfigs.GENERAL.enableEasterEggs && (Util.isMincraftEinstein(uuid) || Services.PLATFORM.isDevelopmentEnvironment()) && !renderState.field_53333;
    }

    public static float getSpin(RenderStateAttachmentAccessor accessor, float speed) {
        return accessor.subtleEffects$get(ModRenderStateAttachmentKeys.SOLAR_SYSTEM_SPIN).floatValue() + (float)Math.PI * speed;
    }
}

