/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import einstein.subtle_effects.util.WeatherColumnInstance;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_9976;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_9976.class})
public abstract class WeatherEffectsRendererMixin {
    @Shadow
    protected abstract class_1959.class_1963 method_62317(class_1937 var1, class_2338 var2);

    @WrapOperation(method={"render(Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/phys/Vec3;IFLjava/util/List;Ljava/util/List;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/WeatherEffectRenderer;RAIN_LOCATION:Lnet/minecraft/resources/ResourceLocation;")})
    private class_2960 replaceRainTexture(Operation<class_2960> original) {
        if (ModConfigs.ENVIRONMENT.biomeColorRain) {
            return Util.COLORLESS_RAIN_TEXTURE;
        }
        return (class_2960)original.call(new Object[0]);
    }

    @ModifyExpressionValue(method={"tickRainParticles"}, at={@At(value="FIELD", target="Lnet/minecraft/core/particles/ParticleTypes;SMOKE:Lnet/minecraft/core/particles/SimpleParticleType;")})
    private class_2400 replaceRainEvaporationParticle(class_2400 original) {
        if (ModConfigs.BLOCKS.steam.replaceRainEvaporationSteam) {
            return ModParticles.STEAM.get();
        }
        return original;
    }

    @ModifyExpressionValue(method={"tickRainParticles"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;is(Lnet/minecraft/world/level/block/Block;)Z")})
    private boolean modifyRainEvaporationBlocks(boolean original, @Local class_2680 state) {
        return original || ModConfigs.BLOCKS.steam.lavaCauldronsEvaporateRain && state.method_27852(class_2246.field_27098);
    }

    @WrapOperation(method={"tickRainParticles"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V")})
    private void modifyCauldronRippleParticlePos(class_638 level, class_2394 options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Operation<Void> original, @Local class_2680 state, @Local class_3610 fluidState, @Local class_5819 random, @Local(ordinal=1) class_2338 pos) {
        if (ModConfigs.BLOCKS.rainWaterRipples) {
            boolean isCauldron = state.method_27852(class_2246.field_27097);
            if (fluidState.method_15767(class_3486.field_15517) || isCauldron) {
                if (random.method_43058() > (double)((Float)ModConfigs.BLOCKS.rainWaterRipplesDensity.get()).floatValue()) {
                    return;
                }
                options = new FloatParticleOptions(ModParticles.WATER_RIPPLE.get(), 1.0f);
                if (isCauldron) {
                    x = (double)pos.method_10263() + 0.1875 + MathUtil.nextDouble(random, 0.625);
                    y = (double)pos.method_10264() + Util.getCauldronFillHeight(state) + 0.01;
                    z = (double)pos.method_10260() + 0.1875 + MathUtil.nextDouble(random, 0.625);
                }
            }
        }
        original.call(new Object[]{level, options, x, y, z, xSpeed, ySpeed, zSpeed});
    }

    @WrapOperation(method={"collectColumnInstances"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WeatherEffectRenderer;createRainColumnInstance(Lnet/minecraft/util/RandomSource;IIIIIIF)Lnet/minecraft/client/renderer/WeatherEffectRenderer$ColumnInstance;")})
    private class_9976.class_9977 collectColumnInstances(class_9976 instance, class_5819 p_364494_, int p_361188_, int p_362466_, int p_364844_, int p_361656_, int p_364160_, int p_361622_, float p_363800_, Operation<class_9976.class_9977> original, class_1937 level, @Local class_2338.class_2339 pos) {
        class_9976.class_9977 column = (class_9976.class_9977)original.call(new Object[]{instance, p_364494_, p_361188_, p_362466_, p_364844_, p_361656_, p_364160_, p_361622_, Float.valueOf(p_363800_)});
        ((WeatherColumnInstance)column).subtleEffects$set(level, pos.method_10062());
        return column;
    }

    @WrapOperation(method={"renderInstances"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexConsumer;setColor(I)Lcom/mojang/blaze3d/vertex/VertexConsumer;")})
    private class_4588 renderSnowAndRain(class_4588 instance, int color, Operation<class_4588> original, @Local class_9976.class_9977 column, @Local(ordinal=4) float alpha) {
        class_2338 pos;
        WeatherColumnInstance weatherColumn = (WeatherColumnInstance)column;
        class_1937 level = weatherColumn.subtleEffects$getLevel();
        if (level != null && this.method_62317(level, pos = weatherColumn.subtleEffects$getPos()) == class_1959.class_1963.field_9382 && ModConfigs.ENVIRONMENT.biomeColorRain) {
            int waterColor = ((class_1959)level.method_23753(pos).comp_349()).method_8687();
            return instance.method_22915((float)(waterColor >> 16) / 255.0f, (float)(waterColor >> 8) / 255.0f, (float)waterColor / 255.0f, alpha);
        }
        return (class_4588)original.call(new Object[]{instance, color});
    }
}

