/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.networking.clientbound;

import einstein.subtle_effects.configs.ReplacedParticlesDisplayType;
import einstein.subtle_effects.init.ModAnimalFedEffectSettings;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.networking.clientbound.ClientBoundAnimalFedPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundBlockDestroyEffectsPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundCompostItemPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundDispenseBucketPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundDrankPotionPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityFellPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityLandInFluidPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntitySpawnSprintingDustCloudsPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundExplosionPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundFallingBlockLandPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundFallingBlockTickPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundMooshroomShearedPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundSheepShearPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundSpawnSnoreParticlePayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundStonecutterUsedPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundVillagerWorkPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundXPBottleEffectsPayload;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.particle.option.SheepFluffParticleOptions;
import einstein.subtle_effects.particle.option.SplashEmitterParticleOptions;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1433;
import net.minecraft.class_1438;
import net.minecraft.class_1472;
import net.minecraft.class_1540;
import net.minecraft.class_1584;
import net.minecraft.class_1646;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2390;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7110;
import net.minecraft.class_8170;

public class ClientPacketHandlers {
    private static final List<class_2248> MASON_STONECUTTER_USE_BLOCKS = List.of(class_2246.field_10340, class_2246.field_10552, class_2246.field_10153, class_2246.field_10115, class_2246.field_10508, class_2246.field_10474);
    private static final List<class_1767> COMMON_SHEPHERD_WOOL_COLORS = List.of(class_1767.field_7952, class_1767.field_7944, class_1767.field_7963, class_1767.field_7957);

    public static void handle(class_638 level, ClientBoundEntityFellPayload payload) {
        class_1297 class_12972 = level.method_8469(payload.entityId());
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            ParticleSpawnUtil.spawnEntityFellParticles(livingEntity, payload.y(), payload.distance(), payload.fallDamage(), ClientPacketHandlers.getEntityFellConfig(payload));
        }
    }

    public static void handle(class_638 level, ClientBoundEntitySpawnSprintingDustCloudsPayload payload) {
        class_1297 class_12972 = level.method_8469(payload.entityId());
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            int ySpeedModifier = 5;
            if (livingEntity instanceof class_1584) {
                ySpeedModifier = 20;
            }
            ParticleSpawnUtil.spawnCreatureMovementDustClouds(livingEntity, (class_1937)level, livingEntity.method_59922(), ySpeedModifier);
        }
    }

    public static void handle(class_638 level, ClientBoundSpawnSnoreParticlePayload payload) {
        if (ModConfigs.BLOCKS.beehivesHaveSleepingZs) {
            level.method_8406((class_2394)ModParticles.SNORING.get(), payload.x(), payload.y(), payload.z(), 0.0, 0.0, 0.0);
        }
    }

    public static void handle(class_638 level, ClientBoundBlockDestroyEffectsPayload payload) {
        if (ClientPacketHandlers.getBlockDestroyEffectConfig(payload)) {
            class_2338 pos = payload.pos();
            class_2680 state = class_2248.method_9531((int)payload.stateId());
            class_2498 soundType = state.method_26231();
            level.method_31595(pos, state);
            level.method_45446(pos, soundType.method_10595(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f, false);
        }
    }

    public static void handle(class_638 level, ClientBoundXPBottleEffectsPayload payload) {
        int i;
        class_2338 pos = payload.pos();
        class_243 vec3 = class_243.method_24955((class_2382)pos);
        class_5819 random = level.method_8409();
        if (ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.BOTH || ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.VANILLA) {
            level.method_20290(2002, pos, -13083194);
        }
        if (ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.BOTH || ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.DEFAULT) {
            for (i = 0; i < (Integer)ModConfigs.ITEMS.projectiles.xpBottleParticlesDensity.get(); ++i) {
                double d = random.method_43058() * 4.0;
                double d1 = random.method_43058() * Math.PI * 2.0;
                double xPower = Math.cos(d1) * d;
                double zPower = Math.sin(d1) * d;
                level.method_8406((class_2394)new FloatParticleOptions(ModParticles.EXPERIENCE.get(), (float)d), vec3.field_1352 + xPower * 0.1, vec3.field_1351 + 0.3, vec3.field_1350 + zPower * 0.1, xPower, 0.01 + random.method_43058() * 0.5, zPower);
            }
        }
        if (ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.DEFAULT) {
            for (i = 0; i < 8; ++i) {
                level.method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)class_1802.field_8436)), vec3.field_1352, vec3.field_1351, vec3.field_1350, random.method_43059() * 0.15, random.method_43058() * 0.2, random.method_43059() * 0.15);
            }
            level.method_45446(pos, class_3417.field_14839, class_3419.field_15254, 1.0f, random.method_43057() * 0.1f + 0.9f, false);
        }
    }

    public static void handle(class_638 level, ClientBoundFallingBlockLandPayload payload) {
        class_2338 pos = payload.pos();
        class_2680 state = class_2248.method_9531((int)payload.stateId());
        class_2248 block = state.method_26204();
        if (ModConfigs.BLOCKS.fallingBlocks.onLandSound && !(block instanceof class_2199)) {
            class_2498 soundType = state.method_26231();
            Util.playClientSound(pos, soundType.method_10598(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
        }
        if (ModConfigs.BLOCKS.fallingBlocks.onLandDust && ModConfigs.BLOCKS.fallingBlocks.dustyBlocks.contains((Object)block)) {
            boolean isInWater = payload.isInWater() && ModConfigs.BLOCKS.fallingBlocks.replaceDustWithBubblesUnderwater;
            class_5819 random = level.method_8409();
            class_2400 options = isInWater ? class_2398.field_11247 : ClientPacketHandlers.getParticleForFallingBlock(level, pos, state);
            for (int i = 0; i < 25; ++i) {
                boolean bool = random.method_43056();
                int xSign = MathUtil.nextSign(random);
                int zSign = MathUtil.nextSign(random);
                level.method_8406((class_2394)options, (double)pos.method_10263() + 0.5 + (bool ? 0.55 * (double)xSign : MathUtil.nextNonAbsDouble(random, 0.55)), (double)pos.method_10264() + MathUtil.nextDouble(random, 0.3), (double)pos.method_10260() + 0.5 + (!bool ? 0.55 * (double)zSign : MathUtil.nextNonAbsDouble(random, 0.55)), bool ? (isInWater ? MathUtil.nextDouble(random, 0.5) : 50.0) * (double)xSign : 0.0, 0.3, !bool ? (isInWater ? MathUtil.nextDouble(random, 0.5) : 50.0) * (double)zSign : 0.0);
            }
        }
    }

    public static void handle(class_638 level, ClientBoundFallingBlockTickPayload payload) {
        class_1297 entity = level.method_8469(payload.entityId());
        if (entity instanceof class_1540) {
            entity.field_6017 = payload.fallDistance();
        }
    }

    public static void handle(class_638 level, ClientBoundCompostItemPayload payload) {
        if (ModConfigs.BLOCKS.compostingItemParticles && (!payload.wasFarmer() || ModConfigs.ENTITIES.villagerWorkAtWorkstationParticles)) {
            class_5819 random = level.method_8409();
            ParticleSpawnUtil.spawnCompostParticles((class_1937)level, payload.pos(), (class_2394)new class_2392(class_2398.field_11218, payload.stack()), MathUtil.nextNonAbsDouble(random, 0.15), MathUtil.nextNonAbsDouble(random, 0.15), MathUtil.nextNonAbsDouble(random, 0.15));
        }
    }

    public static void handle(class_638 level, ClientBoundStonecutterUsedPayload payload) {
        class_2338 pos = payload.pos();
        ParticleSpawnUtil.spawnStonecutterParticles((class_1937)level, payload.stack(), pos, level.method_8320(pos));
    }

    public static void handle(class_638 level, ClientBoundVillagerWorkPayload payload) {
        block13: {
            class_2680 state;
            class_2338 pos;
            class_5819 random;
            int professionLevel;
            class_6880 profession;
            block16: {
                block15: {
                    block14: {
                        if (!ModConfigs.ENTITIES.villagerWorkAtWorkstationParticles) {
                            return;
                        }
                        class_1297 entity = level.method_8469(payload.villagerId());
                        if (!(entity instanceof class_1646)) break block13;
                        class_1646 villager = (class_1646)entity;
                        class_3850 villagerData = villager.method_7231();
                        profession = villagerData.comp_3521();
                        professionLevel = villagerData.comp_3522();
                        random = level.method_8409();
                        pos = payload.pos();
                        state = level.method_8320(pos);
                        if (!profession.method_40225(class_3852.field_17059)) break block14;
                        if (!ModConfigs.BLOCKS.cauldronUseParticles) {
                            return;
                        }
                        double fluidHeight = Util.getCauldronFillHeight(state);
                        class_2394 particle = Util.getCauldronParticle(state);
                        if (!(fluidHeight > 0.0) || particle == null) break block13;
                        for (int i = 0; i < 16; ++i) {
                            level.method_8406(particle, (double)pos.method_10263() + random.method_43058(), (double)pos.method_10264() + fluidHeight, (double)pos.method_10260() + random.method_43058(), 0.0, 0.0, 0.0);
                        }
                        break block13;
                    }
                    if (!profession.method_40225(class_3852.field_17065)) break block15;
                    ParticleSpawnUtil.spawnGrindstoneUsedParticles((class_1937)level, pos, state, random);
                    break block13;
                }
                if (!profession.method_40225(class_3852.field_17064)) break block16;
                if (!ModConfigs.BLOCKS.smithingTableUseParticles) break block13;
                ParticleSpawnUtil.spawnHammeringWorkstationParticles(pos, random, (class_1937)level);
                break block13;
            }
            if (profession.method_40225(class_3852.field_17061)) {
                ParticleSpawnUtil.spawnStonecutterParticles((class_1937)level, new class_1799((class_1935)MASON_STONECUTTER_USE_BLOCKS.get(random.method_43048(MASON_STONECUTTER_USE_BLOCKS.size()))), pos, state);
            } else if (profession.method_40225(class_3852.field_17063)) {
                SheepFluffParticleOptions particle = new SheepFluffParticleOptions(ClientPacketHandlers.getColorForShepherdWoolFluff(professionLevel, random), -1, false);
                for (int i = 0; i < 10; ++i) {
                    level.method_8406((class_2394)particle, (double)pos.method_10263() + random.method_43058(), (double)(pos.method_10264() + 1), (double)pos.method_10260() + random.method_43058(), MathUtil.nextNonAbsDouble(random), random.method_43058(), MathUtil.nextNonAbsDouble(random));
                }
            } else if (profession.method_40225(class_3852.field_17058)) {
                for (int i = 0; i < 8; ++i) {
                    level.method_8406((class_2394)ModParticles.CHICKEN_FEATHER.get(), (double)pos.method_10263() + random.method_43058(), (double)(pos.method_10264() + 1), (double)pos.method_10260() + random.method_43058(), MathUtil.nextNonAbsDouble(random, 0.1), MathUtil.nextDouble(random, 0.1), MathUtil.nextNonAbsDouble(random, 0.1));
                    level.method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)class_1802.field_8145)), (double)pos.method_10263() + random.method_43058(), (double)(pos.method_10264() + 1), (double)pos.method_10260() + random.method_43058(), MathUtil.nextNonAbsDouble(random, 0.25), MathUtil.nextDouble(random, 0.25), MathUtil.nextNonAbsDouble(random, 0.25));
                }
            } else if ((profession.method_40225(class_3852.field_17053) || profession.method_40225(class_3852.field_17052)) && state.method_28498((class_2769)class_2741.field_12548) && !((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                class_2248 block = state.method_26204();
                class_2680 litState = (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true));
                TickerManager.schedule(10, () -> block.method_9496(litState, (class_1937)level, pos, random));
                for (int i = 0; i < 2; ++i) {
                    block.method_9496(litState, (class_1937)level, pos, random);
                }
            }
        }
    }

    public static void handle(class_638 level, ClientBoundMooshroomShearedPayload payload) {
        class_1297 entity = level.method_8469(payload.entityId());
        if (entity instanceof class_1438) {
            class_1438 mooshroom = (class_1438)entity;
            if (!ModConfigs.ENTITIES.improvedMooshroomShearingEffects) {
                level.method_8406((class_2394)class_2398.field_11236, mooshroom.method_23317(), mooshroom.method_23323(0.5), mooshroom.method_23321(), 0.0, 0.0, 0.0);
                return;
            }
            class_5819 random = mooshroom.method_59922();
            class_2392 particle = new class_2392(class_2398.field_11218, new class_1799((class_1935)(mooshroom.method_47847() == class_1438.class_4053.field_18110 ? class_2246.field_10580 : class_2246.field_10240)));
            for (int i = 0; i < 20; ++i) {
                level.method_8406((class_2394)particle, mooshroom.method_23322(1.0), mooshroom.method_23319(), mooshroom.method_23325(1.0), MathUtil.nextNonAbsDouble(random, 0.15), MathUtil.nextDouble(random, 0.15), MathUtil.nextNonAbsDouble(random, 0.15));
            }
            mooshroom.method_5990();
        }
    }

    public static void handle(class_638 level, ClientBoundAnimalFedPayload payload) {
        class_1297 entity = level.method_8469(payload.animalId());
        class_1799 stack = payload.stack();
        if (entity instanceof class_1429 || entity instanceof class_1433 || entity instanceof class_7110) {
            float volume;
            class_1309 livingEntity = (class_1309)entity;
            class_5819 random = entity.method_59922();
            ModAnimalFedEffectSettings.Settings settings = ModAnimalFedEffectSettings.getSetting(entity.method_5864());
            if (ModConfigs.ENTITIES.animalFeedingParticles) {
                for (int i = 0; i < 16; ++i) {
                    ParticleSpawnUtil.spawnEntityFaceParticle((class_2394)new class_2392(class_2398.field_11218, (class_1799)settings.stackReplacer().apply(stack)), livingEntity, (class_1937)level, random, settings.offset(), Util.getPartialTicks());
                }
            }
            if ((volume = ((Float)ModConfigs.ENTITIES.animalFeedingSoundVolume.get()).floatValue()) > 0.0f && !entity.method_5701()) {
                Util.playClientSound(entity, ClientPacketHandlers.getEatSound(livingEntity, stack, settings), entity.method_5634(), volume, livingEntity.method_6017());
            }
        }
    }

    public static void handle(class_638 level, ClientBoundDrankPotionPayload payload) {
        class_1309 livingEntity;
        class_1297 entity = level.method_8469(payload.entityId());
        if (entity instanceof class_1309 && (livingEntity = (class_1309)entity).method_5805()) {
            ParticleSpawnUtil.spawnPotionRings(livingEntity);
        }
    }

    public static void handle(class_638 level, ClientBoundDispenseBucketPayload payload) {
        class_2338 pos = payload.pos();
        class_2680 state = level.method_8320(pos);
        if (state.method_28498((class_2769)class_2741.field_12525)) {
            class_2350 direction = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
            pos = pos.method_10093(direction);
        }
        ParticleSpawnUtil.spawnBucketParticles((class_1937)level, pos, payload.stack());
    }

    public static void handle(class_638 level, ClientBoundSheepShearPayload payload) {
        class_1297 entity = level.method_8469(payload.entityId());
        if (entity instanceof class_1472) {
            class_1472 sheep = (class_1472)entity;
            if (ModConfigs.ENTITIES.sheepShearFluff) {
                ParticleSpawnUtil.sheep(sheep);
            }
        }
    }

    public static void handle(class_638 level, ClientBoundEntityLandInFluidPayload payload) {
        class_1297 entity = level.method_8469(payload.entityId());
        if (entity != null) {
            class_2396<SplashEmitterParticleOptions> particleType = payload.isLava() ? ModParticles.LAVA_SPLASH_EMITTER.get() : ModParticles.WATER_SPLASH_EMITTER.get();
            ParticleSpawnUtil.spawnSplashEffects(entity, (class_1937)level, particleType, payload.y(), payload.yVelocity());
        }
    }

    public static void handle(class_638 level, ClientBoundExplosionPayload payload) {
        if (ModConfigs.ENTITIES.splashes.explosionsCauseSplashes) {
            float radius = payload.radius();
            class_243 position = payload.position();
            class_2338 pos = class_2338.method_49638((class_2374)position);
            class_3610 fluidState = level.method_8316(pos);
            if (!fluidState.method_15769()) {
                int blockY;
                int y = blockY = pos.method_10264();
                while ((double)y < (double)blockY + (double)radius * 1.5 + 1.0) {
                    class_2338 currentPos = pos.method_33096(y);
                    class_3610 currentFluidState = level.method_8316(currentPos);
                    if (!fluidState.method_15772().method_15780(currentFluidState.method_15772())) {
                        class_2396<SplashEmitterParticleOptions> type;
                        if (level.method_8320(currentPos).method_26216()) {
                            return;
                        }
                        Object object = fluidState.method_15767(class_3486.field_15517) ? ModParticles.WATER_SPLASH_EMITTER.get() : (type = fluidState.method_15767(class_3486.field_15518) ? ModParticles.LAVA_SPLASH_EMITTER.get() : null);
                        if (type != null) {
                            class_2338 surfacePos = currentPos.method_10074();
                            class_3610 surfaceFluidState = level.method_8316(surfacePos);
                            float scale = radius - (float)(y - blockY) / radius;
                            level.method_17452((class_2394)new SplashEmitterParticleOptions(type, scale, scale * (scale * 0.1f), -1.0f, -1), true, position.method_10216(), (double)((float)surfacePos.method_10264() + surfaceFluidState.method_15763((class_1922)level, surfacePos)) + 0.01, position.method_10215(), 0.0, 0.0, 0.0);
                        }
                        return;
                    }
                    ++y;
                }
            }
        }
    }

    private static class_3414 getEatSound(class_1309 entity, class_1799 stack, ModAnimalFedEffectSettings.Settings settings) {
        Supplier<class_3414> overrideSound = settings.sound();
        if (overrideSound != null) {
            return overrideSound.get();
        }
        return Util.getEntityEatSound(entity, stack);
    }

    private static class_1767 getColorForShepherdWoolFluff(int professionLevel, class_5819 random) {
        if (professionLevel >= 2 && random.method_43058() < 0.5) {
            return class_1767.values()[random.method_43048(class_1767.values().length)];
        }
        return COMMON_SHEPHERD_WOOL_COLORS.get(random.method_43048(COMMON_SHEPHERD_WOOL_COLORS.size()));
    }

    private static class_2394 getParticleForFallingBlock(class_638 level, class_2338 pos, class_2680 state) {
        if (class_2248.method_16361((class_1922)level, (class_2338)pos.method_10074())) {
            int color = ClientPacketHandlers.getFallingBlockDustColor(level, state.method_26204(), state, pos);
            return new class_2390(color, 1.0f);
        }
        return new class_2388(class_2398.field_11206, state);
    }

    private static int getFallingBlockDustColor(class_638 level, class_2248 block, class_2680 state, class_2338 pos) {
        class_8170 brushableBlock;
        class_2248 turnsIntoBlock;
        if (block instanceof class_2346) {
            class_2346 fallingBlock = (class_2346)block;
            return fallingBlock.method_10130(state, (class_1922)level, pos);
        }
        if (block instanceof class_8170 && (turnsIntoBlock = (brushableBlock = (class_8170)block).method_49810()) != block) {
            return ClientPacketHandlers.getFallingBlockDustColor(level, turnsIntoBlock, state, pos);
        }
        return class_310.method_1551().method_1505().method_1691(state, (class_1937)level, pos);
    }

    private static boolean getBlockDestroyEffectConfig(ClientBoundBlockDestroyEffectsPayload packet) {
        return switch (packet.config()) {
            default -> throw new MatchException(null, null);
            case ClientBoundBlockDestroyEffectsPayload.TypeConfig.LEAVES_DECAY -> ModConfigs.BLOCKS.leavesDecayEffects;
            case ClientBoundBlockDestroyEffectsPayload.TypeConfig.FARMLAND_DESTROY -> ModConfigs.BLOCKS.farmlandDestroyEffects;
        };
    }

    private static boolean getEntityFellConfig(ClientBoundEntityFellPayload packet) {
        return switch (packet.config()) {
            default -> throw new MatchException(null, null);
            case ClientBoundEntityFellPayload.TypeConfig.ENTITY -> ModConfigs.ENTITIES.dustClouds.mobFell;
            case ClientBoundEntityFellPayload.TypeConfig.PLAYER -> ModConfigs.ENTITIES.dustClouds.playerFell;
            case ClientBoundEntityFellPayload.TypeConfig.MACE -> ModConfigs.ENTITIES.dustClouds.landMaceAttack;
            case ClientBoundEntityFellPayload.TypeConfig.ELYTRA -> ModConfigs.ENTITIES.dustClouds.flyIntoWall;
        };
    }
}

