/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.compat.EndRemasteredCompat;
import einstein.subtle_effects.data.MobSkullShaderData;
import einstein.subtle_effects.data.MobSkullShaderReloadListener;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.mixin.client.GameRendererAccessor;
import einstein.subtle_effects.mixin.client.block.AbstractCauldronBlockAccessor;
import einstein.subtle_effects.mixin.client.entity.AbstractHorseAccessor;
import einstein.subtle_effects.particle.option.SplashDropletParticleOptions;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedColor;
import net.minecraft.class_10124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1453;
import net.minecraft.class_1496;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4076;
import net.minecraft.class_4985;
import net.minecraft.class_5498;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_757;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static final int BREATH_DELAY = 60;
    public static final int SNORE_DELAY = 10;
    public static final int MAX_Z_COUNT = 3;
    public static final int PARTICLE_LIGHT_COLOR = 240;
    public static final class_2390 GLOWSTONE_DUST_PARTICLES = new class_2390(16759902, 1.0f);
    public static final class_2960 COLORLESS_RAIN_TEXTURE = SubtleEffects.loc("textures/environment/colorless_rain.png");
    public static final Gson GSON = new GsonBuilder().create();
    public static final class_2960 VANILLA_EYE = class_2960.method_60656((String)"ender_eye");
    private static final String UUID = "d71e4b41-9315-499f-a934-ca925421fb38";

    public static void playClientSound(class_1297 entity, class_3414 sound, class_3419 source, float volume, float pitch) {
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        if (level != null && level.field_9236) {
            level.method_43129((class_1297)minecraft.field_1724, entity, sound, source, volume, pitch);
        }
    }

    public static void playClientSound(class_2338 pos, class_3414 sound, class_3419 source, float volume, float pitch) {
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        if (level != null && level.field_9236) {
            level.method_43128((class_1297)minecraft.field_1724, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), sound, source, volume, pitch);
        }
    }

    public static boolean isSolidOrNotEmpty(class_1937 level, class_2338 pos) {
        return level.method_8320(pos).method_26216() || !level.method_8316(pos).method_15769();
    }

    public static void applyHelmetShader(class_1799 stack, class_5498 cameraType) {
        if (!cameraType.method_31034()) {
            return;
        }
        class_757 gameRenderer = class_310.method_1551().field_1773;
        for (MobSkullShaderData shaderData : MobSkullShaderReloadListener.MOB_SKULL_SHADERS.values()) {
            if (!shaderData.stackHolder().matches(stack)) continue;
            Util.loadShaderEffect(shaderData.shaderId(), gameRenderer);
            return;
        }
        gameRenderer.method_62905();
    }

    private static void loadShaderEffect(class_2960 shaderId, class_757 gameRenderer) {
        class_2960 effect = gameRenderer.method_62906();
        if (effect == null || !effect.equals((Object)shaderId)) {
            ((GameRendererAccessor)gameRenderer).setShaderEffect(shaderId);
        }
    }

    public static void setColorFromHex(class_703 particle, int hexColor) {
        particle.method_3084((float)(hexColor >> 16) / 255.0f, (float)(hexColor >> 8) / 255.0f, (float)hexColor / 255.0f);
    }

    public static boolean isChunkLoaded(class_1937 level, double blockX, double blockZ) {
        return level.method_8398().method_12123(class_4076.method_42615((double)blockX), class_4076.method_42615((double)blockZ));
    }

    public static double getCauldronFillHeight(class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_2275) {
            class_2275 block = (class_2275)class_22482;
            return ((AbstractCauldronBlockAccessor)block).getFillHeight(state);
        }
        return 0.0;
    }

    public static class_3611 getCauldronFluid(class_2680 state) {
        if (state.method_27852(class_2246.field_27098)) {
            return class_3612.field_15908;
        }
        if (state.method_27852(class_2246.field_27097)) {
            return class_3612.field_15910;
        }
        return class_3612.field_15906;
    }

    @Nullable
    public static class_2394 getParticleForFluid(class_3611 fluid) {
        if (fluid.method_15780((class_3611)class_3612.field_15910)) {
            return new SplashDropletParticleOptions(ModParticles.WATER_SPLASH_DROPLET.get(), 1.0f);
        }
        if (fluid.method_15780((class_3611)class_3612.field_15908)) {
            return new SplashDropletParticleOptions(ModParticles.LAVA_SPLASH_DROPLET.get(), 1.0f);
        }
        return null;
    }

    public static ValidatedColor.ColorHolder getEyeColorHolder(class_1937 level, class_2338 pos) {
        ValidatedColor.ColorHolder color;
        if (CompatHelper.IS_END_REMASTERED_LOADED.get().booleanValue() && (color = EndRemasteredCompat.getEyeColor(level, pos)) != null) {
            return color;
        }
        ValidatedColor.ColorHolder vanillaColor = (ValidatedColor.ColorHolder)ModConfigs.BLOCKS.eyeColors.get((Object)VANILLA_EYE);
        if (vanillaColor != null) {
            return vanillaColor;
        }
        return Util.toColorHolder(0x7ABAAB);
    }

    public static ValidatedColor.ColorHolder toColorHolder(int color) {
        return new ValidatedColor.ColorHolder(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255, false);
    }

    public static float randomizeColor(class_5819 random, float color, float multiplier) {
        return (random.method_43057() * 0.2f + 0.8f) * color * multiplier;
    }

    public static void setRandomizedColor(class_703 particle, class_5819 random, float r, float g, float b) {
        float multiplier = random.method_43057() * 0.4f + 0.6f;
        particle.method_3084(Util.randomizeColor(random, r, multiplier), Util.randomizeColor(random, g, multiplier), Util.randomizeColor(random, b, multiplier));
    }

    @Nullable
    public static class_2394 getCauldronParticle(class_2680 state) {
        class_3611 fluid = Util.getCauldronFluid(state);
        if (!fluid.method_15780(class_3612.field_15906)) {
            return Util.getParticleForFluid(fluid);
        }
        if (state.method_27852(class_2246.field_27878)) {
            return (class_2394)ModParticles.SNOW.get();
        }
        return null;
    }

    public static float getPartialTicks() {
        return Util.getPartialTicks(false);
    }

    public static float getPartialTicks(boolean runsNormally) {
        return class_310.method_1551().method_61966().method_60637(runsNormally);
    }

    public static class_3414 getEntityEatSound(class_1309 entity, class_1799 stack) {
        class_1496 horse;
        class_3414 horseEatSound;
        if (entity instanceof class_1496 && (horseEatSound = ((AbstractHorseAccessor)(horse = (class_1496)entity)).getEatSound()) != null && !horseEatSound.equals(class_3417.field_20614.comp_349())) {
            return horseEatSound;
        }
        class_3414 eatSound = null;
        if (entity instanceof class_10124.class_10126) {
            class_10124.class_10126 soundOverride = (class_10124.class_10126)entity;
            eatSound = soundOverride.method_18807(stack);
        }
        class_3414 stackEatSound = null;
        if (stack.method_57826(class_9334.field_53964)) {
            stackEatSound = (class_3414)((class_10124)stack.method_58694(class_9334.field_53964)).comp_3087().comp_349();
        }
        if (eatSound != null && !((class_3414)class_3417.field_20614.comp_349()).equals((Object)eatSound) && !eatSound.equals((Object)stackEatSound)) {
            return eatSound;
        }
        if (entity instanceof class_4985) {
            return class_3417.field_23207;
        }
        if (entity instanceof class_1453) {
            return class_3417.field_14960;
        }
        return stackEatSound != null ? stackEatSound : (class_3414)class_3417.field_20614.comp_349();
    }

    public static boolean isMincraftEinstein(String uuid) {
        return uuid.equals(UUID);
    }

    public static String getOrdinal(long number) {
        return number + (number == 1L ? "st" : (number == 2L ? "nd" : (number == 3L ? "rd" : "th")));
    }

    public static boolean isRainingAt(class_1937 level, class_2338 pos) {
        if (level.method_8419() && level.method_8624(class_2902.class_2903.field_13203, pos.method_10263(), pos.method_10260()) <= pos.method_10264()) {
            return ((class_1959)level.method_23753(pos).comp_349()).method_48162(pos, level.method_8615()) == class_1959.class_1963.field_9382;
        }
        return false;
    }
}

