/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.common.entity;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.networking.clientbound.ClientBoundDrankPotionPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityFellPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntitySpawnSprintingDustCloudsPacket;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class CommonLivingEntityMixin
extends Entity {
    @Unique
    private boolean subtleEffects$validEntity;
    @Unique
    private float subtleEffects$minSpeed;
    @Unique
    private boolean subtleEffects$canStart = true;
    @Unique
    private Vec3 subtleEffects$lastCheckedPos;
    @Unique
    private final LivingEntity subtleEffects$me = (LivingEntity)this;

    public CommonLivingEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(EntityType<?> type, Level level, CallbackInfo ci) {
        if (this.subtleEffects$me instanceof Ravager) {
            this.subtleEffects$validEntity = true;
            this.subtleEffects$minSpeed = 0.34f;
        }
        if (this.subtleEffects$me instanceof Goat) {
            this.subtleEffects$validEntity = true;
            this.subtleEffects$minSpeed = 0.4f;
        }
        if (this.subtleEffects$me instanceof Hoglin || this.subtleEffects$me instanceof Zoglin) {
            this.subtleEffects$validEntity = true;
            this.subtleEffects$minSpeed = 0.28f;
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        if (!this.m_9236_().f_46443_) {
            if (this.subtleEffects$me.m_20145_()) {
                return;
            }
            if ((this.subtleEffects$canStart || this.m_20182_().m_82557_(this.subtleEffects$lastCheckedPos) > 0.5) && this.subtleEffects$validEntity) {
                if (this.m_20096_() && this.subtleEffects$me.m_6113_() > this.subtleEffects$minSpeed) {
                    Services.NETWORK.sendToClientsTracking((ServerLevel)this.m_9236_(), this.subtleEffects$me.m_20183_(), new ClientBoundEntitySpawnSprintingDustCloudsPacket(this.m_19879_()));
                    this.subtleEffects$lastCheckedPos = this.m_20182_();
                    this.subtleEffects$canStart = false;
                    return;
                }
                this.subtleEffects$lastCheckedPos = Vec3.f_82478_;
                this.subtleEffects$canStart = true;
            }
        }
    }

    @ModifyExpressionValue(method={"causeFallDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;calculateFallDamage(FF)I")})
    private int calculateFallDamage(int damage, float distance, float damageMultiplier) {
        if (!this.subtleEffects$me.m_20145_()) {
            ParticleSpawnUtil.spawnFallDustClouds(this.subtleEffects$me, damageMultiplier, damage, this.subtleEffects$me instanceof Player ? ClientBoundEntityFellPacket.TypeConfig.PLAYER : ClientBoundEntityFellPacket.TypeConfig.ENTITY);
        }
        return damage;
    }

    @ModifyExpressionValue(method={"travel"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/Level;isClientSide:Z", ordinal=0)})
    private boolean cancelFlyIntoWallServerCheck(boolean original) {
        return false;
    }

    @WrapWithCondition(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;playSound(Lnet/minecraft/sounds/SoundEvent;FF)V")})
    private boolean cancelFlyIntoWallClientSound(LivingEntity entity, SoundEvent sound, float volume, float pitch) {
        return !this.m_9236_().f_46443_;
    }

    @WrapWithCondition(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    private boolean cancelFlyIntoWallClientHurt(LivingEntity entity, DamageSource source, float amount) {
        Player player;
        if (!(entity instanceof Player && (player = (Player)entity).m_7500_() || entity.m_20145_())) {
            ParticleSpawnUtil.spawnFallDustClouds(entity, 10.0f, 10, ClientBoundEntityFellPacket.TypeConfig.ELYTRA);
        }
        return !this.m_9236_().f_46443_;
    }

    @WrapOperation(method={"tickEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V")})
    private void replaceSlimeEffect(Level level, ParticleOptions options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Operation<Void> original) {
        if (level.f_46443_) {
            if (ModConfigs.ENTITIES.replaceOozingEffectParticles && options.m_6012_().equals(ParticleTypes.f_123753_)) {
                level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50374_.m_49966_()), x, y, z, 0.0, 0.0, 0.0);
                return;
            }
            original.call(new Object[]{level, options, x, y, z, xSpeed, ySpeed, zSpeed});
        }
    }

    @Inject(method={"completeUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;triggerItemUseEffects(Lnet/minecraft/world/item/ItemStack;I)V")})
    private void spawnPotionParticles(CallbackInfo ci) {
        if (this.subtleEffects$me.m_20145_()) {
            return;
        }
        Level level = this.subtleEffects$me.m_9236_();
        if (level instanceof ServerLevel) {
            ServerPlayer player;
            ServerLevel level2 = (ServerLevel)level;
            LivingEntity livingEntity = this.subtleEffects$me;
            Services.NETWORK.sendToClientsTracking(livingEntity instanceof ServerPlayer ? (player = (ServerPlayer)livingEntity) : null, level2, this.subtleEffects$me.m_20183_(), new ClientBoundDrankPotionPayload(this.subtleEffects$me.m_19879_()));
            return;
        }
        ParticleSpawnUtil.spawnPotionRings(this.subtleEffects$me);
    }
}

