/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.configs.ModBlockConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.particle.option.PositionParticleOptions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BeaconParticle
extends SparkParticle {
    private final BlockPos beaconPos;
    private final List<BeaconBlockEntity.BeaconBeamSection> beamSections = new ArrayList<BeaconBlockEntity.BeaconBeamSection>();

    protected BeaconParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites, BlockPos beaconPos) {
        super(level, x, y, z, 0.0, 0.0, 0.0, 0.0f, sprites);
        this.beaconPos = beaconPos;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107226_ = -0.1f * ((Float)ModConfigs.BLOCKS.beaconParticlesSpeed.get()).floatValue();
        this.f_107225_ = 1;
        this.f_107219_ = false;
        this.f_172259_ = false;
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.f_107224_ % 20 == 0) {
            boolean hasMultipleSections;
            BlockEntity blockEntity = this.f_107208_.m_7702_(this.beaconPos);
            if (!(blockEntity instanceof BeaconBlockEntity)) {
                this.m_107274_();
                return;
            }
            BeaconBlockEntity beaconBlockEntity = (BeaconBlockEntity)blockEntity;
            List sections = beaconBlockEntity.m_58702_();
            boolean isNotColored = ModConfigs.BLOCKS.beaconParticlesDisplayType == ModBlockConfigs.BeaconParticlesDisplayType.NOT_COLORED;
            boolean bl = hasMultipleSections = sections.size() > 1;
            if (sections.isEmpty() || hasMultipleSections && isNotColored) {
                this.m_107274_();
                return;
            }
            boolean hadMultipleSections = this.beamSections.size() > 1;
            this.beamSections.clear();
            if (!isNotColored && hasMultipleSections || hadMultipleSections) {
                this.beamSections.addAll(sections);
            }
        }
        if (this.f_107213_ >= (double)Mth.m_14107_((double)this.f_107213_) && !this.beamSections.isEmpty()) {
            BeaconBlockEntity.BeaconBeamSection beamSection = null;
            int lastHeight = this.beaconPos.m_123342_() - 1;
            for (BeaconBlockEntity.BeaconBeamSection section : this.beamSections) {
                if (!(this.f_107213_ >= (double)(lastHeight += section.m_58723_()))) continue;
                beamSection = section;
            }
            if (beamSection != null) {
                float[] colors = beamSection.m_58722_();
                this.f_107227_ = colors[0];
                this.f_107228_ = colors[1];
                this.f_107229_ = colors[2];
            }
        }
        if (this.f_107213_ == this.f_107210_ || this.f_107213_ >= (double)this.f_107208_.m_151558_()) {
            this.m_107274_();
            return;
        }
        ++this.f_107225_;
    }

    @Override
    public float m_5902_(float partialTicks) {
        return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + partialTicks) / 20.0f * 32.0f), (float)0.0f, (float)1.0f);
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<PositionParticleOptions>
    {
        public Particle createParticle(PositionParticleOptions type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new BeaconParticle(level, x, y, z, this.sprites, type.pos());
        }
    }
}

