/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking.tickers;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.ticking.tickers.BlockPosTicker;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.util.ChestAccessor;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public class ChestBlockEntityTicker
extends BlockPosTicker {
    private static final int MAX_TICKS_SINCE_LAST_ANIMATION = 100;
    private static final Map<BlockPos, ChestBlockEntityTicker> CHEST_TICKERS = new HashMap<BlockPos, ChestBlockEntityTicker>();
    private int ticksSinceLastAnimation;
    private int animationTicks;
    private float oldOpenness;
    private final ChestLidController lidController;

    public ChestBlockEntityTicker(Level level, BlockPos pos, ChestLidController lidController) {
        super(level, pos);
        this.lidController = lidController;
    }

    public static void trySpawn(Level level, BlockPos pos) {
        if (!ModConfigs.BLOCKS.chestsOpenRandomlyUnderwater && !ModConfigs.BLOCKS.openingChestsSpawnsBubbles) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity == null || CHEST_TICKERS.containsKey(pos)) {
            return;
        }
        if (blockEntity instanceof ChestAccessor) {
            ChestAccessor chestAccessor = (ChestAccessor)blockEntity;
            ChestBlockEntityTicker ticker = new ChestBlockEntityTicker(level, pos, chestAccessor.subtleEffects$getLidController());
            CHEST_TICKERS.put(pos, ticker);
            TickerManager.add(ticker);
        }
    }

    public static void clear() {
        CHEST_TICKERS.values().forEach(ticker -> ticker.lidController.m_155377_(false));
        CHEST_TICKERS.clear();
    }

    @Override
    protected void positionedTick() {
        ChestType type;
        BlockState state = this.level.m_8055_(this.pos);
        if (!(state.m_60734_() instanceof AbstractChestBlock)) {
            this.remove();
            return;
        }
        BlockEntity blockEntity = this.level.m_7702_(this.pos);
        if (!(blockEntity instanceof ChestBlockEntity)) {
            return;
        }
        ChestType chestType = type = state.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)state.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
        if (type == ChestType.LEFT) {
            return;
        }
        boolean isDoubleChest = type != ChestType.SINGLE;
        Direction connectedDirection = isDoubleChest ? ChestBlock.m_51584_((BlockState)state) : Direction.NORTH;
        BlockPos oppositePos = this.pos.m_121945_(connectedDirection);
        if (ChestBlock.m_51508_((LevelAccessor)this.level, (BlockPos)this.pos) || isDoubleChest && ChestBlock.m_51508_((LevelAccessor)this.level, (BlockPos)oppositePos)) {
            this.animationTicks = 0;
            this.ticksSinceLastAnimation = 0;
            return;
        }
        if (ModConfigs.BLOCKS.randomChestOpeningNeedsSoulSand && (this.isNotUpwardsBubbleColumn(this.pos) || isDoubleChest && this.isNotUpwardsBubbleColumn(oppositePos))) {
            return;
        }
        if (!this.isUnderwater(this.pos) || isDoubleChest && !this.isUnderwater(oppositePos)) {
            return;
        }
        RandomSource random = this.level.m_213780_();
        float openness = this.lidController.m_155375_(Util.getPartialTicks());
        if (openness > 0.0f && ModConfigs.BLOCKS.openingChestsSpawnsBubbles) {
            boolean isClosing;
            boolean bl = isClosing = (double)openness <= 0.5 && openness < this.oldOpenness;
            if (isClosing || random.m_188503_(isDoubleChest ? 2 : 4) == 0) {
                double xOffset = 0.0;
                double zOffset = 0.0;
                double xRandomOffset = 0.3125;
                double zRandomOffset = 0.3125;
                if (isDoubleChest) {
                    xOffset = 0.5 * (double)connectedDirection.m_122429_();
                    zOffset = 0.5 * (double)connectedDirection.m_122431_();
                    Direction.Axis axis = connectedDirection.m_122434_();
                    if (axis == Direction.Axis.X) {
                        xRandomOffset = 0.8125;
                    } else if (axis == Direction.Axis.Z) {
                        zRandomOffset = 0.8125;
                    }
                }
                double xSpeed = 0.0;
                double zSpeed = 0.0;
                if (isClosing) {
                    Direction facing = (Direction)state.m_61143_((Property)ChestBlock.f_51478_);
                    xSpeed = 0.5 * (double)facing.m_122429_();
                    zSpeed = 0.5 * (double)facing.m_122431_();
                }
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123774_, (double)this.pos.m_123341_() + 0.5 + xOffset + MathUtil.nextNonAbsDouble(random, xRandomOffset), (double)this.pos.m_123342_() + 0.625, (double)this.pos.m_123343_() + 0.5 + zOffset + MathUtil.nextNonAbsDouble(random, zRandomOffset), xSpeed, 0.0, zSpeed);
            }
        }
        this.oldOpenness = openness;
        if (this.isDownwardsBubbleColumn(this.pos) || isDoubleChest && this.isDownwardsBubbleColumn(oppositePos)) {
            return;
        }
        if (this.ticksSinceLastAnimation < 100) {
            ++this.ticksSinceLastAnimation;
            return;
        }
        boolean isEnderChest = state.m_60713_(Blocks.f_50265_);
        if (ModConfigs.BLOCKS.chestsOpenRandomlyUnderwater && random.m_188503_(100) == 0 && openness == 0.0f) {
            blockEntity.m_7531_(1, 1);
            this.playSound(connectedDirection, type, isEnderChest ? SoundEvents.f_11889_ : SoundEvents.f_11749_);
            this.animationTicks = Mth.m_216271_((RandomSource)random, (int)50, (int)200);
            return;
        }
        if (this.animationTicks > 0) {
            --this.animationTicks;
            if (this.animationTicks <= 0) {
                blockEntity.m_7531_(1, 0);
                this.playSound(connectedDirection, type, isEnderChest ? SoundEvents.f_11888_ : SoundEvents.f_11747_);
                this.ticksSinceLastAnimation = 0;
            }
        }
    }

    private boolean isNotUpwardsBubbleColumn(BlockPos pos) {
        BlockState belowState = this.level.m_8055_(pos.m_7495_());
        return !belowState.m_60713_(Blocks.f_50135_) && (!belowState.m_60713_(Blocks.f_50628_) || (Boolean)belowState.m_61143_((Property)BubbleColumnBlock.f_50956_) != false);
    }

    private boolean isDownwardsBubbleColumn(BlockPos pos) {
        BlockState belowState = this.level.m_8055_(pos.m_7495_());
        return belowState.m_60713_(Blocks.f_50450_) || belowState.m_60713_(Blocks.f_50628_) && (Boolean)belowState.m_61143_((Property)BubbleColumnBlock.f_50956_) != false;
    }

    @Override
    public void remove() {
        super.remove();
        CHEST_TICKERS.remove(this.pos);
    }

    private boolean isUnderwater(BlockPos pos) {
        return this.level.m_46801_(pos) && this.level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    private void playSound(Direction direction, ChestType type, SoundEvent sound) {
        double x = (float)this.pos.m_123341_() + 0.5f;
        double y = (float)this.pos.m_123342_() + 0.5f;
        double z = (float)this.pos.m_123343_() + 0.5f;
        if (type == ChestType.RIGHT) {
            x += (double)((float)direction.m_122429_() * 0.5f);
            z += (double)((float)direction.m_122431_() * 0.5f);
        }
        this.level.m_6263_((Player)Minecraft.m_91087_().f_91074_, x, y, z, sound, SoundSource.BLOCKS, 0.5f, this.level.m_213780_().m_188501_() * 0.1f + 0.9f);
    }
}

