/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking.tickers.entity;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.mixin.client.block.AbstractCauldronBlockAccessor;
import einstein.subtle_effects.mixin.common.entity.EntityAccessor;
import einstein.subtle_effects.ticking.tickers.entity.EntityTicker;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public class EntityCauldronTicker
extends EntityTicker<Entity> {
    private boolean wasInWaterCauldron;
    private boolean wasInLavaCauldron;

    public EntityCauldronTicker(Entity entity) {
        super(entity);
    }

    @Override
    public void entityTick() {
        BlockPos pos = this.entity.m_20183_();
        BlockState state = this.level.m_8055_(pos);
        double height = Util.getCauldronFillHeight(state);
        if ((state.m_60713_(Blocks.f_152478_) || state.m_60713_(Blocks.f_152476_)) && height > 0.0 && this.entity.m_6060_() && ((AbstractCauldronBlockAccessor)state.m_60734_()).isEntityInside(state, pos, this.entity)) {
            ((EntityAccessor)this.entity).playExtinguishedSound();
        }
        if (height > 0.0 && (double)pos.m_123342_() + height >= this.entity.m_20186_()) {
            if (state.m_60713_(Blocks.f_152476_) && !this.wasInWaterCauldron) {
                this.wasInWaterCauldron = true;
                ((EntityAccessor)this.entity).doWaterSplashingEffects();
            } else if (state.m_60713_(Blocks.f_152477_) && !this.wasInLavaCauldron && ModConfigs.ENTITIES.splashes.lavaSplashes) {
                this.wasInLavaCauldron = true;
                ParticleSpawnUtil.spawnSplashEffects(this.entity, this.level, ModParticles.LAVA_SPLASH_EMITTER.get(), (TagKey<Fluid>)FluidTags.f_13132_);
            }
            return;
        }
        this.wasInWaterCauldron = false;
        this.wasInLavaCauldron = false;
    }
}

