/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking.tickers.entity;

import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.ticking.tickers.entity.EntityTicker;
import einstein.subtle_effects.ticking.tickers.entity.SimpleTicker;
import einstein.subtle_effects.util.EntityProvider;
import einstein.subtle_effects.util.EntityTickerAccessor;
import einstein.subtle_effects.util.Util;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityTickerManager {
    public static final List<TickerProvider<?>> REGISTERED = new ArrayList();
    private static final IntList ENTITIES = new IntArrayList();
    public static final int INNER_RANGE = 128;
    public static final int OUTER_RANGE = 144;
    private static int REGISTRATION_ID = 0;

    public static <T extends Entity> void register(Predicate<Entity> predicate, Function<T, EntityTicker<T>> function) {
        REGISTERED.add(new TickerProvider<T>(REGISTRATION_ID++, predicate, function));
    }

    public static <T extends Entity> void registerSimple(EntityType<T> type, boolean checkVisibility, Supplier<Boolean> isEnabled, EntityProvider<T> provider) {
        EntityTickerManager.registerSimple(entity -> entity.m_6095_().equals(type) && (Boolean)isEnabled.get() != false, checkVisibility, provider);
    }

    public static <T extends Entity> void registerSimple(Predicate<Entity> predicate, boolean checkVisibility, EntityProvider<T> provider) {
        EntityTickerManager.register(predicate, entity -> new SimpleTicker<Entity>((Entity)entity, provider, checkVisibility));
    }

    public static <T extends Entity> void createTickersForEntity(T entity) {
        if (EntityTickerManager.isEntityInRange(entity, 128)) {
            Int2ObjectMap<EntityTicker<?>> tickers = ((EntityTickerAccessor)entity).subtleEffects$getTickers();
            REGISTERED.forEach(provider -> {
                int id = provider.id();
                if (!tickers.containsKey(id) && provider.predicate().test(entity)) {
                    EntityTicker ticker = provider.function().apply(entity);
                    ticker.setId(id);
                    tickers.put(id, ticker);
                    TickerManager.add(ticker);
                    ENTITIES.add(entity.m_19879_());
                }
            });
        }
    }

    public static <T extends Entity> boolean isEntityInRange(T entity, int range) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            if (player.m_7306_(entity)) {
                return true;
            }
            Vec3 position = entity.m_20182_();
            return Util.isChunkLoaded(entity.m_9236_(), position.m_7096_(), position.m_7094_()) && player.m_20182_().m_82509_((Position)position, (double)range);
        }
        return false;
    }

    public static void clear(@Nullable Level level) {
        if (level != null) {
            ENTITIES.forEach(id -> {
                Entity entity = level.m_6815_(id);
                if (entity != null) {
                    ((EntityTickerAccessor)entity).subtleEffects$getTickers().clear();
                }
            });
        }
        ENTITIES.clear();
    }

    public record TickerProvider<T extends Entity>(int id, Predicate<Entity> predicate, Function<T, EntityTicker<T>> function) {
    }
}

