/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.client.renderer.entity;

import einstein.subtle_effects.client.model.entity.EinsteinSolarSystemModel;
import einstein.subtle_effects.client.renderer.entity.EinsteinSolarSystemArmorLayer;
import einstein.subtle_effects.client.renderer.entity.EinsteinSolarSystemRenderLayerParentImpl;
import einstein.subtle_effects.client.renderer.entity.PartyHatLayer;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.util.Util;
import net.minecraft.class_1309;
import net.minecraft.class_1664;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import net.minecraft.class_8136;
import net.minecraft.class_922;
import net.minecraft.class_976;
import org.joml.Vector3f;

public class EinsteinSolarSystemLayer<T extends class_742, V extends class_591<T>>
extends class_3887<T, V> {
    private static final Vector3f[] HEAD_ROTATIONS = new Vector3f[]{new Vector3f(27.6f, 61.0f, -9.7f), new Vector3f(2.5f, 8.6f, -13.8f), new Vector3f(-64.7f, 48.2f, -41.9f)};
    private final EinsteinSolarSystemRenderLayerParentImpl<T, V> renderLayerParent;
    private final EinsteinSolarSystemModel<T> model;
    private final class_976<T, EinsteinSolarSystemModel<T>> headLayer;
    private final EinsteinSolarSystemArmorLayer<T, EinsteinSolarSystemModel<T>, class_572<T>> armorLayer;
    private final PartyHatLayer<T, EinsteinSolarSystemModel<T>> partyHatLayer;

    public EinsteinSolarSystemLayer(class_3883<T, V> renderer, class_5617.class_5618 context) {
        super(renderer);
        this.model = new EinsteinSolarSystemModel(context.method_32167(EinsteinSolarSystemModel.MODEL_LAYER));
        this.renderLayerParent = new EinsteinSolarSystemRenderLayerParentImpl(this);
        this.headLayer = new class_976(this.renderLayerParent, context.method_32170(), context.method_43338());
        this.armorLayer = new EinsteinSolarSystemArmorLayer<T, V, class_8136>(this.renderLayerParent, new class_8136(context.method_32167(class_5602.field_27579)), new class_8136(context.method_32167(class_5602.field_27580)), context.method_48481());
        if (PartyHatLayer.isModBirthday(false)) {
            this.partyHatLayer = new PartyHatLayer<T, V>(this.renderLayerParent, context);
            return;
        }
        this.partyHatLayer = null;
    }

    public void render(class_4587 poseStack, class_4597 bufferSource, int packedLight, T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (EinsteinSolarSystemLayer.shouldRender(player)) {
            int headCount = HEAD_ROTATIONS.length;
            this.model.field_3394.field_3665 = player.method_7348(class_1664.field_7563);
            for (int i = 0; i < headCount; ++i) {
                float i1 = i + 1;
                float spin = EinsteinSolarSystemLayer.getSpin(partialTicks, player, i) * ((float)headCount / i1);
                Vector3f rotation = HEAD_ROTATIONS[i];
                poseStack.method_22903();
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(-180.0f - class_3532.method_17821((float)partialTicks, (float)((class_742)player).field_6220, (float)((class_742)player).field_6283)));
                poseStack.method_22907(class_7833.field_40716.rotation(spin));
                poseStack.method_22904(0.7 * (double)i1, player.method_18276() ? 0.0 : -0.25, 0.0);
                poseStack.method_22905(0.8f, 0.8f, 0.8f);
                poseStack.method_22903();
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(rotation.x()));
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(rotation.y()));
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(rotation.z()));
                poseStack.method_22907(class_7833.field_40716.rotation(spin));
                class_4588 consumer = bufferSource.getBuffer(class_1921.method_23576((class_2960)this.getTextureLocation(player)));
                this.model.method_2828(poseStack, consumer, packedLight, class_922.method_23622(player, (float)0.0f), 0.0f, 0.0f, 0.0f, 0.0f);
                poseStack.method_22904(0.0, 0.25, 0.0);
                this.headLayer.method_17159(poseStack, bufferSource, packedLight, player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                this.armorLayer.method_17157(poseStack, bufferSource, packedLight, (class_1309)player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                if (this.partyHatLayer != null) {
                    this.partyHatLayer.render(poseStack, bufferSource, packedLight, player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                }
                poseStack.method_22909();
                poseStack.method_22909();
            }
        }
    }

    public class_2960 getTextureLocation(T player) {
        return super.method_23194(player);
    }

    public EinsteinSolarSystemModel<T> getModel() {
        return this.model;
    }

    public EinsteinSolarSystemRenderLayerParentImpl<T, V> getRenderLayerParent() {
        return this.renderLayerParent;
    }

    public static boolean shouldRender(class_742 player) {
        return ModConfigs.GENERAL.enableEasterEggs && (Util.isMincraftEinstein(player) || Services.PLATFORM.isDevelopmentEnvironment()) && !player.method_5767();
    }

    public static float getSpin(float partialTicks, class_742 player, float speed) {
        return ((float)player.field_6012 + partialTicks) / 20.0f + (float)Math.PI * speed;
    }
}

