/*
 * Decompiled with CFR 0.152.
 */
package com.kito1z.not_enough_oxygen.blocks.entity;

import com.kito1z.not_enough_oxygen.NEOConfig;
import com.kito1z.not_enough_oxygen.NotEnoughOxygen;
import com.kito1z.not_enough_oxygen.blocks.VentBlock;
import com.kito1z.not_enough_oxygen.registry.NEOBlockEntities;
import com.kito1z.not_enough_oxygen.registry.NEOEffects;
import com.kito1z.not_enough_oxygen.utils.HermeticArea;
import com.kito1z.not_enough_oxygen.utils.VSCompat;
import java.util.List;
import mekanism.common.registries.MekanismFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VentBlockEntity
extends BlockEntity {
    private int leftTicks = 0;
    private int checkTick = 0;
    private HermeticArea hermeticArea = new HermeticArea();
    private final FluidTank tank = new FluidTank(1000, fluid -> fluid.getFluid() == MekanismFluids.OXYGEN.getFluid());
    private LazyOptional<FluidTank> tankLazyOptional = LazyOptional.of(() -> this.tank);

    public VentBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)NEOBlockEntities.VENT_BLOCK_ENTITY.get(), p_155229_, p_155230_);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.tankLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    private boolean consumeOxygen(int amount) {
        int total = this.tank.getFluidAmount() * NEOConfig.oxygenConsumption + this.leftTicks;
        if (total < amount) {
            return false;
        }
        this.tank.getFluid().setAmount((total -= amount) / 10);
        this.leftTicks = total % 10;
        return true;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity t) {
        if (level.f_46443_) {
            return;
        }
        VentBlockEntity entity = (VentBlockEntity)t;
        Direction dir = (Direction)state.m_61143_((Property)VentBlock.FACING);
        if (entity.checkTick <= 0) {
            entity.hermeticArea.bakeArea((ServerLevel)level, pos.m_121955_(dir.m_122436_()));
            entity.checkTick = 100;
        }
        List players = ((ServerLevel)level).m_6907_();
        if (entity.hermeticArea.isHermetic() && entity.consumeOxygen(entity.hermeticArea.getArea().size() / NEOConfig.ventConsumption)) {
            for (ServerPlayer player : players) {
                boolean vsLogicSuccess = NotEnoughOxygen.ModsLoaded.VS && VSCompat.applyOxygenToVSPlayer(player, pos, entity.hermeticArea);
                if (vsLogicSuccess) continue;
                Vec3 eyePos = player.m_146892_();
                BlockPos eyeBlockPos = new BlockPos((int)eyePos.f_82479_, (int)eyePos.f_82480_, (int)eyePos.f_82481_);
                if (!entity.hermeticArea.getArea().contains(eyeBlockPos)) continue;
                player.m_7292_(new MobEffectInstance((MobEffect)NEOEffects.OXYGEN_SATURATION.get(), 5, 0, false, false));
            }
        }
        --entity.checkTick;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.tankLazyOptional.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.tankLazyOptional = LazyOptional.of(() -> this.tank);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        tag.m_128405_("ticks", this.leftTicks);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tank.readFromNBT((CompoundTag)tag.m_128423_("tank"));
        this.leftTicks = tag.m_128451_("ticks");
    }
}

