/*
 * Decompiled with CFR 0.152.
 */
package com.kito1z.not_enough_oxygen.utils;

import com.kito1z.not_enough_oxygen.NEOConfig;
import com.kito1z.not_enough_oxygen.utils.HermeticUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;

public class HermeticArea {
    public static final int limit = NEOConfig.ventRange;
    private final Set<BlockPos> area = new HashSet<BlockPos>();
    private boolean hermetic = false;

    public boolean bakeArea(ServerLevel level, BlockPos start) {
        this.area.clear();
        if (HermeticUtils.isHermetic(level, start)) {
            this.hermetic = false;
            return false;
        }
        this.area.add(start);
        ArrayList<BlockPos> oldLayer = new ArrayList<BlockPos>();
        oldLayer.add(start);
        while (this.area.size() < limit && !oldLayer.isEmpty()) {
            ArrayList<BlockPos> temp = new ArrayList<BlockPos>();
            for (int i = 0; i < oldLayer.size() && this.area.size() < limit; ++i) {
                this.bakeNeighbors(level, (BlockPos)oldLayer.get(i), temp);
            }
            oldLayer = temp;
        }
        this.hermetic = oldLayer.isEmpty();
        return this.hermetic;
    }

    public void bakeNeighbors(ServerLevel level, BlockPos pos, @Nullable List<BlockPos> temp) {
        for (Direction dir : Direction.values()) {
            if (this.area.size() >= limit) {
                return;
            }
            BlockPos neighbor = pos.m_121945_(dir);
            if (this.area.contains(neighbor) || HermeticUtils.isHermetic(level, neighbor)) continue;
            this.area.add(neighbor);
            if (temp == null) continue;
            temp.add(neighbor);
        }
    }

    public Set<BlockPos> getArea() {
        return this.area;
    }

    public boolean isHermetic() {
        return this.hermetic;
    }
}

