/*
 * Decompiled with CFR 0.152.
 */
package limitedlegends;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import limitedlegends.LimitedLegendsConfig;

public class ConfigLoader {
    private static LimitedLegendsConfig config;

    public static LimitedLegendsConfig loadConfig() {
        if (config == null) {
            boolean dirCreated;
            Path configFilePath = Paths.get("config", "limitedlegends.json");
            File configFile = configFilePath.toFile();
            if (!configFile.getParentFile().exists() && (dirCreated = configFile.getParentFile().mkdirs())) {
                System.out.println("Created config directory.");
            }
            if (!configFile.exists()) {
                ConfigLoader.createDefaultConfig(configFile);
            }
            config = ConfigLoader.loadConfigFromFile(configFilePath);
            ConfigLoader.saveConfig(configFile);
        }
        return config;
    }

    private static LimitedLegendsConfig loadConfigFromFile(Path path) {
        LimitedLegendsConfig limitedLegendsConfig;
        FileReader reader = new FileReader(path.toFile());
        try {
            Gson gson = new Gson();
            limitedLegendsConfig = (LimitedLegendsConfig)gson.fromJson((Reader)reader, LimitedLegendsConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonIOException | IOException e) {
                System.out.println("Error loading config from file: " + path.toString() + ", using default values.");
                e.printStackTrace();
                return new LimitedLegendsConfig();
            }
        }
        reader.close();
        return limitedLegendsConfig;
    }

    private static void createDefaultConfig(File configFile) {
        try (FileWriter writer = new FileWriter(configFile);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            LimitedLegendsConfig defaultConfig = new LimitedLegendsConfig();
            gson.toJson((Object)defaultConfig, (Appendable)writer);
            System.out.println("Created default config file: " + configFile.getPath());
        }
        catch (IOException e) {
            System.out.println("Failed to create default config file: " + configFile.getPath());
            e.printStackTrace();
        }
    }

    private static void saveConfig(File configFile) {
        try (FileWriter writer = new FileWriter(configFile);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((Object)config, (Appendable)writer);
            System.out.println("Config file updated with new fields.");
        }
        catch (IOException e) {
            System.out.println("Failed to update config file.");
            e.printStackTrace();
        }
    }
}

