/*
 * Decompiled with CFR 0.152.
 */
package com.github.slaxlax.limitedlegends;

import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.github.slaxlax.limitedlegends.ConfigLoader;
import com.github.slaxlax.limitedlegends.LimitedLegends;
import com.github.slaxlax.limitedlegends.LimitedLegendsConfig;
import com.github.slaxlax.limitedlegends.SavedCaptureData;
import com.github.slaxlax.limitedlegends.SavedPlayerCaptureData;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/github/slaxlax/limitedlegends/PokemonBackfiller;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "backfillCapturedData", "(Lnet/minecraft/server/MinecraftServer;)V", "", "", "getAllPlayerUUIDs", "(Lnet/minecraft/server/MinecraftServer;)Ljava/util/List;", "playerUUID", "loadPlayerPCData", "(Ljava/lang/String;)Ljava/util/List;", "loadPlayerPartyData", "LimitedLegends-neoforge"})
@SourceDebugExtension(value={"SMAP\nPokemonBackfiller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokemonBackfiller.kt\ncom/github/slaxlax/limitedlegends/PokemonBackfiller\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,218:1\n1611#2,9:219\n1863#2:228\n1864#2:230\n1620#2:231\n1863#2:232\n1863#2,2:233\n1863#2,2:235\n1864#2:237\n1#3:229\n1#3:238\n1#3:249\n11420#4,9:239\n13346#4:248\n13347#4:250\n11429#4:251\n*S KotlinDebug\n*F\n+ 1 PokemonBackfiller.kt\ncom/github/slaxlax/limitedlegends/PokemonBackfiller\n*L\n31#1:219,9\n31#1:228\n31#1:230\n31#1:231\n39#1:232\n44#1:233,2\n54#1:235,2\n39#1:237\n31#1:229\n208#1:249\n208#1:239,9\n208#1:248\n208#1:250\n208#1:251\n*E\n"})
public final class PokemonBackfiller {
    public PokemonBackfiller() {
        LimitedLegends.Companion.getLOGGER().info("PokemonBackfiller instance created.");
    }

    /*
     * WARNING - void declaration
     */
    public final void backfillCapturedData(@NotNull MinecraftServer server) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        SavedCaptureData savedCaptureData = SavedCaptureData.Companion.get(server.getLevel(Level.OVERWORLD));
        SavedPlayerCaptureData savedPlayerCaptureData = SavedPlayerCaptureData.Companion.get(server.getLevel(Level.OVERWORLD));
        savedCaptureData.reset();
        savedPlayerCaptureData.reset();
        List<String> players = this.getAllPlayerUUIDs(server);
        LimitedLegendsConfig config = ConfigLoader.loadConfig();
        List<String> list = config.SpecificLimits;
        Intrinsics.checkNotNullExpressionValue(list, (String)"SpecificLimits");
        Iterable iterable = list;
        boolean $i$f$mapNotNull = false;
        void var9_9 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String entry = (String)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)entry);
            String[] stringArray = new String[]{":"};
            List parts = StringsKt.split$default((CharSequence)entry, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if ((parts.size() >= 2 ? parts.get(0) + ":" + parts.get(1) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set specificLimits = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List<String> list2 = config.LimitedPokemon;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"LimitedPokemon");
        Set allLimitedSpecies = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)list2, (Iterable)specificLimits));
        Iterable $this$forEach$iv = players;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String uuid = (String)element$iv;
            boolean bl = false;
            LimitedLegends.Companion.getLOGGER().info("Processing player UUID: " + uuid);
            List<String> speciesList = this.loadPlayerPartyData(uuid);
            LimitedLegends.Companion.getLOGGER().info("Loaded party data for " + uuid + ": " + speciesList);
            Iterable $this$forEach$iv2 = speciesList;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String species = (String)element$iv2;
                boolean bl4 = false;
                if (!config.ApplyEverythingToAll && !allLimitedSpecies.contains(species)) continue;
                LimitedLegends.Companion.getLOGGER().info("Incrementing species: " + species);
                savedCaptureData.increment(species);
                savedPlayerCaptureData.increment(uuid, species);
            }
            List<String> pcSpeciesList = this.loadPlayerPCData(uuid);
            LimitedLegends.Companion.getLOGGER().info("Loaded PC data for " + uuid + ": " + pcSpeciesList);
            Iterable $this$forEach$iv3 = pcSpeciesList;
            boolean $i$f$forEach4 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                String species = (String)element$iv3;
                boolean bl5 = false;
                if (!config.ApplyEverythingToAll && !allLimitedSpecies.contains(species)) continue;
                LimitedLegends.Companion.getLOGGER().info("Incrementing species: " + species);
                savedCaptureData.increment(species);
                savedPlayerCaptureData.increment(uuid, species);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<String> loadPlayerPartyData(String playerUUID) {
        v0 = DistributionUtilsKt.server();
        v1 = worldPath = v0 != null ? v0.getWorldPath(LevelResource.ROOT) : null;
        if (worldPath == null) ** GOTO lbl-1000
        v2 = playerUUID.substring(0, 2);
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
        var4_3 = worldPath.resolve("pokemon/playerpartystore/" + v2 + "/" + playerUUID + ".dat");
        if (var4_3 != null) {
            v3 = var4_3.toFile();
        } else lbl-1000:
        // 2 sources

        {
            v3 = null;
        }
        playerPartyFile = v3;
        speciesList = new ArrayList<E>();
        v4 = playerPartyFile;
        v5 = v4 != null ? Boolean.valueOf(v4.exists()) : null;
        Intrinsics.checkNotNull((Object)v5);
        if (!v5.booleanValue()) {
            LimitedLegends.Companion.getLOGGER().warn("Party file not found for player " + playerUUID + " at: " + playerPartyFile.getAbsolutePath());
        }
        if (playerPartyFile.exists()) {
            try {
                var5_5 = new FileInputStream(playerPartyFile);
                var6_8 = null;
                try {
                    fis = (FileInputStream)var5_5;
                    $i$a$-use-PokemonBackfiller$loadPlayerPartyData$1 = false;
                    nbtTag = null;
                    try {
                        dataInputStream = new DataInputStream(fis);
                        accounter = new NbtAccounter(0x7FFFFFFFFFFFFFFFL, 1000000);
                        nbtTag = NbtIo.read((DataInput)dataInputStream, (NbtAccounter)accounter);
                    }
                    catch (IOException e) {
                        fis.close();
                        accounter = new FileInputStream(playerPartyFile);
                        var12_17 = null;
                        try {
                            compressedFis = (FileInputStream)accounter;
                            $i$a$-use-PokemonBackfiller$loadPlayerPartyData$1$1 = false;
                            compressedDataInputStream = new DataInputStream(compressedFis);
                            accounter = new NbtAccounter(0x7FFFFFFFFFFFFFFFL, 1000000);
                            nbtTag = NbtIo.readCompressed((InputStream)compressedDataInputStream, (NbtAccounter)accounter);
                            compressedFis = Unit.INSTANCE;
                        }
                        catch (Throwable compressedFis /* !! */ ) {
                            var12_17 = compressedFis /* !! */ ;
                            throw compressedFis /* !! */ ;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)accounter, (Throwable)var12_17);
                        }
                    }
                    if (nbtTag instanceof CompoundTag) {
                        compoundTag = nbtTag;
                        var12_17 = new String[]{"Slot0", "Slot1", "Slot2", "Slot3", "Slot4", "Slot5"};
                        slots = CollectionsKt.listOf((Object[])var12_17);
                        for (String slotKey : slots) {
                            if (!compoundTag.contains(slotKey) || !(slotData = compoundTag.getCompound(slotKey)).contains("Species", 8)) continue;
                            species = slotData.getString("Species");
                            Intrinsics.checkNotNull((Object)species);
                            speciesList.add(species);
                        }
                    }
                    var7_9 = Unit.INSTANCE;
                }
                catch (Throwable var7_10) {
                    var6_8 = var7_10;
                    throw var7_10;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var5_5, (Throwable)var6_8);
                }
            }
            catch (IOException e) {
                LimitedLegends.Companion.getLOGGER().info("Error reading the file for player " + playerUUID + ": " + e.getMessage());
            }
            catch (Exception e) {
                LimitedLegends.Companion.getLOGGER().info("Error processing party data for player " + playerUUID + ": " + e.getMessage());
            }
        }
        return speciesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final List<String> loadPlayerPCData(String playerUUID) {
        v0 = DistributionUtilsKt.server();
        worldPath = v0 != null ? v0.getWorldPath(LevelResource.ROOT) : null;
        speciesList = new ArrayList<E>();
        if (worldPath == null) ** GOTO lbl-1000
        v1 = playerUUID.substring(0, 2);
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
        var5_4 = worldPath.resolve("pokemon/pcstore/" + v1 + "/" + playerUUID + ".dat");
        if (var5_4 != null) {
            v2 = var5_4.toFile();
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        v3 = pcFile = v2;
        v4 = v3 != null ? Boolean.valueOf(v3.exists()) : null;
        Intrinsics.checkNotNull((Object)v4);
        if (!v4.booleanValue()) {
            LimitedLegends.Companion.getLOGGER().warn("PC file not found for player " + playerUUID + " at: " + pcFile.getAbsolutePath());
        }
        if (pcFile.exists()) {
            try {
                var5_4 = new FileInputStream(pcFile);
                var6_8 = null;
                try {
                    fis = (FileInputStream)var5_4;
                    $i$a$-use-PokemonBackfiller$loadPlayerPCData$1 = false;
                    nbtTag = null;
                    try {
                        dataInputStream = new DataInputStream(fis);
                        accounter = new NbtAccounter(0x7FFFFFFFFFFFFFFFL, 1000000);
                        nbtTag = NbtIo.read((DataInput)dataInputStream, (NbtAccounter)accounter);
                    }
                    catch (IOException e) {
                        fis.close();
                        accounter = new FileInputStream(pcFile);
                        var12_18 = null;
                        try {
                            compressedFis = (FileInputStream)accounter;
                            $i$a$-use-PokemonBackfiller$loadPlayerPCData$1$1 = false;
                            compressedDataInputStream = new DataInputStream((InputStream)compressedFis);
                            accounter = new NbtAccounter(0x7FFFFFFFFFFFFFFFL, 1000000);
                            nbtTag = NbtIo.readCompressed((InputStream)compressedDataInputStream, (NbtAccounter)accounter);
                            compressedFis = Unit.INSTANCE;
                        }
                        catch (Throwable compressedFis) {
                            var12_18 = compressedFis;
                            throw compressedFis;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)accounter, (Throwable)var12_18);
                        }
                    }
                    if (nbtTag instanceof CompoundTag) {
                        compoundTag = nbtTag;
                        compressedFis = compoundTag.getInt("BoxCount");
                        it = ((Number)compressedFis).intValue();
                        $i$a$-takeIf-PokemonBackfiller$loadPlayerPCData$1$boxCount$1 = false;
                        v5 = it > 0 != false ? compressedFis : null;
                        boxCount = v5 != null ? v5.intValue() : 30;
                        for (boxIndex = 0; boxIndex < boxCount; ++boxIndex) {
                            boxKey = "Box" + boxIndex;
                            if (!compoundTag.contains(boxKey)) continue;
                            boxCompound = compoundTag.getCompound(boxKey);
                            slotKeys = boxCompound.getAllKeys();
                            boxData = new ArrayList<E>();
                            for (String slotKey : slotKeys) {
                                slotTag = boxCompound.get(slotKey);
                                if (!(slotTag instanceof CompoundTag)) continue;
                                boxData.add(slotTag);
                            }
                            if (!(((Collection)boxData).isEmpty() == false)) continue;
                            var18_32 = boxData.size();
                            for (slotIndex = 0; slotIndex < var18_32; ++slotIndex) {
                                v6 = boxData.get(slotIndex);
                                Intrinsics.checkNotNull(v6, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
                                slotData = (CompoundTag)v6;
                                if (slotData.size() <= 0) continue;
                                slotKey = "Slot" + slotIndex;
                                if (!slotData.contains("Species", 8)) continue;
                                species = slotData.getString("Species");
                                Intrinsics.checkNotNull((Object)species);
                                if (!(((CharSequence)species).length() > 0)) continue;
                                speciesList.add(species);
                            }
                        }
                    }
                    var7_9 = Unit.INSTANCE;
                }
                catch (Throwable var7_10) {
                    var6_8 = var7_10;
                    throw var7_10;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var5_4, (Throwable)var6_8);
                }
            }
            catch (IOException e) {
                LimitedLegends.Companion.getLOGGER().info("Error reading the file for player " + playerUUID + " (PC Data): " + e.getMessage());
            }
            catch (Exception e) {
                LimitedLegends.Companion.getLOGGER().info("Error processing PC data for player " + playerUUID + ": " + e.getMessage());
            }
        }
        return speciesList;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getAllPlayerUUIDs(MinecraftServer server) {
        void $this$mapNotNullTo$iv$iv;
        File playerDataFolder = server.getWorldPath(LevelResource.PLAYER_DATA_DIR).toFile();
        LimitedLegends.Companion.getLOGGER().info("Searching for player data in: " + playerDataFolder.getAbsolutePath());
        File[] files = playerDataFolder.listFiles(PokemonBackfiller::getAllPlayerUUIDs$lambda$9);
        if (files == null) {
            LimitedLegends.Companion.getLOGGER().info("Failed to list files in player data folder.");
            return CollectionsKt.emptyList();
        }
        LimitedLegends.Companion.getLOGGER().info("Found " + files.length + " player data files.");
        File[] $this$mapNotNull$iv = files;
        boolean $i$f$mapNotNull = false;
        File[] fileArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            String it$iv$iv;
            String string;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void file = element$iv$iv;
            boolean bl2 = false;
            try {
                Intrinsics.checkNotNull((Object)file);
                string = FilesKt.getNameWithoutExtension((File)file);
            }
            catch (IllegalArgumentException e) {
                LimitedLegends.Companion.getLOGGER().info("Error processing file " + file.getName() + ": " + e.getMessage());
                string = null;
            }
            if (string == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean getAllPlayerUUIDs$lambda$9(File file) {
        Intrinsics.checkNotNull((Object)file);
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"dat");
    }
}

