/*
 * Decompiled with CFR 0.152.
 */
package com.github.slaxlax.limitedlegends;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\n\u0018\u0000 '2\u00020\u0001:\u0001'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\bJ\u001b\u0010\u0013\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0015\u0010\u0003J\u001f\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001b\u0010\u001c\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011\u00a2\u0006\u0004\b\u001c\u0010\u001dR \u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\"\u0010!\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lcom/github/slaxlax/limitedlegends/SavedCaptureData;", "Lnet/minecraft/world/level/saveddata/SavedData;", "<init>", "()V", "", "name", "", "decrement", "(Ljava/lang/String;)V", "", "getCount", "(Ljava/lang/String;)I", "captureLimit", "", "hasReachedLimit", "(Ljava/lang/String;I)Z", "increment", "", "limitedSpecies", "markInitialized", "(Ljava/util/Set;)V", "reset", "Lnet/minecraft/nbt/CompoundTag;", "tag", "Lnet/minecraft/core/HolderLookup$Provider;", "registries", "save", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;", "shouldInitialize", "(Ljava/util/Set;)Z", "", "captureCounts", "Ljava/util/Map;", "lastConfigHash", "I", "getLastConfigHash", "()I", "setLastConfigHash", "(I)V", "Companion", "LimitedLegends-neoforge"})
public final class SavedCaptureData
extends SavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Integer> captureCounts = new LinkedHashMap();
    private int lastConfigHash;
    @NotNull
    private static final String DATA_NAME = "limitedlegends_data";
    @JvmField
    @NotNull
    public static final SavedData.Factory<SavedCaptureData> FACTORY = new SavedData.Factory(SavedCaptureData::FACTORY$lambda$0, SavedCaptureData::FACTORY$lambda$2);

    private SavedCaptureData() {
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag countsTag = new CompoundTag();
        for (Map.Entry<String, Integer> entry : this.captureCounts.entrySet()) {
            String name = entry.getKey();
            int count = ((Number)entry.getValue()).intValue();
            countsTag.putInt(name, count);
        }
        tag.put("Counts", (Tag)countsTag);
        return tag;
    }

    public final int getCount(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.captureCounts.get(name);
        return n != null ? n : 0;
    }

    public final void increment(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.captureCounts.put(name, this.getCount(name) + 1);
        this.setDirty();
    }

    public final void decrement(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int currentCount = this.getCount(name);
        if (currentCount > 0) {
            this.captureCounts.put(name, this.getCount(name) - 1);
            this.setDirty();
        }
    }

    public final void reset() {
        this.captureCounts.clear();
        this.setDirty();
    }

    public final boolean hasReachedLimit(@NotNull String name, int captureLimit) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getCount(name) >= captureLimit;
    }

    public final int getLastConfigHash() {
        return this.lastConfigHash;
    }

    public final void setLastConfigHash(int n) {
        this.lastConfigHash = n;
    }

    public final boolean shouldInitialize(@NotNull Set<String> limitedSpecies) {
        Intrinsics.checkNotNullParameter(limitedSpecies, (String)"limitedSpecies");
        int currentHash = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)limitedSpecies), null, null, null, (int)0, null, null, (int)63, null).hashCode();
        return currentHash != this.lastConfigHash;
    }

    public final void markInitialized(@NotNull Set<String> limitedSpecies) {
        Intrinsics.checkNotNullParameter(limitedSpecies, (String)"limitedSpecies");
        int currentHash = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)limitedSpecies), null, null, null, (int)0, null, null, (int)63, null).hashCode();
        if (currentHash != this.lastConfigHash) {
            this.lastConfigHash = currentHash;
            this.setDirty();
        }
    }

    private static final SavedCaptureData FACTORY$lambda$0() {
        return new SavedCaptureData();
    }

    private static final SavedCaptureData FACTORY$lambda$2(CompoundTag nbt, HolderLookup.Provider provider) {
        SavedCaptureData savedCaptureData;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"<anonymous parameter 1>");
        SavedCaptureData $this$FACTORY_u24lambda_u242_u24lambda_u241 = savedCaptureData = new SavedCaptureData();
        boolean bl = false;
        if (nbt.contains("Counts", 10)) {
            CompoundTag countsTag = nbt.getCompound("Counts");
            for (String key : countsTag.getAllKeys()) {
                Map<String, Integer> map = $this$FACTORY_u24lambda_u242_u24lambda_u241.captureCounts;
                Intrinsics.checkNotNull((Object)key);
                map.put(key, countsTag.getInt(key));
            }
        }
        return savedCaptureData;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\f8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/github/slaxlax/limitedlegends/SavedCaptureData$Companion;", "", "<init>", "()V", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lcom/github/slaxlax/limitedlegends/SavedCaptureData;", "get", "(Lnet/minecraft/server/level/ServerLevel;)Lcom/github/slaxlax/limitedlegends/SavedCaptureData;", "", "DATA_NAME", "Ljava/lang/String;", "Lnet/minecraft/world/level/saveddata/SavedData$Factory;", "FACTORY", "Lnet/minecraft/world/level/saveddata/SavedData$Factory;", "LimitedLegends-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SavedCaptureData get(@Nullable ServerLevel level) {
            ServerLevel serverLevel = level;
            if (serverLevel == null || (serverLevel = serverLevel.getServer()) == null || (serverLevel = serverLevel.getLevel(Level.OVERWORLD)) == null) {
                throw new IllegalStateException("Overworld not loaded!".toString());
            }
            ServerLevel overworld = serverLevel;
            SavedData savedData = overworld.getDataStorage().computeIfAbsent(FACTORY, SavedCaptureData.DATA_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)savedData, (String)"computeIfAbsent(...)");
            return (SavedCaptureData)savedData;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

