/*
 * Decompiled with CFR 0.152.
 */
package com.github.slaxlax.limitedlegends;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.entity.SpawnEvent;
import com.cobblemon.mod.common.api.events.pokeball.PokeBallCaptureCalculatedEvent;
import com.cobblemon.mod.common.api.events.pokeball.PokemonCatchRateEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.TradeCompletedEvent;
import com.cobblemon.mod.common.api.events.storage.ReleasePokemonEvent;
import com.cobblemon.mod.common.api.pokeball.PokeBalls;
import com.cobblemon.mod.common.api.pokeball.catching.CaptureContext;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.PokeBallItem;
import com.cobblemon.mod.common.pokeball.PokeBall;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.trade.ActiveTrade;
import com.cobblemon.mod.common.trade.TradeManager;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.github.slaxlax.limitedlegends.ConfigLoader;
import com.github.slaxlax.limitedlegends.LimitedLegends;
import com.github.slaxlax.limitedlegends.LimitedLegendsConfig;
import com.github.slaxlax.limitedlegends.SavedCaptureData;
import com.github.slaxlax.limitedlegends.SavedPlayerCaptureData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0013\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0018\u0010\u0003J\u001d\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a*\u00020\u0019\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0014\u0010 \u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u001c\u0010#\u001a\n \"*\u0004\u0018\u00010\u00190\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R \u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lcom/github/slaxlax/limitedlegends/LegendaryListener;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/events/pokeball/PokeBallCaptureCalculatedEvent;", "event", "", "onPokemonCapture", "(Lcom/cobblemon/mod/common/api/events/pokeball/PokeBallCaptureCalculatedEvent;)V", "Lcom/cobblemon/mod/common/api/events/pokemon/PokemonCapturedEvent;", "onPokemonCaptured", "(Lcom/cobblemon/mod/common/api/events/pokemon/PokemonCapturedEvent;)V", "Lcom/cobblemon/mod/common/api/events/pokeball/PokemonCatchRateEvent;", "onPokemonCatchRate", "(Lcom/cobblemon/mod/common/api/events/pokeball/PokemonCatchRateEvent;)V", "Lcom/cobblemon/mod/common/api/events/storage/ReleasePokemonEvent;", "onPokemonRelease", "(Lcom/cobblemon/mod/common/api/events/storage/ReleasePokemonEvent;)V", "Lcom/cobblemon/mod/common/api/events/entity/SpawnEvent;", "onPokemonSpawn", "(Lcom/cobblemon/mod/common/api/events/entity/SpawnEvent;)V", "Lcom/cobblemon/mod/common/api/events/pokemon/TradeCompletedEvent;", "onTrade", "(Lcom/cobblemon/mod/common/api/events/pokemon/TradeCompletedEvent;)V", "register", "Lcom/github/slaxlax/limitedlegends/LimitedLegendsConfig;", "", "", "", "getSpecificLimitMap", "(Lcom/github/slaxlax/limitedlegends/LimitedLegendsConfig;)Ljava/util/Map;", "Lorg/apache/logging/log4j/Logger;", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "config", "Lcom/github/slaxlax/limitedlegends/LimitedLegendsConfig;", "specificLimits", "Ljava/util/Map;", "LimitedLegends-neoforge"})
@SourceDebugExtension(value={"SMAP\nLegendaryListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegendaryListener.kt\ncom/github/slaxlax/limitedlegends/LegendaryListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,316:1\n1863#2,2:317\n1863#2,2:319\n1863#2,2:321\n1611#2,9:323\n1863#2:332\n1557#2:333\n1628#2,3:334\n1864#2:338\n1620#2:339\n1#3:337\n*S KotlinDebug\n*F\n+ 1 LegendaryListener.kt\ncom/github/slaxlax/limitedlegends/LegendaryListener\n*L\n145#1:317,2\n173#1:319,2\n296#1:321,2\n306#1:323,9\n306#1:332\n307#1:333\n307#1:334,3\n306#1:338\n306#1:339\n306#1:337\n*E\n"})
public final class LegendaryListener {
    @NotNull
    public static final LegendaryListener INSTANCE = new LegendaryListener();
    private static final LimitedLegendsConfig config = ConfigLoader.loadConfig();
    @NotNull
    private static final Logger LOGGER = LimitedLegends.Companion.getLOGGER();
    @NotNull
    private static final Map<String, Integer> specificLimits;

    private LegendaryListener() {
    }

    public final void register() {
        CobblemonEvents.POKEMON_CATCH_RATE.subscribe(Priority.HIGH, (Function1)new Function1<PokemonCatchRateEvent, Unit>((Object)this){

            public final void invoke(@NotNull PokemonCatchRateEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((LegendaryListener)this.receiver).onPokemonCatchRate(p0);
            }
        });
        CobblemonEvents.POKE_BALL_CAPTURE_CALCULATED.subscribe(Priority.HIGH, (Function1)new Function1<PokeBallCaptureCalculatedEvent, Unit>((Object)this){

            public final void invoke(@NotNull PokeBallCaptureCalculatedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((LegendaryListener)this.receiver).onPokemonCapture(p0);
            }
        });
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.HIGH, (Function1)new Function1<PokemonCapturedEvent, Unit>((Object)this){

            public final void invoke(@NotNull PokemonCapturedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((LegendaryListener)this.receiver).onPokemonCaptured(p0);
            }
        });
        CobblemonEvents.POKEMON_RELEASED_EVENT_POST.subscribe(Priority.HIGH, (Function1)new Function1<ReleasePokemonEvent, Unit>((Object)this){

            public final void invoke(@NotNull ReleasePokemonEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((LegendaryListener)this.receiver).onPokemonRelease(p0);
            }
        });
        CobblemonEvents.POKEMON_ENTITY_SPAWN.subscribe(Priority.HIGH, new Function1<SpawnEvent<?>, Unit>(this){

            public final void invoke(@NotNull SpawnEvent<?> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((LegendaryListener)this.receiver).onPokemonSpawn(p0);
            }
        });
        CobblemonEvents.TRADE_COMPLETED.subscribe(Priority.HIGH, (Function1)new Function1<TradeCompletedEvent, Unit>((Object)this){

            public final void invoke(@NotNull TradeCompletedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((LegendaryListener)this.receiver).onTrade(p0);
            }
        });
    }

    public final void onPokemonCapture(@NotNull PokeBallCaptureCalculatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity playerEntity = event.getThrower();
        if (!(playerEntity instanceof ServerPlayer)) {
            return;
        }
        String string = ((ServerPlayer)playerEntity).getUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String playerUUID = string;
        Level level = playerEntity.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel serverLevel2 = serverLevel;
        PokemonEntity pokeEntity = event.getPokemonEntity();
        String string2 = pokeEntity.getPokemon().getSpecies().getResourceIdentifier().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String speciesName = string2;
        String displayName = pokeEntity.getPokemon().getSpecies().getName();
        SavedCaptureData savedCaptureData = SavedCaptureData.Companion.get(serverLevel2);
        SavedPlayerCaptureData savedPlayerCaptureData = SavedPlayerCaptureData.Companion.get(serverLevel2);
        double hpRatio = (double)pokeEntity.getPokemon().getCurrentHealth() / (double)pokeEntity.getPokemon().getMaxHealth();
        float hpLimit = RangesKt.coerceIn((float)LegendaryListener.config.MinCaptureHPThreshold, (float)0.01f, (float)1.0f);
        boolean isSubjugated = (double)hpLimit >= hpRatio;
        PokeBall thrownBall = event.getPokeBallEntity().getPokeBall();
        if (LegendaryListener.config.RequireSubjugationForAll && !isSubjugated) {
            boolean isAllowedBall;
            boolean bl = isAllowedBall = LegendaryListener.config.AllowMasterBall && Intrinsics.areEqual((Object)thrownBall, (Object)PokeBalls.INSTANCE.getMASTER_BALL()) || LegendaryListener.config.AllowQuickBall && Intrinsics.areEqual((Object)thrownBall, (Object)PokeBalls.INSTANCE.getQUICK_BALL()) || LegendaryListener.config.AllowOriginBall && Intrinsics.areEqual((Object)thrownBall, (Object)PokeBalls.INSTANCE.getANCIENT_ORIGIN_BALL());
            if (!isAllowedBall) {
                event.setCaptureResult(new CaptureContext(1, false, false));
                playerEntity.sendSystemMessage((Component)Component.literal((String)("\u00a76" + displayName + "\u00a7f is still too strong. Fight it!")));
                return;
            }
        }
        if (LegendaryListener.config.ApplyEverythingToAll || LegendaryListener.config.LimitedPokemon.contains(speciesName) || specificLimits.keySet().contains(speciesName)) {
            boolean reachedMaxCopies;
            Integer n = specificLimits.get(speciesName);
            int speciesLimit = n != null ? n : LegendaryListener.config.GlobalLimitPerSpecies;
            boolean reachedGlobalLimit = LegendaryListener.config.SetGlobalLimits && savedCaptureData.hasReachedLimit(speciesName, speciesLimit);
            boolean reachedPlayerLimit = LegendaryListener.config.SetLimitsPerPlayer && savedPlayerCaptureData.getTotalCount(playerUUID) >= LegendaryListener.config.MaxLimitedPerPlayer;
            int playerSpeciesCount = savedPlayerCaptureData.getCount(playerUUID, speciesName);
            boolean bl = reachedMaxCopies = LegendaryListener.config.SetCopiesLimit && playerSpeciesCount >= LegendaryListener.config.MaxCopiesPerPlayer;
            if (reachedGlobalLimit || reachedPlayerLimit || reachedMaxCopies || LegendaryListener.config.RequireSubjugation && !isSubjugated) {
                event.setCaptureResult(new CaptureContext(1, false, false));
                String message = speciesLimit == 1 ? "\u00a76" + displayName + "\u00a7f can only be caught \u00a76once\u00a7f." : (reachedMaxCopies && LegendaryListener.config.MaxCopiesPerPlayer == 1 ? "\u00a76" + displayName + "\u00a7f can only be caught \u00a76once\u00a7f per trainer." : (reachedMaxCopies ? "\u00a76" + displayName + "\u00a7f can only be caught \u00a76" + LegendaryListener.config.MaxCopiesPerPlayer + "\u00a7f times per trainer." : (reachedPlayerLimit ? "You can only capture up to \u00a76" + LegendaryListener.config.MaxLimitedPerPlayer + "\u00a7f unique Pok\u00e9mon\u00a7f." : (LegendaryListener.config.RequireSubjugation && !isSubjugated ? "\u00a76" + displayName + "\u00a7f is still too strong. Fight it!" : "\u00a76" + displayName + "\u00a7f can only be caught \u00a76" + speciesLimit + "\u00a7f times in total."))));
                playerEntity.sendSystemMessage((Component)Component.literal((String)message));
                PokeBallItem pokeBallItem = thrownBall.item();
                ItemStack itemStack = new ItemStack((ItemLike)pokeBallItem);
                if (!((ServerPlayer)playerEntity).getInventory().add(itemStack)) {
                    ((ServerPlayer)playerEntity).drop(itemStack, false);
                }
                return;
            }
        }
    }

    public final void onPokemonCatchRate(@NotNull PokemonCatchRateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!LegendaryListener.config.RequireSubjugation) {
            return;
        }
        float bonusCatchRate = LegendaryListener.config.BonusCatchRate;
        if (bonusCatchRate <= 0.0f) {
            return;
        }
        PokemonEntity pokeEntity = event.getPokemonEntity();
        String string = pokeEntity.getPokemon().getSpecies().getResourceIdentifier().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String speciesName = string;
        if (LegendaryListener.config.ApplyEverythingToAll || LegendaryListener.config.LimitedPokemon.contains(speciesName) || specificLimits.keySet().contains(speciesName)) {
            event.setCatchRate(event.getCatchRate() + bonusCatchRate);
        }
    }

    public final void onPokemonCaptured(@NotNull PokemonCapturedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ServerPlayer playerEntity = event.getPlayer();
        String string = playerEntity.getUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String playerUUID = string;
        Level level = playerEntity.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel serverLevel2 = serverLevel;
        Pokemon pokeEntity = event.getPokemon();
        String string2 = pokeEntity.getSpecies().getResourceIdentifier().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String speciesName = string2;
        String displayName = pokeEntity.getSpecies().getName();
        SavedCaptureData savedCaptureData = SavedCaptureData.Companion.get(serverLevel2);
        SavedPlayerCaptureData savedPlayerCaptureData = SavedPlayerCaptureData.Companion.get(serverLevel2);
        if (LegendaryListener.config.ApplyEverythingToAll || LegendaryListener.config.LimitedPokemon.contains(speciesName) || specificLimits.keySet().contains(speciesName)) {
            savedCaptureData.increment(speciesName);
            savedPlayerCaptureData.increment(playerUUID, speciesName);
            if (LegendaryListener.config.EnableCaptureMessage) {
                List list = serverLevel2.players();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ServerPlayer player = (ServerPlayer)element$iv;
                    boolean bl = false;
                    player.sendSystemMessage((Component)Component.literal((String)("\u00a76" + displayName + "\u00a7f was caught by \u00a72" + playerEntity.getName().getString() + "\u00a7f!")));
                }
            }
            LOGGER.info(playerEntity.getName().getString() + " caught " + speciesName + ". Global count: " + savedCaptureData.getCount(speciesName));
        }
    }

    public final void onPokemonRelease(@NotNull ReleasePokemonEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ServerPlayer playerEntity = event.getPlayer();
        String string = playerEntity.getUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String playerUUID = string;
        Level level = playerEntity.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel serverLevel2 = serverLevel;
        Pokemon pokeEntity = event.getPokemon();
        String string2 = pokeEntity.getSpecies().getResourceIdentifier().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String speciesName = string2;
        String displayName = pokeEntity.getSpecies().getName();
        SavedCaptureData savedCaptureData = SavedCaptureData.Companion.get(serverLevel2);
        SavedPlayerCaptureData savedPlayerCaptureData = SavedPlayerCaptureData.Companion.get(serverLevel2);
        if (LegendaryListener.config.ApplyEverythingToAll || LegendaryListener.config.LimitedPokemon.contains(speciesName) || specificLimits.keySet().contains(speciesName)) {
            savedCaptureData.decrement(speciesName);
            savedPlayerCaptureData.decrement(playerUUID, speciesName);
            if (LegendaryListener.config.EnableReleaseMessage) {
                List list = serverLevel2.players();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ServerPlayer player = (ServerPlayer)element$iv;
                    boolean bl = false;
                    player.sendSystemMessage((Component)Component.literal((String)("\u00a76" + displayName + "\u00a7f was released by \u00a72" + playerEntity.getName().getString() + "\u00a7f!")));
                }
            }
            LOGGER.info(playerEntity.getName().getString() + " released " + speciesName + ". Global count: " + savedCaptureData.getCount(speciesName));
        }
    }

    public final void onTrade(@NotNull TradeCompletedEvent event) {
        block11: {
            SavedPlayerCaptureData savedPlayerCaptureData;
            String speciesTradedTo2;
            String speciesTradedTo1;
            String uuid2;
            String uuid1;
            ServerPlayer player2;
            ServerPlayer player1;
            block10: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!LimitedLegends.Companion.getConfig().SetLimitsPerPlayer) {
                    return;
                }
                MinecraftServer minecraftServer = DistributionUtilsKt.server();
                if (minecraftServer == null) {
                    return;
                }
                MinecraftServer serverInstance = minecraftServer;
                ServerPlayer serverPlayer = serverInstance.getPlayerList().getPlayer(event.getTradeParticipant1().getUuid());
                if (serverPlayer == null) {
                    return;
                }
                player1 = serverPlayer;
                ServerPlayer serverPlayer2 = serverInstance.getPlayerList().getPlayer(event.getTradeParticipant2().getUuid());
                if (serverPlayer2 == null) {
                    return;
                }
                player2 = serverPlayer2;
                String string = player1.getUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                uuid1 = string;
                String string2 = player2.getUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                uuid2 = string2;
                Pokemon tradedTo1 = event.getTradeParticipant1Pokemon();
                Pokemon tradedTo2 = event.getTradeParticipant2Pokemon();
                String string3 = tradedTo1.getSpecies().getResourceIdentifier().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                speciesTradedTo1 = string3;
                String string4 = tradedTo2.getSpecies().getResourceIdentifier().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                speciesTradedTo2 = string4;
                Level level = player1.level();
                ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
                if (serverLevel == null) {
                    return;
                }
                ServerLevel serverLevel2 = serverLevel;
                savedPlayerCaptureData = SavedPlayerCaptureData.Companion.get(serverLevel2);
                boolean cancel1 = savedPlayerCaptureData.wouldExceedLimit(uuid1, speciesTradedTo1, speciesTradedTo2);
                boolean cancel2 = savedPlayerCaptureData.wouldExceedLimit(uuid2, speciesTradedTo2, speciesTradedTo1);
                boolean cancelcopies1 = savedPlayerCaptureData.wouldExceedCopiesLimit(uuid1, speciesTradedTo1, speciesTradedTo2);
                boolean cancelcopies2 = savedPlayerCaptureData.wouldExceedCopiesLimit(uuid2, speciesTradedTo2, speciesTradedTo1);
                if (!cancel1 && !cancel2 && !cancelcopies1 && !cancelcopies2) break block10;
                PartyStore party1 = event.getTradeParticipant1().getParty();
                PartyStore party2 = event.getTradeParticipant2().getParty();
                party1.remove(tradedTo1);
                party2.remove(tradedTo2);
                party1.add(tradedTo2);
                party2.add(tradedTo1);
                player1.closeContainer();
                player2.closeContainer();
                UUID uUID = player1.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                ActiveTrade activeTrade = TradeManager.INSTANCE.getActiveTrade(uUID);
                if (activeTrade != null) {
                    activeTrade.cancelTrade();
                }
                Pair pair = cancelcopies1 && cancelcopies2 ? new Pair((Object)"\u00a7cTrade cancelled\u00a7f: Both of you cannot have more copies of the same Pok\u00e9mon!", (Object)"\u00a7cTrade cancelled\u00a7f: Both of you cannot have more copies of the same Pok\u00e9mon!") : (cancelcopies1 ? new Pair((Object)"\u00a7cTrade cancelled\u00a7f: You cannot have more copies of the same Pok\u00e9mon!", (Object)"\u00a7cTrade cancelled\u00a7f: The other trainer cannot have more copies of the same Pok\u00e9mon!") : (cancelcopies2 ? new Pair((Object)"\u00a7cTrade cancelled\u00a7f: The other trainer cannot have more copies of the same Pok\u00e9mon!", (Object)"\u00a7cTrade cancelled\u00a7f: You cannot have more copies of the same Pok\u00e9mon!") : (cancel1 && cancel2 ? new Pair((Object)"\u00a7cTrade cancelled\u00a7f: Both of you cannot have more unique Pok\u00e9mon!", (Object)"\u00a7cTrade cancelled\u00a7f: Both of you cannot have more unique Pok\u00e9mon!") : (cancel1 ? new Pair((Object)"\u00a7cTrade cancelled\u00a7f: You cannot have more unique Pok\u00e9mon!", (Object)"\u00a7cTrade cancelled\u00a7f: The other trainer cannot have more unique Pok\u00e9mon!") : new Pair((Object)"\u00a7cTrade cancelled\u00a7f: The other trainer cannot have more unique Pok\u00e9mon!", (Object)"\u00a7cTrade cancelled\u00a7f: You cannot have more unique Pok\u00e9mon!")))));
                String message1 = (String)pair.component1();
                String message2 = (String)pair.component2();
                if (((CharSequence)message1).length() > 0) {
                    player1.sendSystemMessage((Component)Component.literal((String)message1));
                }
                if (((CharSequence)message2).length() > 0) {
                    player2.sendSystemMessage((Component)Component.literal((String)message2));
                }
                LOGGER.info("Trade reversed between " + player1.getName().getString() + " and " + player2.getName().getString() + " due to limit violations.");
                break block11;
            }
            if (LegendaryListener.config.ApplyEverythingToAll || LegendaryListener.config.LimitedPokemon.contains(speciesTradedTo1) || specificLimits.keySet().contains(speciesTradedTo1)) {
                savedPlayerCaptureData.increment(uuid1, speciesTradedTo1);
                savedPlayerCaptureData.decrement(uuid2, speciesTradedTo1);
            }
            if (LegendaryListener.config.ApplyEverythingToAll || LegendaryListener.config.LimitedPokemon.contains(speciesTradedTo2) || specificLimits.keySet().contains(speciesTradedTo2)) {
                savedPlayerCaptureData.increment(uuid2, speciesTradedTo2);
                savedPlayerCaptureData.decrement(uuid1, speciesTradedTo2);
            }
            player1.closeContainer();
            player2.closeContainer();
            UUID uUID = player1.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            ActiveTrade activeTrade = TradeManager.INSTANCE.getActiveTrade(uUID);
            if (activeTrade == null) break block11;
            activeTrade.cancelTrade();
        }
    }

    public final void onPokemonSpawn(@NotNull SpawnEvent<?> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (LegendaryListener.config.DisableSpawning && LegendaryListener.config.SetGlobalLimits) {
            Entity entity = event.getEntity();
            if (!(entity instanceof PokemonEntity)) {
                return;
            }
            Level level = entity.level();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            SavedCaptureData savedCaptureData = SavedCaptureData.Companion.get((ServerLevel)level);
            String string = ((PokemonEntity)entity).getPokemon().getSpecies().getResourceIdentifier().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String speciesName = string;
            if (LegendaryListener.config.ApplyEverythingToAll || LegendaryListener.config.LimitedPokemon.contains(speciesName) || specificLimits.keySet().contains(speciesName)) {
                Integer n = specificLimits.get(speciesName);
                int maxCaptures = n != null ? n : LegendaryListener.config.GlobalLimitPerSpecies;
                int currentCaptures = savedCaptureData.getCount(speciesName);
                LimitedLegends.Companion.getLOGGER().info(speciesName + " spawned!");
                if (currentCaptures >= maxCaptures) {
                    event.cancel();
                    LimitedLegends.Companion.getLOGGER().info("Canceled spawn of " + speciesName + ". (limit: " + maxCaptures + ")");
                } else if (LegendaryListener.config.EnableSpawnMessage) {
                    Species species = PokemonSpecies.INSTANCE.getByIdentifier(((PokemonEntity)entity).getPokemon().getSpecies().getResourceIdentifier());
                    Object object = species;
                    if (object == null || (object = object.getName()) == null) {
                        object = speciesName;
                    }
                    Object displayName = object;
                    MutableComponent message = Component.literal((String)("\u00a7fA wild \u00a76" + (String)displayName + "\u00a7f has appeared!"));
                    List list = ((ServerLevel)level).getServer().getPlayerList().getPlayers();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ServerPlayer player = (ServerPlayer)element$iv;
                        boolean bl = false;
                        player.sendSystemMessage((Component)message);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Integer> getSpecificLimitMap(@NotNull LimitedLegendsConfig $this$getSpecificLimitMap) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getSpecificLimitMap, (String)"<this>");
        List<String> list = $this$getSpecificLimitMap.SpecificLimits;
        Intrinsics.checkNotNullExpressionValue(list, (String)"SpecificLimits");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            void $this$mapTo$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String entry = (String)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)entry);
            String[] stringArray = new String[]{":"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)entry, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            List parts = (List)destination$iv$iv2;
            if (parts.size() == 3) {
                Integer limit;
                String species = parts.get(0) + ":" + parts.get(1);
                Integer n = limit = StringsKt.toIntOrNull((String)((String)parts.get(2)));
                pair = n != null ? TuplesKt.to((Object)species, (Object)n) : null;
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    static {
        LimitedLegendsConfig limitedLegendsConfig = config;
        Intrinsics.checkNotNullExpressionValue((Object)limitedLegendsConfig, (String)"config");
        specificLimits = INSTANCE.getSpecificLimitMap(limitedLegendsConfig);
    }
}

