/*
 * Decompiled with CFR 0.152.
 */
package com.github.slaxlax.limitedlegends;

import com.github.slaxlax.limitedlegends.LimitedLegends;
import com.github.slaxlax.limitedlegends.LimitedLegendsConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0005\u0018\u0000 22\u00020\u0001:\u00012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\tJ\r\u0010\u001a\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001a\u0010\u0003J\u001f\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010#\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b#\u0010$J)\u0010(\u001a\u00020'2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010%\u001a\u0004\u0018\u00010\u00042\b\u0010&\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b(\u0010)J)\u0010*\u001a\u00020'2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010%\u001a\u0004\u0018\u00010\u00042\b\u0010&\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b*\u0010)R\u0014\u0010,\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R,\u0010/\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100.0.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R \u00101\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00100\u00a8\u00063"}, d2={"Lcom/github/slaxlax/limitedlegends/SavedPlayerCaptureData;", "Lnet/minecraft/world/level/saveddata/SavedData;", "<init>", "()V", "", "playerUUID", "name", "", "decrement", "(Ljava/lang/String;Ljava/lang/String;)V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "Ljava/util/UUID;", "getAllTrainers", "(Lnet/minecraft/server/MinecraftServer;)Ljava/util/Map;", "", "getCount", "(Ljava/lang/String;Ljava/lang/String;)I", "getTotalCount", "(Ljava/lang/String;)I", "species", "", "getTrainers", "(Ljava/lang/String;Lnet/minecraft/server/MinecraftServer;)Ljava/util/List;", "increment", "reset", "Lnet/minecraft/nbt/CompoundTag;", "tag", "Lnet/minecraft/core/HolderLookup$Provider;", "registries", "save", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;", "Lnet/minecraft/server/level/ServerPlayer;", "player", "savePlayerName", "(Lnet/minecraft/server/level/ServerPlayer;)V", "speciesToAdd", "speciesToRemove", "", "wouldExceedCopiesLimit", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", "wouldExceedLimit", "Lcom/github/slaxlax/limitedlegends/LimitedLegendsConfig;", "config", "Lcom/github/slaxlax/limitedlegends/LimitedLegendsConfig;", "", "playerCaptureCounts", "Ljava/util/Map;", "playerData", "Companion", "LimitedLegends-neoforge"})
@SourceDebugExtension(value={"SMAP\nSavedPlayerCaptureData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SavedPlayerCaptureData.kt\ncom/github/slaxlax/limitedlegends/SavedPlayerCaptureData\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n535#2:182\n520#2,6:183\n381#2,7:193\n1557#3:189\n1628#3,3:190\n1611#3,9:200\n1863#3:209\n1864#3:211\n1620#3:212\n1#4:210\n*S KotlinDebug\n*F\n+ 1 SavedPlayerCaptureData.kt\ncom/github/slaxlax/limitedlegends/SavedPlayerCaptureData\n*L\n91#1:182\n91#1:183,6\n118#1:193,7\n94#1:189\n94#1:190,3\n140#1:200,9\n140#1:209\n140#1:211\n140#1:212\n140#1:210\n*E\n"})
public final class SavedPlayerCaptureData
extends SavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Map<String, Integer>> playerCaptureCounts = new LinkedHashMap();
    @NotNull
    private final Map<UUID, String> playerData = new LinkedHashMap();
    @NotNull
    private final LimitedLegendsConfig config = LimitedLegends.Companion.getConfig();
    @NotNull
    private static final String DATA_NAME = "limitedlegends_playerdata";
    @JvmField
    @NotNull
    public static final SavedData.Factory<SavedPlayerCaptureData> FACTORY = new SavedData.Factory(SavedPlayerCaptureData::FACTORY$lambda$4, SavedPlayerCaptureData::FACTORY$lambda$6);

    private SavedPlayerCaptureData() {
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag perPlayerTag = new CompoundTag();
        for (Map.Entry<String, Map<String, Integer>> object : this.playerCaptureCounts.entrySet()) {
            String string = object.getKey();
            Map<String, Integer> playerMap = object.getValue();
            CompoundTag playerTag = new CompoundTag();
            for (Map.Entry<String, Integer> entry : playerMap.entrySet()) {
                String name = entry.getKey();
                int count = ((Number)entry.getValue()).intValue();
                playerTag.putInt(name, count);
            }
            perPlayerTag.put(string, (Tag)playerTag);
        }
        tag.put("CountsPerPlayer", (Tag)perPlayerTag);
        CompoundTag playerDataTag = new CompoundTag();
        for (Map.Entry<UUID, String> entry : this.playerData.entrySet()) {
            UUID uuid = entry.getKey();
            String name = entry.getValue();
            playerDataTag.putString(uuid.toString(), name);
        }
        tag.put("PlayerData", (Tag)playerDataTag);
        return tag;
    }

    public final int getCount(@NotNull String playerUUID, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, Integer> map = this.playerCaptureCounts.get(playerUUID);
        return map != null && (map = map.get(name)) != null ? (Integer)((Object)map) : 0;
    }

    public final int getTotalCount(@NotNull String playerUUID) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        Map<String, Integer> map = this.playerCaptureCounts.get(playerUUID);
        return map != null && (map = map.values()) != null ? CollectionsKt.sumOfInt((Iterable)((Iterable)((Object)map))) : 0;
    }

    public final void savePlayerName(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Map<UUID, String> map = this.playerData;
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        UUID uUID2 = uUID;
        String string = player.getScoreboardName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScoreboardName(...)");
        String string2 = string;
        map.put(uUID2, string2);
        this.setDirty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getTrainers(@NotNull String species, @NotNull MinecraftServer server) {
        void $this$mapTo$iv$iv;
        Object object;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)species, (String)"species");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Map<String, Map<String, Integer>> $this$filter$iv = this.playerCaptureCounts;
        boolean $i$f$filter = false;
        Map<String, Map<String, Integer>> map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            object = element$iv$iv;
            boolean bl = false;
            Map speciesMap = (Map)object.getValue();
            Integer count = (Integer)speciesMap.get(species);
            if (!(count != null && count > 0)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Iterable $this$map$iv = destination$iv$iv.keySet();
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
            void uuid;
            object = (String)((Object)item$iv$iv);
            Object object2 = destination$iv$iv;
            boolean bl = false;
            Object object3 = server.getPlayerList().getPlayer(UUID.fromString((String)uuid));
            if ((object3 == null || (object3 = object3.getScoreboardName()) == null) && (object3 = this.playerData.get(UUID.fromString((String)uuid))) == null) {
                object3 = "Unknown";
            }
            Object name = object3;
            object2.add(name);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Map<UUID, String> getAllTrainers(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Map merged = new LinkedHashMap();
        for (Map.Entry<UUID, String> entry : this.playerData.entrySet()) {
            UUID uuid = entry.getKey();
            String storedName = entry.getValue();
            ServerPlayer serverPlayer = server.getPlayerList().getPlayer(uuid);
            String onlineName = serverPlayer != null ? serverPlayer.getScoreboardName() : null;
            String string = onlineName;
            if (string == null) {
                string = storedName;
            }
            merged.put(uuid, string);
        }
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            merged.putIfAbsent(player.getUUID(), player.getScoreboardName());
        }
        return merged;
    }

    public final void increment(@NotNull String playerUUID, @NotNull String name) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, Map<String, Integer>> $this$getOrPut$iv = this.playerCaptureCounts;
        boolean $i$f$getOrPut = false;
        Map value$iv = $this$getOrPut$iv.get(playerUUID);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(playerUUID, answer$iv);
            map = answer$iv;
        } else {
            map = value$iv;
        }
        Map playerMap = map;
        playerMap.put(name, ((Number)playerMap.getOrDefault(name, 0)).intValue() + 1);
        this.setDirty();
    }

    public final void decrement(@NotNull String playerUUID, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, Integer> map = this.playerCaptureCounts.get(playerUUID);
        if (map == null) {
            return;
        }
        Map<String, Integer> playerMap = map;
        int currentCount = ((Number)playerMap.getOrDefault(name, 0)).intValue();
        if (currentCount > 0) {
            playerMap.put(name, currentCount - 1);
            this.setDirty();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean wouldExceedLimit(@NotNull String playerUUID, @Nullable String speciesToAdd, @Nullable String speciesToRemove) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        int captureLimit = this.config.MaxLimitedPerPlayer;
        List<String> list = this.config.SpecificLimits;
        Intrinsics.checkNotNullExpressionValue(list, (String)"SpecificLimits");
        Iterable iterable = list;
        boolean $i$f$mapNotNull = false;
        void var8_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String entry = (String)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)entry);
            String[] stringArray = new String[]{":"};
            List parts = StringsKt.split$default((CharSequence)entry, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if ((parts.size() >= 2 ? parts.get(0) + ":" + parts.get(1) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set specificLimits = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List<String> list2 = this.config.LimitedPokemon;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"LimitedPokemon");
        Set allLimitedSpecies = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)list2, (Iterable)specificLimits));
        int currentCount = this.getTotalCount(playerUUID);
        if (speciesToAdd != null && this.config.ApplyEverythingToAll || speciesToAdd != null && allLimitedSpecies.contains(speciesToAdd)) {
            ++currentCount;
        }
        if (speciesToRemove != null && this.config.ApplyEverythingToAll || speciesToRemove != null && allLimitedSpecies.contains(speciesToRemove)) {
            --currentCount;
        }
        return currentCount > captureLimit;
    }

    public final boolean wouldExceedCopiesLimit(@NotNull String playerUUID, @Nullable String speciesToAdd, @Nullable String speciesToRemove) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        if (!this.config.SetCopiesLimit) {
            return false;
        }
        if (speciesToAdd == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)speciesToAdd, (Object)speciesToRemove)) {
            return false;
        }
        int currentCount = this.getCount(playerUUID, speciesToAdd);
        return currentCount + 1 > this.config.MaxCopiesPerPlayer;
    }

    public final void reset() {
        this.playerCaptureCounts.clear();
        this.setDirty();
    }

    private static final SavedPlayerCaptureData FACTORY$lambda$4() {
        return new SavedPlayerCaptureData();
    }

    private static final SavedPlayerCaptureData FACTORY$lambda$6(CompoundTag nbt, HolderLookup.Provider provider) {
        Iterator iterator;
        SavedPlayerCaptureData savedPlayerCaptureData;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"<anonymous parameter 1>");
        SavedPlayerCaptureData $this$FACTORY_u24lambda_u246_u24lambda_u245 = savedPlayerCaptureData = new SavedPlayerCaptureData();
        boolean bl = false;
        if (nbt.contains("CountsPerPlayer", 10)) {
            CompoundTag perPlayerTag = nbt.getCompound("CountsPerPlayer");
            for (String uuid : perPlayerTag.getAllKeys()) {
                CompoundTag playerTag = perPlayerTag.getCompound(uuid);
                Map speciesMap = new LinkedHashMap();
                iterator = playerTag.getAllKeys().iterator();
                while (iterator.hasNext()) {
                    String name = (String)iterator.next();
                    Intrinsics.checkNotNull((Object)name);
                    speciesMap.put(name, playerTag.getInt(name));
                }
                Map<String, Map<String, Integer>> map = $this$FACTORY_u24lambda_u246_u24lambda_u245.playerCaptureCounts;
                Intrinsics.checkNotNull((Object)uuid);
                map.put(uuid, speciesMap);
            }
        }
        if (nbt.contains("PlayerData", 10)) {
            CompoundTag playerDataTag = nbt.getCompound("PlayerData");
            for (String uuid : playerDataTag.getAllKeys()) {
                String name = playerDataTag.getString(uuid);
                Map<UUID, String> map = $this$FACTORY_u24lambda_u246_u24lambda_u245.playerData;
                Intrinsics.checkNotNullExpressionValue((Object)UUID.fromString(uuid), (String)"fromString(...)");
                Intrinsics.checkNotNull((Object)name);
                String string = name;
                map.put((UUID)((Object)iterator), string);
            }
        }
        return savedPlayerCaptureData;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\f8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/github/slaxlax/limitedlegends/SavedPlayerCaptureData$Companion;", "", "<init>", "()V", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lcom/github/slaxlax/limitedlegends/SavedPlayerCaptureData;", "get", "(Lnet/minecraft/server/level/ServerLevel;)Lcom/github/slaxlax/limitedlegends/SavedPlayerCaptureData;", "", "DATA_NAME", "Ljava/lang/String;", "Lnet/minecraft/world/level/saveddata/SavedData$Factory;", "FACTORY", "Lnet/minecraft/world/level/saveddata/SavedData$Factory;", "LimitedLegends-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SavedPlayerCaptureData get(@Nullable ServerLevel level) {
            ServerLevel serverLevel = level;
            if (serverLevel == null || (serverLevel = serverLevel.getServer()) == null || (serverLevel = serverLevel.getLevel(Level.OVERWORLD)) == null) {
                throw new IllegalStateException("Overworld not loaded!".toString());
            }
            ServerLevel overworld = serverLevel;
            SavedData savedData = overworld.getDataStorage().computeIfAbsent(FACTORY, SavedPlayerCaptureData.DATA_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)savedData, (String)"computeIfAbsent(...)");
            return (SavedPlayerCaptureData)savedData;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

