/*
 * Decompiled with CFR 0.152.
 */
package com.bay4lly.photochat.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ImageScreen
extends class_437 {
    private final class_2960 textureId;
    private final int originalWidth;
    private final int originalHeight;
    private final class_1011 imageRef;

    public ImageScreen(class_1011 image) {
        super((class_2561)class_2561.method_43471((String)"text.photochat.sent_photo"));
        class_1011 freshImage;
        try {
            byte[] raw = image.method_24036();
            freshImage = class_1011.method_4309((InputStream)new ByteArrayInputStream(raw));
        }
        catch (Exception e) {
            freshImage = image;
        }
        class_1043 tex = new class_1043(freshImage);
        this.textureId = class_310.method_1551().method_1531().method_4617("photochat", tex);
        this.originalWidth = freshImage.method_4307();
        this.originalHeight = freshImage.method_4323();
        this.imageRef = freshImage;
    }

    protected void method_25426() {
        super.method_25426();
        int buttonWidth = 20;
        int buttonHeight = 20;
        int x = (this.field_22789 - buttonWidth) / 2;
        int y = this.field_22790 - buttonHeight - 10;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u2b07"), button -> this.saveImage()).method_46434(x, y, buttonWidth, buttonHeight).method_46431());
    }

    private void saveImage() {
        try {
            File mcFolder = class_310.method_1551().field_1697;
            File downloadFolder = new File(mcFolder, "photochat_downloads");
            if (!downloadFolder.exists()) {
                downloadFolder.mkdirs();
            }
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss"));
            File outFile = new File(downloadFolder, "photo_" + timestamp + ".png");
            this.imageRef.method_4325(outFile);
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43469((String)"text.photochat.download_success", (Object[])new Object[]{outFile.getAbsolutePath()}), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"text.photochat.download_failed"), false);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        int maxWidth = this.field_22789 - 80;
        int maxHeight = this.field_22790 - 80;
        float aspectRatio = (float)this.originalWidth / (float)this.originalHeight;
        int newWidth = maxWidth;
        int newHeight = (int)((float)newWidth / aspectRatio);
        if (newHeight > maxHeight) {
            newHeight = maxHeight;
            newWidth = (int)((float)newHeight * aspectRatio);
        }
        int x = (this.field_22789 - newWidth) / 2;
        int y = (this.field_22790 - newHeight) / 2;
        RenderSystem.enableBlend();
        context.method_25293(this.textureId, x, y, newWidth, newHeight, 0.0f, 0.0f, this.originalWidth, this.originalHeight, this.originalWidth, this.originalHeight);
        RenderSystem.disableBlend();
        context.method_27534(this.field_22793, this.method_25440(), this.field_22789 / 2, 20, 0xFFFFFF);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25419() {
        class_310.method_1551().method_1531().method_4615(this.textureId);
        if (this.imageRef != null) {
            this.imageRef.close();
        }
        super.method_25419();
    }

    public boolean method_25421() {
        return false;
    }
}

