/*
 * Decompiled with CFR 0.152.
 */
package com.bay4lly.photochat.client;

import com.bay4lly.photochat.PhotoChat;
import com.bay4lly.photochat.network.NetworkHandler;
import com.bay4lly.photochat.util.Localization;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class PhotoUploadTask
implements Runnable {
    private static final int CHUNK_SIZE = 30720;
    private final byte[] fullImageData;
    private final String fileName;

    public PhotoUploadTask(byte[] fullImageData, String fileName) {
        this.fullImageData = fullImageData;
        this.fileName = fileName;
    }

    @Override
    public void run() {
        try {
            UUID photoId = UUID.randomUUID();
            int totalChunks = (int)Math.ceil((double)this.fullImageData.length / 30720.0);
            class_2540 startBuf = new class_2540(Unpooled.buffer());
            startBuf.method_10797(photoId);
            startBuf.writeInt(totalChunks);
            ClientPlayNetworking.send((class_2960)NetworkHandler.START_UPLOAD, (class_2540)startBuf);
            PhotoChat.LOGGER.info(Localization.translate("log.upload.starting", photoId, totalChunks));
            for (int i = 0; i < totalChunks; ++i) {
                int start = i * 30720;
                int length = Math.min(this.fullImageData.length - start, 30720);
                byte[] chunkData = new byte[length];
                System.arraycopy(this.fullImageData, start, chunkData, 0, length);
                class_2540 chunkBuf = new class_2540(Unpooled.buffer());
                chunkBuf.method_10797(photoId);
                chunkBuf.writeInt(i);
                chunkBuf.method_10813(chunkData);
                ClientPlayNetworking.send((class_2960)NetworkHandler.UPLOAD_CHUNK, (class_2540)chunkBuf);
                PhotoChat.LOGGER.info(Localization.translate("log.upload.sending_chunk", i + 1, totalChunks, photoId));
            }
            class_2540 finishBuf = new class_2540(Unpooled.buffer());
            finishBuf.method_10797(photoId);
            ClientPlayNetworking.send((class_2960)NetworkHandler.FINISH_UPLOAD, (class_2540)finishBuf);
            PhotoChat.LOGGER.info(Localization.translate("log.upload.finished", photoId));
        }
        catch (Exception e) {
            PhotoChat.LOGGER.error(Localization.translate("log.upload.error", new Object[0]), (Throwable)e);
        }
    }
}

