/*
 * Decompiled with CFR 0.152.
 */
package com.bay4lly.photochat.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;

@Environment(value=EnvType.CLIENT)
public class ClientImageManager {
    private static final Map<String, ImageData> IMAGE_CACHE = new ConcurrentHashMap<String, ImageData>();

    public static void putImage(String imageId, class_1011 image) {
        if (imageId != null && image != null) {
            IMAGE_CACHE.put(imageId, new ImageData(image));
        }
    }

    public static void putGif(String imageId, byte[] gifData) {
        if (imageId != null && gifData != null) {
            IMAGE_CACHE.put(imageId, new ImageData(gifData));
        }
    }

    public static ImageData getImageData(String imageId) {
        return IMAGE_CACHE.get(imageId);
    }

    public static class_1011 getImage(String imageId) {
        ImageData data = IMAGE_CACHE.get(imageId);
        return data != null && data.isStatic() ? data.getStaticImage() : null;
    }

    public static byte[] getGifData(String imageId) {
        ImageData data = IMAGE_CACHE.get(imageId);
        return data != null && data.isGif() ? data.getGifData() : null;
    }

    public static void removeImage(String imageId) {
        ImageData data = IMAGE_CACHE.remove(imageId);
        if (data != null) {
            data.close();
        }
    }

    public static void clear() {
        for (ImageData data : IMAGE_CACHE.values()) {
            data.close();
        }
        IMAGE_CACHE.clear();
    }

    @Environment(value=EnvType.CLIENT)
    public static class ImageData {
        private final class_1011 staticImage;
        private final byte[] gifData;

        public ImageData(class_1011 staticImage) {
            this.staticImage = staticImage;
            this.gifData = null;
        }

        public ImageData(byte[] gifData) {
            this.staticImage = null;
            this.gifData = gifData;
        }

        public boolean isStatic() {
            return this.staticImage != null;
        }

        public boolean isGif() {
            return this.gifData != null;
        }

        public class_1011 getStaticImage() {
            return this.staticImage;
        }

        public byte[] getGifData() {
            return this.gifData;
        }

        public void close() {
            if (this.staticImage != null) {
                this.staticImage.close();
            }
        }
    }
}

