/*
 * Decompiled with CFR 0.152.
 */
package com.bay4lly.photochat.network;

import com.bay4lly.photochat.PhotoChat;
import com.bay4lly.photochat.client.ClientImageManager;
import com.bay4lly.photochat.client.PhotoDownloader;
import com.bay4lly.photochat.util.Localization;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1011;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class NetworkHandlerClient {
    public static final class_2960 START_DOWNLOAD = new class_2960("photochat", "start_download");
    public static final class_2960 DOWNLOAD_CHUNK = new class_2960("photochat", "download_chunk");
    public static final class_2960 FINISH_DOWNLOAD = new class_2960("photochat", "finish_download");

    public static void registerClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)START_DOWNLOAD, (client, handler, buf, responseSender) -> {
            String imageId = buf.method_19772();
            int totalChunks = buf.readInt();
            client.execute(() -> PhotoDownloader.startDownload(imageId, totalChunks));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)DOWNLOAD_CHUNK, (client, handler, buf, responseSender) -> {
            String imageId = buf.method_19772();
            int chunkIndex = buf.readInt();
            byte[] data = buf.method_10795();
            client.execute(() -> PhotoDownloader.receiveChunk(imageId, chunkIndex, data));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FINISH_DOWNLOAD, (client, handler, buf, responseSender) -> {
            String imageId = buf.method_19772();
            client.execute(() -> {
                class_1011 img = PhotoDownloader.finishDownload(imageId);
                if (img != null) {
                    ClientImageManager.putImage(imageId, img);
                    PhotoChat.LOGGER.info(Localization.translate("log.client.photo_saved_to_memory", imageId));
                } else {
                    PhotoChat.LOGGER.error(Localization.translate("log.client.photo_assemble_failed", imageId));
                }
            });
        });
    }
}

