/*
 * Decompiled with CFR 0.152.
 */
package com.bay4lly.photochat.network;

import com.bay4lly.photochat.PhotoChat;
import com.bay4lly.photochat.util.Localization;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_3222;

public class PhotoAssembler {
    private static final Map<UUID, InProgressPhoto> IN_PROGRESS_PHOTOS = Maps.newHashMap();

    public static void onUploadStart(class_3222 player, UUID photoId, int totalChunks) {
        IN_PROGRESS_PHOTOS.put(photoId, new InProgressPhoto(player, totalChunks));
        PhotoChat.LOGGER.info(Localization.translate("log.server.receiving_started", photoId, player.method_5477().getString(), totalChunks));
    }

    public static void onChunk(UUID photoId, int chunkIndex, byte[] data) {
        InProgressPhoto photo = IN_PROGRESS_PHOTOS.get(photoId);
        if (photo != null) {
            photo.addChunk(chunkIndex, data);
        } else {
            PhotoChat.LOGGER.warn(Localization.translate("log.server.received_chunk_unknown_id", photoId));
        }
    }

    public static byte[] onUploadFinish(UUID photoId) {
        InProgressPhoto photo = IN_PROGRESS_PHOTOS.remove(photoId);
        if (photo != null && photo.isComplete()) {
            PhotoChat.LOGGER.info(Localization.translate("log.server.finished_receiving", photoId));
            return photo.reassemble();
        }
        if (photo != null) {
            PhotoChat.LOGGER.error(Localization.translate("log.server.incomplete_discard", photoId));
        } else {
            PhotoChat.LOGGER.error(Localization.translate("log.server.finished_unknown_id", photoId));
        }
        return null;
    }

    private static class InProgressPhoto {
        private final class_3222 sender;
        private final int totalChunks;
        private final byte[][] chunks;
        private int receivedChunks = 0;

        InProgressPhoto(class_3222 sender, int totalChunks) {
            this.sender = sender;
            this.totalChunks = totalChunks;
            this.chunks = new byte[totalChunks][];
        }

        void addChunk(int index, byte[] data) {
            if (index >= 0 && index < this.totalChunks && this.chunks[index] == null) {
                this.chunks[index] = data;
                ++this.receivedChunks;
            } else {
                PhotoChat.LOGGER.warn(Localization.translate("log.server.invalid_chunk_index", index, this.sender.method_5477().getString()));
            }
        }

        boolean isComplete() {
            return this.receivedChunks == this.totalChunks;
        }

        byte[] reassemble() {
            int totalSize = 0;
            for (byte[] chunk : this.chunks) {
                if (chunk == null) {
                    return null;
                }
                totalSize += chunk.length;
            }
            byte[] fullData = new byte[totalSize];
            int currentPos = 0;
            for (byte[] chunk : this.chunks) {
                System.arraycopy(chunk, 0, fullData, currentPos, chunk.length);
                currentPos += chunk.length;
            }
            return fullData;
        }

        public class_3222 getSender() {
            return this.sender;
        }
    }
}

